/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.time.Clock;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.UserManager;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicLoginContext;
import org.neo4j.server.security.auth.LegacyCredential;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;
import org.neo4j.string.UTF8;

public class BasicAuthManager
implements AuthManager,
UserManager,
UserManagerSupplier {
    protected final AuthenticationStrategy authStrategy;
    protected final UserRepository userRepository;
    protected final PasswordPolicy passwordPolicy;
    private final UserRepository initialUserRepository;

    public BasicAuthManager(UserRepository userRepository, PasswordPolicy passwordPolicy, AuthenticationStrategy authStrategy, UserRepository initialUserRepository) {
        this.userRepository = userRepository;
        this.passwordPolicy = passwordPolicy;
        this.authStrategy = authStrategy;
        this.initialUserRepository = initialUserRepository;
    }

    public BasicAuthManager(UserRepository userRepository, PasswordPolicy passwordPolicy, Clock clock, UserRepository initialUserRepository, Config config) {
        this(userRepository, passwordPolicy, BasicAuthManager.createAuthenticationStrategy(clock, config), initialUserRepository);
    }

    public void init() throws Throwable {
        this.userRepository.init();
        this.initialUserRepository.init();
    }

    public void start() throws Throwable {
        this.userRepository.start();
        this.initialUserRepository.start();
        if (this.userRepository.numberOfUsers() == 0) {
            User user;
            User neo4j = this.newUser("neo4j", UTF8.encode((String)"neo4j"), true);
            if (this.initialUserRepository.numberOfUsers() > 0 && (user = this.initialUserRepository.getUserByName("neo4j")) != null) {
                this.userRepository.update(neo4j, user);
            }
        }
    }

    public void stop() throws Throwable {
        this.userRepository.stop();
        this.initialUserRepository.stop();
    }

    public void shutdown() throws Throwable {
        this.userRepository.shutdown();
        this.initialUserRepository.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginContext login(Map<String, Object> authToken) throws InvalidAuthTokenException {
        try {
            this.assertValidScheme(authToken);
            String username = AuthToken.safeCast((String)"principal", authToken);
            byte[] password = AuthToken.safeCastCredentials((String)"credentials", authToken);
            User user = this.userRepository.getUserByName(username);
            AuthenticationResult result = AuthenticationResult.FAILURE;
            if (user != null && (result = this.authStrategy.authenticate(user, password)) == AuthenticationResult.SUCCESS && user.passwordChangeRequired()) {
                result = AuthenticationResult.PASSWORD_CHANGE_REQUIRED;
            }
            BasicLoginContext basicLoginContext = new BasicLoginContext(user, result);
            return basicLoginContext;
        }
        finally {
            AuthToken.clearCredentials(authToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User newUser(String username, byte[] initialPassword, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        try {
            this.userRepository.assertValidUsername(username);
            this.passwordPolicy.validatePassword(initialPassword);
            User user = new User.Builder().withName(username).withCredentials((Credential)LegacyCredential.forPassword(initialPassword)).withRequiredPasswordChange(requirePasswordChange).build();
            this.userRepository.create(user);
            User user2 = user;
            return user2;
        }
        finally {
            if (initialPassword != null) {
                Arrays.fill(initialPassword, (byte)0);
            }
        }
    }

    public boolean deleteUser(String username) throws IOException, InvalidArgumentsException {
        User user = this.getUser(username);
        return user != null && this.userRepository.delete(user);
    }

    public User getUser(String username) throws InvalidArgumentsException {
        User user = this.userRepository.getUserByName(username);
        if (user == null) {
            throw new InvalidArgumentsException("User '" + username + "' does not exist.");
        }
        return user;
    }

    public User silentlyGetUser(String username) {
        return this.userRepository.getUserByName(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserPassword(String username, byte[] password, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        try {
            User existingUser = this.getUser(username);
            this.passwordPolicy.validatePassword(password);
            if (existingUser.credentials().matchesPassword(password)) {
                throw new InvalidArgumentsException("Old password and new password cannot be the same.");
            }
            try {
                User updatedUser = existingUser.augment().withCredentials((Credential)LegacyCredential.forPassword(password)).withRequiredPasswordChange(requirePasswordChange).build();
                this.userRepository.update(existingUser, updatedUser);
            }
            catch (ConcurrentModificationException e) {
                this.setUserPassword(username, password, requirePasswordChange);
            }
        }
        finally {
            if (password != null) {
                Arrays.fill(password, (byte)0);
            }
        }
    }

    public Set<String> getAllUsernames() {
        return this.userRepository.getAllUsernames();
    }

    public UserManager getUserManager(AuthSubject authSubject, boolean isUserManager) {
        return this;
    }

    public UserManager getUserManager() {
        return this;
    }

    private void assertValidScheme(Map<String, Object> token) throws InvalidAuthTokenException {
        String scheme = AuthToken.safeCast((String)"scheme", token);
        if (scheme.equals("none")) {
            throw AuthToken.invalidToken((String)", scheme 'none' is only allowed when auth is disabled.");
        }
        if (!scheme.equals("basic")) {
            throw AuthToken.invalidToken((String)(", scheme '" + scheme + "' is not supported."));
        }
    }

    private static AuthenticationStrategy createAuthenticationStrategy(Clock clock, Config config) {
        return new RateLimitedAuthenticationStrategy(clock, config);
    }
}

