/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.File;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.Log;

public interface FileRepository {
    public static File getMigratedFile(File file) {
        return new File(file.getParent(), file.getName() + ".migrated");
    }

    public static void assertNotMigrated(File file, FileSystemAbstraction fileSystem, Log log) {
        File migratedFile = FileRepository.getMigratedFile(file);
        if (fileSystem.fileExists(migratedFile)) {
            String message = "The repository file '" + file.getAbsolutePath() + "' has been marked as migrated. If you are sure that you want use this repository you need to manually rename the file '" + migratedFile.getAbsolutePath() + "' to '" + file.getName() + "'";
            log.error(message);
            throw new IllegalStateException(message);
        }
    }
}

