/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.server.security.auth.exception.FormatException;
import org.neo4j.string.UTF8;

public abstract class FileRepositorySerializer<S> {
    private Random random = new SecureRandom();

    public static void writeToFile(FileSystemAbstraction fs, File file, byte[] bytes) throws IOException {
        try (OutputStream o = fs.openAsOutputStream(file, false);){
            o.write(bytes);
        }
    }

    public static List<String> readFromFile(FileSystemAbstraction fs, File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader r = new BufferedReader(fs.openAsReader(file, Charset.forName("UTF-8")));){
            String line;
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    public void saveRecordsToFile(FileSystemAbstraction fileSystem, File recordsFile, Collection<S> records) throws IOException {
        File tempFile = this.getTempFile(fileSystem, recordsFile);
        try {
            FileRepositorySerializer.writeToFile(fileSystem, tempFile, this.serialize(records));
            fileSystem.renameFile(tempFile, recordsFile, new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING});
        }
        catch (Throwable e) {
            fileSystem.deleteFile(tempFile);
            throw e;
        }
    }

    protected File getTempFile(FileSystemAbstraction fileSystem, File recordsFile) throws IOException {
        long n;
        File directory = recordsFile.getParentFile();
        if (!fileSystem.fileExists(directory)) {
            fileSystem.mkdirs(directory);
        }
        n = (n = this.random.nextLong()) == Long.MIN_VALUE ? 0L : Math.abs(n);
        return new File(directory, Long.toString(n) + "_" + recordsFile.getName() + ".tmp");
    }

    public List<S> loadRecordsFromFile(FileSystemAbstraction fileSystem, File recordsFile) throws IOException, FormatException {
        return this.deserializeRecords(FileRepositorySerializer.readFromFile(fileSystem, recordsFile));
    }

    public byte[] serialize(Collection<S> records) {
        StringBuilder sb = new StringBuilder();
        for (S record : records) {
            sb.append(this.serialize(record)).append("\n");
        }
        return UTF8.encode((String)sb.toString());
    }

    public List<S> deserializeRecords(byte[] bytes) throws FormatException {
        return this.deserializeRecords(Arrays.asList(UTF8.decode((byte[])bytes).split("\n")));
    }

    public List<S> deserializeRecords(List<String> lines) throws FormatException {
        ArrayList<S> out = new ArrayList<S>();
        int lineNumber = 1;
        for (String line : lines) {
            if (line.trim().length() > 0) {
                out.add(this.deserializeRecord(line, lineNumber));
            }
            ++lineNumber;
        }
        return out;
    }

    protected abstract String serialize(S var1);

    protected abstract S deserializeRecord(String var1, int var2) throws FormatException;
}

