/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import org.neo4j.server.security.auth.AuthSubject;
import org.neo4j.server.security.auth.AuthenticationResult;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.exception.IllegalCredentialsException;

public interface AuthManager {
    public static final AuthManager NO_AUTH = new AuthManager(){

        @Override
        public AuthenticationResult authenticate(String username, String password) {
            return AuthenticationResult.SUCCESS;
        }

        @Override
        public AuthSubject login(String username, String password) {
            return new AuthSubject(){

                @Override
                public void logout() {
                }

                @Override
                public AuthenticationResult getAuthenticationResult() {
                    return AuthenticationResult.SUCCESS;
                }

                @Override
                public void setPassword(String password) throws IOException, IllegalCredentialsException {
                }

                public boolean allowsReads() {
                    return true;
                }

                public boolean allowsWrites() {
                    return true;
                }

                public boolean allowsSchemaWrites() {
                    return true;
                }

                public String name() {
                    return "";
                }
            };
        }

        @Override
        public User newUser(String username, String initialPassword, boolean requirePasswordChange) throws IOException, IllegalCredentialsException {
            return new User.Builder().withName(username).withCredentials(Credential.forPassword(initialPassword)).withRequiredPasswordChange(requirePasswordChange).build();
        }

        @Override
        public boolean deleteUser(String username) throws IOException {
            return true;
        }

        @Override
        public User getUser(String username) {
            return new User.Builder().withName(username).build();
        }

        @Override
        public User setPassword(String username, String password) throws IOException {
            return new User.Builder().withName(username).withCredentials(Credential.forPassword(password)).build();
        }
    };

    public AuthenticationResult authenticate(String var1, String var2);

    public AuthSubject login(String var1, String var2);

    public User newUser(String var1, String var2, boolean var3) throws IOException, IllegalCredentialsException;

    public boolean deleteUser(String var1) throws IOException;

    public User getUser(String var1);

    public User setPassword(String var1, String var2) throws IOException;
}

