/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.UserSerialization;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;
import org.neo4j.server.security.auth.exception.IllegalCredentialsException;

public class FileUserRepository
extends LifecycleAdapter
implements UserRepository {
    private final Path authFile;
    private final Map<String, User> usersByName = new ConcurrentHashMap<String, User>();
    private final Log log;
    private volatile List<User> users = new ArrayList<User>();
    private final UserSerialization serialization = new UserSerialization();

    public FileUserRepository(Path file, LogProvider logProvider) {
        this.authFile = file.toAbsolutePath();
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public User findByName(String name) {
        return this.usersByName.get(name);
    }

    public void start() throws Throwable {
        if (Files.exists(this.authFile, new LinkOption[0])) {
            this.loadUsersFromFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(User user) throws IllegalCredentialsException, IOException {
        if (!this.isValidName(user.name())) {
            throw new IllegalCredentialsException("'" + user.name() + "' is not a valid user name.");
        }
        FileUserRepository fileUserRepository = this;
        synchronized (fileUserRepository) {
            for (User other : this.users) {
                if (!other.name().equals(user.name())) continue;
                throw new IllegalCredentialsException("The specified user already exists");
            }
            this.users.add(user);
            this.saveUsersToFile();
            this.usersByName.put(user.name(), user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(User existingUser, User updatedUser) throws ConcurrentModificationException, IOException {
        if (!existingUser.name().equals(updatedUser.name())) {
            throw new IllegalArgumentException("updatedUser has a different name");
        }
        FileUserRepository fileUserRepository = this;
        synchronized (fileUserRepository) {
            ArrayList<User> newUsers = new ArrayList<User>();
            boolean foundUser = false;
            for (User other : this.users) {
                if (other.equals(existingUser)) {
                    foundUser = true;
                    newUsers.add(updatedUser);
                    continue;
                }
                newUsers.add(other);
            }
            if (!foundUser) {
                throw new ConcurrentModificationException();
            }
            this.users = newUsers;
            this.saveUsersToFile();
            this.usersByName.put(updatedUser.name(), updatedUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(User user) throws IOException {
        boolean foundUser = false;
        FileUserRepository fileUserRepository = this;
        synchronized (fileUserRepository) {
            ArrayList<User> newUsers = new ArrayList<User>();
            for (User other : this.users) {
                if (other.name().equals(user.name())) {
                    foundUser = true;
                    continue;
                }
                newUsers.add(other);
            }
            if (foundUser) {
                this.users = newUsers;
                this.saveUsersToFile();
                this.usersByName.remove(user.name());
            }
        }
        return foundUser;
    }

    @Override
    public int numberOfUsers() {
        return this.users.size();
    }

    @Override
    public boolean isValidName(String name) {
        return name.matches("^[a-zA-Z0-9_]+$");
    }

    private void saveUsersToFile() throws IOException {
        Path directory = this.authFile.getParent();
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        Path tempFile = Files.createTempFile(directory, this.authFile.getFileName().toString() + "-", ".tmp", new FileAttribute[0]);
        try {
            Files.write(tempFile, this.serialization.serialize(this.users), new OpenOption[0]);
            Files.move(tempFile, this.authFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable e) {
            Files.delete(tempFile);
            throw e;
        }
    }

    private void loadUsersFromFile() throws IOException {
        List<User> loadedUsers;
        byte[] fileBytes = Files.readAllBytes(this.authFile);
        try {
            loadedUsers = this.serialization.deserializeUsers(fileBytes);
        }
        catch (UserSerialization.FormatException e) {
            this.log.error("Ignoring authorization file \"%s\" (%s)", new Object[]{this.authFile.toAbsolutePath(), e.getMessage()});
            loadedUsers = new ArrayList<User>();
        }
        if (loadedUsers == null) {
            throw new IllegalStateException("Failed to read authentication file: " + this.authFile);
        }
        this.users = loadedUsers;
        for (User user : this.users) {
            this.usersByName.put(user.name(), user);
        }
    }
}

