/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class ExtremeValuesLibrary {
    private static final int MAX_ALPHA_NUMERIC_CODE_POINT = 122;
    private static final String MAX_CODE_POINT_STRING = new String(new int[]{0x10FFFF}, 0, 1);
    private static final String MAX_ALPHA_NUMERIC_CODE_POINT_STRING = new String(new int[]{122}, 0, 1);
    private static final String MAX_ASCII_CODE_POINT_STRING = new String(new int[]{127}, 0, 1);
    private static final String MAX_BMP_CODE_POINT_STRING = new String(new int[]{65535}, 0, 1);
    static final Value[] EXTREME_BOOLEAN = new Value[]{Values.booleanValue((boolean)false), Values.booleanValue((boolean)true)};
    static final Value[] EXTREME_BYTE = new Value[]{Values.byteValue((byte)-128), Values.byteValue((byte)127), Values.byteValue((byte)0)};
    static final Value[] EXTREME_SHORT = new Value[]{Values.shortValue((short)Short.MIN_VALUE), Values.shortValue((short)Short.MAX_VALUE), Values.shortValue((short)0)};
    static final Value[] EXTREME_INT = new Value[]{Values.intValue((int)Integer.MIN_VALUE), Values.intValue((int)Integer.MAX_VALUE), Values.intValue((int)0)};
    static final Value[] EXTREME_LONG = new Value[]{Values.longValue((long)Long.MIN_VALUE), Values.longValue((long)Long.MAX_VALUE), Values.longValue((long)0L)};
    static final Value[] EXTREME_FLOAT = new Value[]{Values.floatValue((float)Float.MIN_VALUE), Values.floatValue((float)Float.MAX_VALUE), Values.floatValue((float)-1.4E-45f), Values.floatValue((float)-3.4028235E38f), Values.floatValue((float)0.0f)};
    static final Value[] EXTREME_DOUBLE = new Value[]{Values.doubleValue((double)Double.MIN_VALUE), Values.doubleValue((double)Double.MAX_VALUE), Values.doubleValue((double)-4.9E-324), Values.doubleValue((double)-1.7976931348623157E308), Values.doubleValue((double)0.0)};
    static final Value[] EXTREME_CHAR = new Value[]{Values.charValue((char)'\uffff'), Values.charValue((char)'\u0000')};
    static final Value[] EXTREME_STRING = new Value[]{Values.stringValue((String)MAX_CODE_POINT_STRING), Values.stringValue((String)"")};
    static final Value[] EXTREME_STRING_ALPHANUMERIC = new Value[]{Values.stringValue((String)MAX_ALPHA_NUMERIC_CODE_POINT_STRING), Values.stringValue((String)"")};
    static final Value[] EXTREME_STRING_ASCII = new Value[]{Values.stringValue((String)MAX_ASCII_CODE_POINT_STRING), Values.stringValue((String)"")};
    static final Value[] EXTREME_STRING_BMP = new Value[]{Values.stringValue((String)MAX_BMP_CODE_POINT_STRING), Values.stringValue((String)"")};
    static final Value[] EXTREME_LOCAL_DATE_TIME = new Value[]{LocalDateTimeValue.MIN_VALUE, LocalDateTimeValue.MAX_VALUE};
    static final Value[] EXTREME_DATE = new Value[]{DateValue.MIN_VALUE, DateValue.MAX_VALUE};
    static final Value[] EXTREME_LOCAL_TIME = new Value[]{LocalTimeValue.MIN_VALUE, LocalTimeValue.MAX_VALUE};
    static final Value[] EXTREME_PERIOD = new Value[]{DurationValue.MIN_VALUE, DurationValue.MAX_VALUE};
    static final Value[] EXTREME_DURATION = new Value[]{DurationValue.MIN_VALUE, DurationValue.MAX_VALUE};
    static final Value[] EXTREME_TIME = new Value[]{TimeValue.MIN_VALUE, TimeValue.MAX_VALUE};
    static final Value[] EXTREME_DATE_TIME = new Value[]{DateTimeValue.MIN_VALUE, DateTimeValue.MAX_VALUE};
    static final Value[] EXTREME_CARTESIAN_POINT = new Value[]{PointValue.MIN_VALUE_CARTESIAN, PointValue.MAX_VALUE_CARTESIAN};
    static final Value[] EXTREME_CARTESIAN_POINT_3D = new Value[]{PointValue.MIN_VALUE_CARTESIAN_3D, PointValue.MAX_VALUE_CARTESIAN_3D};
    static final Value[] EXTREME_GEOGRAPHIC_POINT = new Value[]{PointValue.MIN_VALUE_WGS_84, PointValue.MAX_VALUE_WGS_84};
    static final Value[] EXTREME_GEOGRAPHIC_POINT_3D = new Value[]{PointValue.MIN_VALUE_WGS_84_3D, PointValue.MAX_VALUE_WGS_84_3D};
    static final Value[] EXTREME_BOOLEAN_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY), Values.of((Object)new boolean[]{true})};
    static final Value[] EXTREME_BYTE_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_BYTE_ARRAY), Values.of((Object)new byte[]{127})};
    static final Value[] EXTREME_SHORT_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_SHORT_ARRAY), Values.of((Object)new short[]{Short.MAX_VALUE})};
    static final Value[] EXTREME_INT_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_INT_ARRAY), Values.of((Object)new int[]{Integer.MAX_VALUE})};
    static final Value[] EXTREME_LONG_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_LONG_ARRAY), Values.of((Object)new long[]{Long.MAX_VALUE})};
    static final Value[] EXTREME_FLOAT_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_FLOAT_ARRAY), Values.of((Object)new float[]{Float.MAX_VALUE})};
    static final Value[] EXTREME_DOUBLE_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY), Values.of((Object)new double[]{Double.MAX_VALUE})};
    static final Value[] EXTREME_CHAR_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_CHAR_ARRAY), Values.of((Object)new char[]{'\uffff'})};
    static final Value[] EXTREME_STRING_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_STRING_ARRAY), Values.of((Object)new String[]{MAX_CODE_POINT_STRING})};
    static final Value[] EXTREME_STRING_ALPHANUMERIC_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_STRING_ARRAY), Values.of((Object)new String[]{MAX_ALPHA_NUMERIC_CODE_POINT_STRING})};
    static final Value[] EXTREME_STRING_ASCII_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_STRING_ARRAY), Values.of((Object)new String[]{MAX_ASCII_CODE_POINT_STRING})};
    static final Value[] EXTREME_STRING_BMP_ARRAY = new Value[]{Values.of((Object)ArrayUtils.EMPTY_STRING_ARRAY), Values.of((Object)new String[]{MAX_BMP_CODE_POINT_STRING})};
    static final Value[] EXTREME_LOCAL_DATE_TIME_ARRAY = new Value[]{Values.of((Object)new LocalDateTime[0]), Values.of((Object)new LocalDateTime[]{LocalDateTime.MAX})};
    static final Value[] EXTREME_DATE_ARRAY = new Value[]{Values.of((Object)new LocalDate[0]), Values.of((Object)new LocalDate[]{LocalDate.MAX})};
    static final Value[] EXTREME_LOCAL_TIME_ARRAY = new Value[]{Values.of((Object)new LocalTime[0]), Values.of((Object)new LocalTime[]{LocalTime.MAX})};
    static final Value[] EXTREME_PERIOD_ARRAY = new Value[]{Values.of((Object)new DurationValue[0]), Values.of((Object)new DurationValue[]{DurationValue.MAX_VALUE})};
    static final Value[] EXTREME_DURATION_ARRAY = new Value[]{Values.of((Object)new DurationValue[0]), Values.of((Object)new DurationValue[]{DurationValue.MAX_VALUE})};
    static final Value[] EXTREME_TIME_ARRAY = new Value[]{Values.of((Object)new OffsetTime[0]), Values.of((Object)new OffsetTime[]{OffsetTime.MAX})};
    static final Value[] EXTREME_DATE_TIME_ARRAY = new Value[]{Values.of((Object)new ZonedDateTime[0]), Values.of((Object)new ZonedDateTime[]{ZonedDateTime.of(LocalDateTime.MAX, ZoneOffset.MAX)})};
    static final Value[] EXTREME_CARTESIAN_POINT_ARRAY = new Value[]{Values.of((Object)new PointValue[0]), Values.of((Object)new PointValue[]{PointValue.MAX_VALUE_CARTESIAN})};
    static final Value[] EXTREME_CARTESIAN_POINT_3D_ARRAY = new Value[]{Values.of((Object)new PointValue[0]), Values.of((Object)new PointValue[]{PointValue.MAX_VALUE_CARTESIAN_3D})};
    static final Value[] EXTREME_GEOGRAPHIC_POINT_ARRAY = new Value[]{Values.of((Object)new PointValue[0]), Values.of((Object)new PointValue[]{PointValue.MAX_VALUE_WGS_84})};
    static final Value[] EXTREME_GEOGRAPHIC_POINT_3D_ARRAY = new Value[]{Values.of((Object)new PointValue[0]), Values.of((Object)new PointValue[]{PointValue.MAX_VALUE_WGS_84_3D})};

    private ExtremeValuesLibrary() {
    }
}

