/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;

public class RandomSupport {
    private long globalSeed;
    private long seed;
    private boolean hasGlobalSeed;
    private Random random;
    private RandomValues randoms;
    private RandomValues.Configuration config = RandomValues.DEFAULT_CONFIGURATION;

    public RandomSupport withConfiguration(RandomValues.Configuration config) {
        this.config = config;
        return this;
    }

    public RandomSupport withSeedForAllTests(long seed) {
        this.hasGlobalSeed = true;
        this.globalSeed = seed;
        return this;
    }

    public byte[] nextBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
        return bytes;
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public DoubleStream doubles(int dimension, double minValue, double maxValue) {
        return this.random.doubles(dimension, minValue, maxValue);
    }

    public float nextFloat() {
        return this.random.nextFloat();
    }

    public int nextInt() {
        return this.random.nextInt();
    }

    public int nextInt(int n) {
        return this.random.nextInt(n);
    }

    public int nextInt(int origin, int bound) {
        return this.random.nextInt(bound - origin + 1) + origin;
    }

    public IntStream ints(long streamSize) {
        return this.random.ints(streamSize);
    }

    public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        return this.random.ints(streamSize, randomNumberOrigin, randomNumberBound);
    }

    public double nextGaussian() {
        return this.random.nextGaussian();
    }

    public long nextLong() {
        return this.random.nextLong();
    }

    public long nextLong(long n) {
        return Math.abs(this.nextLong()) % n;
    }

    public long nextLong(long origin, long bound) {
        return this.nextLong(bound - origin + 1L) + origin;
    }

    public int intBetween(int min, int max) {
        return this.randoms.intBetween(min, max);
    }

    public String nextString() {
        return this.nextTextValue().stringValue();
    }

    public TextValue nextTextValue() {
        return this.randoms.nextTextValue();
    }

    public String nextAlphaNumericString() {
        return this.nextAlphaNumericTextValue().stringValue();
    }

    public String nextAsciiString() {
        return this.nextAsciiTextValue().stringValue();
    }

    private TextValue nextAsciiTextValue() {
        return this.randoms.nextAsciiTextValue();
    }

    public TextValue nextAlphaNumericTextValue() {
        return this.randoms.nextAlphaNumericTextValue();
    }

    public String nextAlphaNumericString(int minLength, int maxLength) {
        return this.nextAlphaNumericTextValue(minLength, maxLength).stringValue();
    }

    public TextValue nextAlphaNumericTextValue(int minLength, int maxLength) {
        return this.randoms.nextAlphaNumericTextValue(minLength, maxLength);
    }

    public TextValue nextBasicMultilingualPlaneTextValue() {
        return this.randoms.nextBasicMultilingualPlaneTextValue();
    }

    public String nextBasicMultilingualPlaneString() {
        return this.nextBasicMultilingualPlaneTextValue().stringValue();
    }

    public <T> T[] selection(T[] among, int min, int max, boolean allowDuplicates) {
        return this.randoms.selection(among, min, max, allowDuplicates);
    }

    public int[] selection(int[] among, int min, int max, boolean allowDuplicates) {
        return this.randoms.selection(among, min, max, allowDuplicates);
    }

    public long[] selection(long[] among, int min, int max, boolean allowDuplicates) {
        return this.randoms.selection(among, min, max, allowDuplicates);
    }

    @SafeVarargs
    public final <T> T among(T ... among) {
        return this.randoms.among(among);
    }

    public long among(long[] among) {
        return this.randoms.among(among);
    }

    public int among(int[] among) {
        return this.randoms.among(among);
    }

    public <T> T among(List<T> among) {
        return this.randoms.among(among);
    }

    public <T> void among(List<T> among, Consumer<T> action) {
        this.randoms.among(among, action);
    }

    public Object nextValueAsObject() {
        return this.randoms.nextValue().asObject();
    }

    public Value nextValue() {
        return this.randoms.nextValue();
    }

    public Value nextValue(ValueType type) {
        return this.randoms.nextValueOfType(type);
    }

    public ArrayValue nextArray() {
        return this.randoms.nextArray();
    }

    public void reset() {
        this.random = new Random(this.seed);
        this.randoms = RandomValues.create(this.random, this.config);
    }

    public long seed() {
        return this.seed;
    }

    public Random random() {
        return this.random;
    }

    public RandomValues randomValues() {
        return this.randoms;
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.reset();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Seed {
        public long value();
    }
}

