/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.AnnotationSupport;
import org.neo4j.test.extension.StatefullFieldExtension;
import org.neo4j.test.rule.RandomRule;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.TestAbortedException;

public class RandomExtension
extends StatefullFieldExtension<RandomRule>
implements BeforeEachCallback,
AfterEachCallback,
TestExecutionExceptionHandler {
    private static final String RANDOM = "random";
    private static final ExtensionContext.Namespace RANDOM_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"random"});

    protected String getFieldKey() {
        return RANDOM;
    }

    protected Class<RandomRule> getFieldType() {
        return RandomRule.class;
    }

    protected ExtensionContext.Namespace getNameSpace() {
        return RANDOM_NAMESPACE;
    }

    protected RandomRule createField(ExtensionContext extensionContext) {
        RandomRule randomRule = new RandomRule();
        randomRule.setSeed(System.currentTimeMillis());
        return randomRule;
    }

    public void beforeEach(ExtensionContext extensionContext) {
        Optional optionalSeed = AnnotationSupport.findAnnotation((Optional)extensionContext.getElement(), RandomRule.Seed.class);
        optionalSeed.map(RandomRule.Seed::value).ifPresent(seed -> ((RandomRule)this.getStoredValue(extensionContext)).setSeed((long)seed));
    }

    public void afterEach(ExtensionContext context) {
        this.removeStoredValue(context);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable t) {
        if (t instanceof TestAbortedException) {
            return;
        }
        long seed = ((RandomRule)this.getStoredValue(context)).seed();
        throw new AssertionFailedError(String.format("%s [ random seed used: %dL ]", t.getMessage(), seed), t);
    }
}

