/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.Generator;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.RandomGenerator;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.SplittableRandomGenerator;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.UTF8StringValueBuilder;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public class RandomValues {
    private static final int MAX_ASCII_CODE_POINT = 127;
    public static final int MAX_BMP_CODE_POINT = 65535;
    public static final Configuration DEFAULT_CONFIGURATION = new Default();
    private static final Type[] ALL_TYPES = Type.values();
    private static final Type[] ARRAY_TYPES = Type.arrayTypes();
    private static final long NANOS_PER_SECOND = 1000000000L;
    private final Generator generator;
    private final Configuration configuration;

    private RandomValues(Generator generator) {
        this(generator, DEFAULT_CONFIGURATION);
    }

    private RandomValues(Generator generator, Configuration configuration) {
        this.generator = generator;
        this.configuration = configuration;
    }

    public static RandomValues create() {
        return new RandomValues(new RandomGenerator(ThreadLocalRandom.current()));
    }

    public static RandomValues create(Configuration configuration) {
        return new RandomValues(new RandomGenerator(ThreadLocalRandom.current()), configuration);
    }

    public static RandomValues create(Random random, Configuration configuration) {
        return new RandomValues(new RandomGenerator(random), configuration);
    }

    public static RandomValues create(Random random) {
        return new RandomValues(new RandomGenerator(random));
    }

    public static RandomValues create(SplittableRandom random, Configuration configuration) {
        return new RandomValues(new SplittableRandomGenerator(random), configuration);
    }

    public static RandomValues create(SplittableRandom random) {
        return new RandomValues(new SplittableRandomGenerator(random));
    }

    public Value nextValue() {
        return this.nextValueOfType(this.among(ALL_TYPES));
    }

    public Value nextValueOfTypes(Type ... types) {
        return this.nextValueOfType(this.among(types));
    }

    public static Type[] excluding(Type ... exclude) {
        return RandomValues.excluding(Type.values(), exclude);
    }

    public static Type[] excluding(Type[] among, Type ... exclude) {
        return (Type[])Arrays.stream(among).filter(t -> !ArrayUtils.contains((Object[])exclude, (Object)t)).toArray(Type[]::new);
    }

    public Value nextValueOfType(Type type) {
        switch (type) {
            case BOOLEAN: {
                return this.nextBooleanValue();
            }
            case BYTE: {
                return this.nextByteValue();
            }
            case SHORT: {
                return this.nextShortValue();
            }
            case STRING: {
                return this.nextTextValue();
            }
            case INT: {
                return this.nextIntValue();
            }
            case LONG: {
                return this.nextLongValue();
            }
            case FLOAT: {
                return this.nextFloatValue();
            }
            case DOUBLE: {
                return this.nextDoubleValue();
            }
            case CHAR: {
                return this.nextCharValue();
            }
            case STRING_ALPHANUMERIC: {
                return this.nextAlphaNumericTextValue();
            }
            case STRING_ASCII: {
                return this.nextAsciiTextValue();
            }
            case STRING_BMP: {
                return this.nextBasicMultilingualPlaneTextValue();
            }
            case LOCAL_DATE_TIME: {
                return this.nextLocalDateTimeValue();
            }
            case DATE: {
                return this.nextDateValue();
            }
            case LOCAL_TIME: {
                return this.nextLocalTimeValue();
            }
            case PERIOD: {
                return this.nextPeriod();
            }
            case DURATION: {
                return this.nextDuration();
            }
            case TIME: {
                return this.nextTimeValue();
            }
            case DATE_TIME: {
                return this.nextDateTimeValue();
            }
            case CARTESIAN_POINT: {
                return this.nextCartesianPoint();
            }
            case CARTESIAN_POINT_3D: {
                return this.nextCartesian3DPoint();
            }
            case GEOGRAPHIC_POINT: {
                return this.nextGeographicPoint();
            }
            case GEOGRAPHIC_POINT_3D: {
                return this.nextGeographic3DPoint();
            }
            case BOOLEAN_ARRAY: {
                return this.nextBooleanArray();
            }
            case BYTE_ARRAY: {
                return this.nextByteArray();
            }
            case SHORT_ARRAY: {
                return this.nextShortArray();
            }
            case INT_ARRAY: {
                return this.nextIntArray();
            }
            case LONG_ARRAY: {
                return this.nextLongArray();
            }
            case FLOAT_ARRAY: {
                return this.nextFloatArray();
            }
            case DOUBLE_ARRAY: {
                return this.nextDoubleArray();
            }
            case CHAR_ARRAY: {
                return this.nextCharArray();
            }
            case STRING_ARRAY: {
                return this.nextTextArray();
            }
            case STRING_ALPHANUMERIC_ARRAY: {
                return this.nextAlphaNumericTextArray();
            }
            case STRING_ASCII_ARRAY: {
                return this.nextAsciiTextArray();
            }
            case STRING_BMP_ARRAY: {
                return this.nextBasicMultilingualPlaneTextArray();
            }
            case LOCAL_DATE_TIME_ARRAY: {
                return this.nextLocalDateTimeArray();
            }
            case DATE_ARRAY: {
                return this.nextDateArray();
            }
            case LOCAL_TIME_ARRAY: {
                return this.nextLocalTimeArray();
            }
            case PERIOD_ARRAY: {
                return this.nextPeriodArray();
            }
            case DURATION_ARRAY: {
                return this.nextDurationArray();
            }
            case TIME_ARRAY: {
                return this.nextTimeArray();
            }
            case DATE_TIME_ARRAY: {
                return this.nextDateTimeArray();
            }
            case CARTESIAN_POINT_ARRAY: {
                return this.nextCartesianPointArray();
            }
            case CARTESIAN_POINT_3D_ARRAY: {
                return this.nextCartesian3DPointArray();
            }
            case GEOGRAPHIC_POINT_ARRAY: {
                return this.nextGeographicPointArray();
            }
            case GEOGRAPHIC_POINT_3D_ARRAY: {
                return this.nextGeographic3DPointArray();
            }
        }
        throw new IllegalArgumentException("Unknown value type: " + (Object)((Object)type));
    }

    public ArrayValue nextArray() {
        return (ArrayValue)this.nextValueOfType(this.among(ARRAY_TYPES));
    }

    public BooleanValue nextBooleanValue() {
        return Values.booleanValue((boolean)this.generator.nextBoolean());
    }

    public boolean nextBoolean() {
        return this.generator.nextBoolean();
    }

    public ByteValue nextByteValue() {
        return Values.byteValue((byte)((byte)this.generator.nextInt()));
    }

    public ByteValue nextByteValue(byte bound) {
        return Values.byteValue((byte)((byte)this.generator.nextInt(bound)));
    }

    public ShortValue nextShortValue() {
        return Values.shortValue((short)((short)this.generator.nextInt()));
    }

    public ShortValue nextShortValue(short bound) {
        return Values.shortValue((short)((short)this.generator.nextInt(bound)));
    }

    public IntValue nextIntValue() {
        return Values.intValue((int)this.generator.nextInt());
    }

    public int nextInt() {
        return this.generator.nextInt();
    }

    public IntValue nextIntValue(int bound) {
        return Values.intValue((int)this.generator.nextInt(bound));
    }

    public int nextInt(int bound) {
        return this.generator.nextInt(bound);
    }

    public int intBetween(int min, int max) {
        return min + this.generator.nextInt(max - min + 1);
    }

    public long nextLong() {
        return this.generator.nextLong();
    }

    public long nextLong(long bound) {
        return Math.abs(this.generator.nextLong()) % bound;
    }

    private long longBetween(long min, long max) {
        return this.nextLong(max - min + 1L) + min;
    }

    public LongValue nextLongValue() {
        return Values.longValue((long)this.generator.nextLong());
    }

    public LongValue nextLongValue(long bound) {
        return Values.longValue((long)this.nextLong(bound));
    }

    public LongValue nextLongValue(long lower, long upper) {
        return Values.longValue((long)(this.nextLong(upper - lower + 1L) + lower));
    }

    public FloatValue nextFloatValue() {
        return Values.floatValue((float)this.generator.nextFloat());
    }

    public float nextFloat() {
        return this.generator.nextFloat();
    }

    public DoubleValue nextDoubleValue() {
        return Values.doubleValue((double)this.generator.nextDouble());
    }

    private double doubleBetween(double min, double max) {
        return this.generator.nextDouble() * (max - min) + min;
    }

    public NumberValue nextNumberValue() {
        int type = this.generator.nextInt(6);
        switch (type) {
            case 0: {
                return this.nextByteValue();
            }
            case 1: {
                return this.nextShortValue();
            }
            case 2: {
                return this.nextIntValue();
            }
            case 3: {
                return this.nextLongValue();
            }
            case 4: {
                return this.nextFloatValue();
            }
            case 5: {
                return this.nextDoubleValue();
            }
        }
        throw new IllegalArgumentException("Unknown value type " + type);
    }

    public CharValue nextCharValue() {
        return Values.charValue((char)this.nextCharRaw());
    }

    public char nextCharRaw() {
        int codePoint = this.bmpCodePoint();
        assert ((codePoint & 0xFFFF0000) == 0);
        return (char)codePoint;
    }

    public TextValue nextAlphaNumericTextValue() {
        return this.nextAlphaNumericTextValue(this.minString(), this.maxString());
    }

    public TextValue nextAlphaNumericTextValue(int minLength, int maxLength) {
        return this.nextTextValue(minLength, maxLength, this::alphaNumericCodePoint);
    }

    public TextValue nextAsciiTextValue() {
        return this.nextAsciiTextValue(this.minString(), this.maxString());
    }

    public TextValue nextAsciiTextValue(int minLength, int maxLength) {
        return this.nextTextValue(minLength, maxLength, this::asciiCodePoint);
    }

    public TextValue nextBasicMultilingualPlaneTextValue() {
        return this.nextTextValue(this.minString(), this.maxString(), this::bmpCodePoint);
    }

    public TextValue nextTextValue() {
        return this.nextTextValue(this.minString(), this.maxString());
    }

    public TextValue nextTextValue(int minLength, int maxLength) {
        return this.nextTextValue(minLength, maxLength, this::nextValidCodePoint);
    }

    private TextValue nextTextValue(int minLength, int maxLength, CodePointFactory codePointFactory) {
        int length = this.intBetween(minLength, maxLength);
        UTF8StringValueBuilder builder = new UTF8StringValueBuilder(RandomValues.nextPowerOf2(length));
        for (int i = 0; i < length; ++i) {
            builder.addCodePoint(codePointFactory.generate());
        }
        return builder.build();
    }

    private int nextValidCodePoint() {
        return this.nextValidCodePoint(this.configuration.maxCodePoint());
    }

    private int nextValidCodePoint(int maxCodePoint) {
        int codePoint;
        int type;
        while ((type = Character.getType(codePoint = this.intBetween(0, maxCodePoint))) == 0 || type == 18 || type == 19) {
        }
        return codePoint;
    }

    private int asciiCodePoint() {
        return this.nextValidCodePoint(127);
    }

    private int alphaNumericCodePoint() {
        int nextInt = this.generator.nextInt(4);
        if (nextInt == 0) {
            return this.intBetween(65, 90);
        }
        if (nextInt == 1) {
            return this.intBetween(97, 122);
        }
        return this.intBetween(48, 57);
    }

    private int bmpCodePoint() {
        return this.nextValidCodePoint(65535);
    }

    public TimeValue nextTimeValue() {
        return TimeValue.time((OffsetTime)this.nextTimeRaw());
    }

    public LocalDateTimeValue nextLocalDateTimeValue() {
        return LocalDateTimeValue.localDateTime((LocalDateTime)this.nextLocalDateTimeRaw());
    }

    public DateValue nextDateValue() {
        return DateValue.date((LocalDate)this.nextDateRaw());
    }

    public LocalTimeValue nextLocalTimeValue() {
        return LocalTimeValue.localTime((LocalTime)this.nextLocalTimeRaw());
    }

    public DateTimeValue nextDateTimeValue() {
        return this.nextDateTimeValue(ZoneOffset.UTC);
    }

    public DateTimeValue nextDateTimeValue(ZoneId zoneId) {
        return DateTimeValue.datetime((ZonedDateTime)this.nextZonedDateTimeRaw(zoneId));
    }

    public DurationValue nextPeriod() {
        return DurationValue.duration((Period)this.nextPeriodRaw());
    }

    public DurationValue nextDuration() {
        return DurationValue.duration((Duration)this.nextDurationRaw());
    }

    public Value nextTemporalValue() {
        int nextInt = this.generator.nextInt(6);
        switch (nextInt) {
            case 0: {
                return this.nextDateValue();
            }
            case 1: {
                return this.nextLocalDateTimeValue();
            }
            case 2: {
                return this.nextDateTimeValue();
            }
            case 3: {
                return this.nextLocalTimeValue();
            }
            case 4: {
                return this.nextTimeValue();
            }
            case 5: {
                return this.nextDuration();
            }
        }
        throw new IllegalArgumentException(nextInt + " not a valid temporal type");
    }

    public PointValue nextCartesianPoint() {
        double x = this.randomCartesianCoordinate();
        double y = this.randomCartesianCoordinate();
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{x, y});
    }

    public PointValue nextCartesian3DPoint() {
        double x = this.randomCartesianCoordinate();
        double y = this.randomCartesianCoordinate();
        double z = this.randomCartesianCoordinate();
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{x, y, z});
    }

    public PointValue nextGeographicPoint() {
        double longitude = this.randomLongitude();
        double latitude = this.randomLatitude();
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{longitude, latitude});
    }

    public PointValue nextGeographic3DPoint() {
        double longitude = this.randomLongitude();
        double latitude = this.randomLatitude();
        double z = this.randomCartesianCoordinate();
        return Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{longitude, latitude, z});
    }

    private double randomLatitude() {
        double spatialDefaultMinLatitude = -90.0;
        double spatialDefaultMaxLatitude = 90.0;
        return this.doubleBetween(spatialDefaultMinLatitude, spatialDefaultMaxLatitude);
    }

    private double randomLongitude() {
        double spatialDefaultMinLongitude = -180.0;
        double spatialDefaultMaxLongitude = 180.0;
        return this.doubleBetween(spatialDefaultMinLongitude, spatialDefaultMaxLongitude);
    }

    private double randomCartesianCoordinate() {
        double spatialDefaultMinExtent = -1000000.0;
        double spatialDefaultMaxExtent = 1000000.0;
        return this.doubleBetween(spatialDefaultMinExtent, spatialDefaultMaxExtent);
    }

    public PointValue nextPointValue() {
        int nextInt = this.generator.nextInt(4);
        switch (nextInt) {
            case 0: {
                return this.nextCartesianPoint();
            }
            case 1: {
                return this.nextCartesian3DPoint();
            }
            case 2: {
                return this.nextGeographicPoint();
            }
            case 3: {
                return this.nextGeographic3DPoint();
            }
        }
        throw new IllegalStateException(nextInt + " not a valid point type");
    }

    public CharArray nextCharArray() {
        return Values.charArray((char[])this.nextCharArrayRaw(this.minArray(), this.maxArray()));
    }

    private char[] nextCharArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.nextCharRaw();
        }
        return array;
    }

    public DoubleArray nextDoubleArray() {
        double[] array = this.nextDoubleArrayRaw(this.minArray(), this.maxArray());
        return Values.doubleArray((double[])array);
    }

    public double[] nextDoubleArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        double[] doubles = new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this.generator.nextDouble();
        }
        return doubles;
    }

    public FloatArray nextFloatArray() {
        float[] array = this.nextFloatArrayRaw(this.minArray(), this.maxArray());
        return Values.floatArray((float[])array);
    }

    public float[] nextFloatArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        float[] floats = new float[length];
        for (int i = 0; i < length; ++i) {
            floats[i] = this.generator.nextFloat();
        }
        return floats;
    }

    public LongArray nextLongArray() {
        long[] array = this.nextLongArrayRaw(this.minArray(), this.maxArray());
        return Values.longArray((long[])array);
    }

    public long[] nextLongArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this.generator.nextLong();
        }
        return longs;
    }

    public IntArray nextIntArray() {
        int[] array = this.nextIntArrayRaw(this.minArray(), this.maxArray());
        return Values.intArray((int[])array);
    }

    public int[] nextIntArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this.generator.nextInt();
        }
        return ints;
    }

    public ByteArray nextByteArray() {
        return this.nextByteArray(this.minArray(), this.maxArray());
    }

    public ByteArray nextByteArray(int minLength, int maxLength) {
        byte[] array = this.nextByteArrayRaw(minLength, maxLength);
        return Values.byteArray((byte[])array);
    }

    public byte[] nextByteArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        byte[] bytes = new byte[length];
        int index = 0;
        while (index < length) {
            int rand = this.nextInt();
            int numBytesToShift = Math.min(length - index, 4);
            while (numBytesToShift > 0) {
                bytes[index++] = (byte)rand;
                --numBytesToShift;
                rand >>= 8;
            }
        }
        return bytes;
    }

    public ShortArray nextShortArray() {
        short[] array = this.nextShortArrayRaw(this.minArray(), this.maxArray());
        return Values.shortArray((short[])array);
    }

    public short[] nextShortArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        short[] shorts = new short[length];
        for (int i = 0; i < length; ++i) {
            shorts[i] = (short)this.generator.nextInt();
        }
        return shorts;
    }

    public BooleanArray nextBooleanArray() {
        boolean[] array = this.nextBooleanArrayRaw(this.minArray(), this.maxArray());
        return Values.booleanArray((boolean[])array);
    }

    public boolean[] nextBooleanArrayRaw(int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        boolean[] booleans = new boolean[length];
        for (int i = 0; i < length; ++i) {
            booleans[i] = this.generator.nextBoolean();
        }
        return booleans;
    }

    public TextArray nextAlphaNumericTextArray() {
        String[] array = this.nextAlphaNumericStringArrayRaw(this.minArray(), this.maxArray(), this.minString(), this.maxString());
        return Values.stringArray((String[])array);
    }

    public String[] nextAlphaNumericStringArrayRaw(int minLength, int maxLength, int minStringLength, int maxStringLength) {
        return this.nextArray(String[]::new, () -> this.nextStringRaw(minStringLength, maxStringLength, this::alphaNumericCodePoint), minLength, maxLength);
    }

    private TextArray nextAsciiTextArray() {
        String[] array = this.nextArray(String[]::new, () -> this.nextStringRaw(this::asciiCodePoint), this.minArray(), this.maxArray());
        return Values.stringArray((String[])array);
    }

    public TextArray nextBasicMultilingualPlaneTextArray() {
        String[] array = this.nextArray(String[]::new, () -> this.nextStringRaw(this.minString(), this.maxString(), this::bmpCodePoint), this.minArray(), this.maxArray());
        return Values.stringArray((String[])array);
    }

    public TextArray nextTextArray() {
        String[] array = this.nextStringArrayRaw(this.minArray(), this.maxArray(), this.minString(), this.maxString());
        return Values.stringArray((String[])array);
    }

    public String[] nextStringArrayRaw(int minLength, int maxLength, int minStringLength, int maxStringLength) {
        return this.nextArray(String[]::new, () -> this.nextStringRaw(minStringLength, maxStringLength, this::nextValidCodePoint), minLength, maxLength);
    }

    public LocalTimeArray nextLocalTimeArray() {
        LocalTime[] array = this.nextLocalTimeArrayRaw(this.minArray(), this.maxArray());
        return Values.localTimeArray((LocalTime[])array);
    }

    public LocalTime[] nextLocalTimeArrayRaw(int minLength, int maxLength) {
        return this.nextArray(LocalTime[]::new, this::nextLocalTimeRaw, minLength, maxLength);
    }

    public TimeArray nextTimeArray() {
        OffsetTime[] array = this.nextTimeArrayRaw(this.minArray(), this.maxArray());
        return Values.timeArray((OffsetTime[])array);
    }

    public OffsetTime[] nextTimeArrayRaw(int minLength, int maxLength) {
        return this.nextArray(OffsetTime[]::new, this::nextTimeRaw, minLength, maxLength);
    }

    public DateTimeArray nextDateTimeArray() {
        ZonedDateTime[] array = this.nextDateTimeArrayRaw(this.minArray(), this.maxArray());
        return Values.dateTimeArray((ZonedDateTime[])array);
    }

    public ZonedDateTime[] nextDateTimeArrayRaw(int minLength, int maxLength) {
        return this.nextArray(ZonedDateTime[]::new, () -> this.nextZonedDateTimeRaw(ZoneOffset.UTC), minLength, maxLength);
    }

    public LocalDateTimeArray nextLocalDateTimeArray() {
        return Values.localDateTimeArray((LocalDateTime[])this.nextLocalDateTimeArrayRaw(this.minArray(), this.maxArray()));
    }

    public LocalDateTime[] nextLocalDateTimeArrayRaw(int minLength, int maxLength) {
        return this.nextArray(LocalDateTime[]::new, this::nextLocalDateTimeRaw, minLength, maxLength);
    }

    public DateArray nextDateArray() {
        return Values.dateArray((LocalDate[])this.nextDateArrayRaw(this.minArray(), this.maxArray()));
    }

    public LocalDate[] nextDateArrayRaw(int minLength, int maxLength) {
        return this.nextArray(LocalDate[]::new, this::nextDateRaw, minLength, maxLength);
    }

    private DurationArray nextPeriodArray() {
        return Values.durationArray((TemporalAmount[])this.nextPeriodArrayRaw(this.minArray(), this.maxArray()));
    }

    public Period[] nextPeriodArrayRaw(int minLength, int maxLength) {
        return this.nextArray(Period[]::new, this::nextPeriodRaw, minLength, maxLength);
    }

    public DurationArray nextDurationArray() {
        return Values.durationArray((TemporalAmount[])this.nextDurationArrayRaw(this.minArray(), this.maxArray()));
    }

    public Duration[] nextDurationArrayRaw(int minLength, int maxLength) {
        return this.nextArray(Duration[]::new, this::nextDurationRaw, minLength, maxLength);
    }

    public PointArray nextCartesianPointArray() {
        return this.nextCartesianPointArray(this.minArray(), this.maxArray());
    }

    public PointArray nextCartesianPointArray(int minLength, int maxLength) {
        PointValue[] array = this.nextArray(PointValue[]::new, this::nextCartesianPoint, minLength, maxLength);
        return Values.pointArray((PointValue[])array);
    }

    public PointArray nextCartesian3DPointArray() {
        return this.nextCartesian3DPointArray(this.minArray(), this.maxArray());
    }

    public PointArray nextCartesian3DPointArray(int minLength, int maxLength) {
        PointValue[] array = this.nextArray(PointValue[]::new, this::nextCartesian3DPoint, minLength, maxLength);
        return Values.pointArray((PointValue[])array);
    }

    public PointArray nextGeographicPointArray() {
        return this.nextGeographicPointArray(this.minArray(), this.maxArray());
    }

    public PointArray nextGeographicPointArray(int minLength, int maxLength) {
        PointValue[] array = this.nextArray(PointValue[]::new, this::nextGeographicPoint, minLength, maxLength);
        return Values.pointArray((PointValue[])array);
    }

    public PointArray nextGeographic3DPointArray() {
        return this.nextGeographic3DPointArray(this.minArray(), this.maxArray());
    }

    public PointArray nextGeographic3DPointArray(int minLength, int maxLength) {
        PointValue[] points = this.nextArray(PointValue[]::new, this::nextGeographic3DPoint, minLength, maxLength);
        return Values.pointArray((PointValue[])points);
    }

    private <T> T[] nextArray(IntFunction<T[]> arrayFactory, ElementFactory<T> elementFactory, int minLength, int maxLength) {
        int length = this.intBetween(minLength, maxLength);
        T[] array = arrayFactory.apply(length);
        for (int i = 0; i < length; ++i) {
            array[i] = elementFactory.generate();
        }
        return array;
    }

    private String nextStringRaw(CodePointFactory codePointFactory) {
        return this.nextStringRaw(this.minString(), this.maxString(), codePointFactory);
    }

    private String nextStringRaw(int minStringLength, int maxStringLength, CodePointFactory codePointFactory) {
        int length = this.intBetween(minStringLength, maxStringLength);
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.appendCodePoint(codePointFactory.generate());
        }
        return sb.toString();
    }

    private LocalTime nextLocalTimeRaw() {
        return LocalTime.ofNanoOfDay(this.longBetween(LocalTime.MIN.toNanoOfDay(), LocalTime.MAX.toNanoOfDay()));
    }

    private LocalDateTime nextLocalDateTimeRaw() {
        return LocalDateTime.ofInstant(this.nextInstantRaw(), ZoneOffset.UTC);
    }

    private OffsetTime nextTimeRaw() {
        return OffsetTime.ofInstant(this.nextInstantRaw(), ZoneOffset.UTC);
    }

    private ZonedDateTime nextZonedDateTimeRaw(ZoneId utc) {
        return ZonedDateTime.ofInstant(this.nextInstantRaw(), utc);
    }

    private LocalDate nextDateRaw() {
        return LocalDate.ofEpochDay(this.longBetween(LocalDate.MIN.toEpochDay(), LocalDate.MAX.toEpochDay()));
    }

    private Instant nextInstantRaw() {
        return Instant.ofEpochSecond(this.longBetween(LocalDateTime.MIN.toEpochSecond(ZoneOffset.UTC), LocalDateTime.MAX.toEpochSecond(ZoneOffset.UTC)), this.nextLong(1000000000L));
    }

    private Period nextPeriodRaw() {
        return Period.of(this.generator.nextInt(), this.generator.nextInt(12), this.generator.nextInt(28));
    }

    private Duration nextDurationRaw() {
        return Duration.ofSeconds(this.nextLong(ChronoUnit.DAYS.getDuration().getSeconds()), this.nextLong(1000000000L));
    }

    public <T> T among(T[] among) {
        return among[this.generator.nextInt(among.length)];
    }

    public <T> T among(List<T> among) {
        return among.get(this.generator.nextInt(among.size()));
    }

    public <T> void among(List<T> among, Consumer<T> action) {
        if (!among.isEmpty()) {
            T item = this.among(among);
            action.accept(item);
        }
    }

    public <T> T[] selection(T[] among, int min, int max, boolean allowDuplicates) {
        assert (min <= max);
        int diff = min == max ? 0 : this.generator.nextInt(max - min);
        int length = min + diff;
        Object[] result = (Object[])Array.newInstance(among.getClass().getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            T candidate;
            do {
                candidate = this.among(among);
            } while (!allowDuplicates && ArrayUtils.contains((Object[])result, candidate));
            result[i] = candidate;
        }
        return result;
    }

    private static int nextPowerOf2(int i) {
        return 1 << 32 - Integer.numberOfLeadingZeros(i);
    }

    private int maxArray() {
        return this.configuration.arrayMaxLength();
    }

    private int minArray() {
        return this.configuration.arrayMinLength();
    }

    private int maxString() {
        return this.configuration.stringMaxLength();
    }

    private int minString() {
        return this.configuration.stringMinLength();
    }

    @FunctionalInterface
    private static interface CodePointFactory {
        public int generate();
    }

    @FunctionalInterface
    private static interface ElementFactory<T> {
        public T generate();
    }

    public static class Default
    implements Configuration {
        @Override
        public int stringMinLength() {
            return 5;
        }

        @Override
        public int stringMaxLength() {
            return 20;
        }

        @Override
        public int arrayMinLength() {
            return 1;
        }

        @Override
        public int arrayMaxLength() {
            return 10;
        }

        @Override
        public int maxCodePoint() {
            return 0x10FFFF;
        }
    }

    public static interface Configuration {
        public int stringMinLength();

        public int stringMaxLength();

        public int arrayMinLength();

        public int arrayMaxLength();

        public int maxCodePoint();
    }

    public static enum Type {
        BOOLEAN(ValueGroup.NUMBER, BooleanValue.class),
        BYTE(ValueGroup.NUMBER, ByteValue.class),
        SHORT(ValueGroup.NUMBER, ShortValue.class),
        INT(ValueGroup.NUMBER, IntValue.class),
        LONG(ValueGroup.NUMBER, LongValue.class),
        FLOAT(ValueGroup.NUMBER, FloatValue.class),
        DOUBLE(ValueGroup.NUMBER, DoubleValue.class),
        CHAR(ValueGroup.TEXT, CharValue.class),
        STRING(ValueGroup.TEXT, TextValue.class),
        STRING_ALPHANUMERIC(ValueGroup.TEXT, TextValue.class),
        STRING_ASCII(ValueGroup.TEXT, TextValue.class),
        STRING_BMP(ValueGroup.TEXT, TextValue.class),
        LOCAL_DATE_TIME(ValueGroup.LOCAL_DATE_TIME, LocalDateTimeValue.class),
        DATE(ValueGroup.DATE, DateValue.class),
        LOCAL_TIME(ValueGroup.LOCAL_TIME, LocalTimeValue.class),
        PERIOD(ValueGroup.DURATION, DurationValue.class),
        DURATION(ValueGroup.DURATION, DurationValue.class),
        TIME(ValueGroup.ZONED_TIME, TimeValue.class),
        DATE_TIME(ValueGroup.ZONED_DATE_TIME, DateTimeValue.class),
        CARTESIAN_POINT(ValueGroup.GEOMETRY, PointValue.class),
        CARTESIAN_POINT_3D(ValueGroup.GEOMETRY, PointValue.class),
        GEOGRAPHIC_POINT(ValueGroup.GEOMETRY, PointValue.class),
        GEOGRAPHIC_POINT_3D(ValueGroup.GEOMETRY, PointValue.class),
        BOOLEAN_ARRAY(ValueGroup.BOOLEAN_ARRAY, BooleanArray.class, true),
        BYTE_ARRAY(ValueGroup.NUMBER_ARRAY, ByteArray.class, true),
        SHORT_ARRAY(ValueGroup.NUMBER_ARRAY, ShortArray.class, true),
        INT_ARRAY(ValueGroup.NUMBER_ARRAY, IntArray.class, true),
        LONG_ARRAY(ValueGroup.NUMBER_ARRAY, LongArray.class, true),
        FLOAT_ARRAY(ValueGroup.NUMBER_ARRAY, FloatArray.class, true),
        DOUBLE_ARRAY(ValueGroup.NUMBER_ARRAY, DoubleArray.class, true),
        CHAR_ARRAY(ValueGroup.TEXT_ARRAY, CharArray.class, true),
        STRING_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true),
        STRING_ALPHANUMERIC_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true),
        STRING_ASCII_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true),
        STRING_BMP_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true),
        LOCAL_DATE_TIME_ARRAY(ValueGroup.LOCAL_DATE_TIME_ARRAY, LocalDateTimeArray.class, true),
        DATE_ARRAY(ValueGroup.DATE_ARRAY, DateArray.class, true),
        LOCAL_TIME_ARRAY(ValueGroup.LOCAL_TIME_ARRAY, LocalTimeArray.class, true),
        PERIOD_ARRAY(ValueGroup.DURATION_ARRAY, DurationArray.class, true),
        DURATION_ARRAY(ValueGroup.DURATION_ARRAY, DurationArray.class, true),
        TIME_ARRAY(ValueGroup.ZONED_TIME_ARRAY, TimeArray.class, true),
        DATE_TIME_ARRAY(ValueGroup.ZONED_DATE_TIME_ARRAY, DateTimeArray.class, true),
        CARTESIAN_POINT_ARRAY(ValueGroup.GEOMETRY_ARRAY, PointArray.class, true),
        CARTESIAN_POINT_3D_ARRAY(ValueGroup.GEOMETRY_ARRAY, PointArray.class, true),
        GEOGRAPHIC_POINT_ARRAY(ValueGroup.GEOMETRY_ARRAY, PointArray.class, true),
        GEOGRAPHIC_POINT_3D_ARRAY(ValueGroup.GEOMETRY_ARRAY, PointArray.class, true);

        public final ValueGroup valueGroup;
        public final Class<? extends Value> valueClass;
        public final boolean arrayType;

        private Type(ValueGroup valueGroup, Class<? extends Value> valueClass) {
            this(valueGroup, valueClass, false);
        }

        private Type(ValueGroup valueGroup, Class<? extends Value> valueClass, boolean arrayType) {
            this.valueGroup = valueGroup;
            this.valueClass = valueClass;
            this.arrayType = arrayType;
        }

        static Type[] arrayTypes() {
            return (Type[])Arrays.stream(Type.values()).filter(t -> t.arrayType).toArray(Type[]::new);
        }
    }
}

