/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.transaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransaction
implements Transaction {
    private final Logger logger = LoggerFactory.getLogger(Transaction.class);
    protected final TransactionManager transactionManager;
    private final AtomicLong extendsCount = new AtomicLong();
    private final List<Object> registeredNew = new ArrayList<Object>();
    private Transaction.Status status = Transaction.Status.OPEN;
    protected Transaction.Type type = Transaction.Type.READ_WRITE;

    protected AbstractTransaction(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public final void rollback() {
        long extensions = this.extendsCount.get();
        this.logger.debug("Thread {}: Rollback transaction extent: {}", (Object)Thread.currentThread().getId(), (Object)extensions);
        if (extensions == 0L) {
            this.transactionManager.close(this, transactionClosedListener -> {
                this.rollback0();
                transactionClosedListener.onTransactionClosed(Transaction.Status.ROLLEDBACK, Collections.unmodifiableList(this.registeredNew));
                this.registeredNew.clear();
                this.status = Transaction.Status.ROLLEDBACK;
                this.logger.debug("Thread {}: Rolled back", (Object)Thread.currentThread().getId());
            });
        } else {
            this.logger.debug("Thread {}: Rollback deferred", (Object)Thread.currentThread().getId());
            this.status = Transaction.Status.ROLLBACK_PENDING;
        }
    }

    protected abstract void rollback0();

    @Override
    public final void commit() {
        long extensions = this.extendsCount.get();
        if (!this.canCommit()) {
            throw new TransactionException("Transaction cannot commit");
        }
        try {
            if (extensions == 0L) {
                this.transactionManager.close(this, transactionClosedLitener -> {
                    this.commit0();
                    transactionClosedLitener.onTransactionClosed(Transaction.Status.COMMITTED, Collections.unmodifiableList(this.registeredNew));
                    this.registeredNew.clear();
                    this.status = Transaction.Status.COMMITTED;
                    this.logger.debug("Thread {}: Committed", (Object)Thread.currentThread().getId());
                });
            }
        }
        finally {
            this.logger.debug("Thread {}: Commit transaction extent: {}", (Object)Thread.currentThread().getId(), (Object)extensions);
            if (extensions > 0L) {
                if (this.status == Transaction.Status.ROLLBACK_PENDING) {
                    throw new TransactionException("Transaction cannot commit: rollback pending");
                }
                this.logger.debug("Thread {}: Commit deferred", (Object)Thread.currentThread().getId());
                this.status = Transaction.Status.COMMIT_PENDING;
            }
        }
    }

    protected abstract void commit0();

    @Override
    public final boolean canCommit() {
        return this.status == Transaction.Status.OPEN || this.status == Transaction.Status.PENDING || this.status == Transaction.Status.COMMIT_PENDING;
    }

    @Override
    public final boolean canRollback() {
        return Transaction.super.canRollback();
    }

    public void extend(Transaction.Type otherType) {
        if (this.type != otherType) {
            throw new TransactionException("Incompatible transaction type specified: must be '" + this.type + "'");
        }
        long extensions = this.extendsCount.incrementAndGet();
        this.logger.debug("Thread {}: Transaction extended: {}", (Object)Thread.currentThread().getId(), (Object)extensions);
    }

    @Override
    public final Transaction.Status status() {
        return this.status;
    }

    @Override
    public boolean isReadOnly() {
        return this.type == Transaction.Type.READ_ONLY;
    }

    @Override
    public Transaction.Type type() {
        return this.type;
    }

    @Override
    public final void close() {
        long extensions = this.extendsCount.get();
        this.logger.debug("Thread {}: Close transaction extent: {}", (Object)Thread.currentThread().getId(), (Object)extensions);
        if (extensions == 0L) {
            this.logger.debug("Thread {}: Closing transaction", (Object)Thread.currentThread().getId());
            if (this.status == Transaction.Status.ROLLBACK_PENDING) {
                this.rollback();
            } else if (this.status == Transaction.Status.COMMIT_PENDING) {
                this.commit();
            } else if (this.status == Transaction.Status.PENDING || this.status == Transaction.Status.OPEN) {
                this.rollback();
            }
            this.status = Transaction.Status.CLOSED;
        } else {
            this.extendsCount.getAndDecrement();
            this.logger.debug("Thread {}: Close deferred", (Object)Thread.currentThread().getId());
        }
    }

    public void registerNew(Object persisted) {
        this.registeredNew.add(persisted);
    }
}

