/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.neo4j.ogm.driver.Driver;

public final class Neo4jOgmVersion {
    private static volatile String value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String resolve() {
        String computedVersion = value;
        if (computedVersion != null) return computedVersion;
        Class<Neo4jOgmVersion> clazz = Neo4jOgmVersion.class;
        synchronized (Neo4jOgmVersion.class) {
            computedVersion = value;
            if (computedVersion != null) return computedVersion;
            value = Neo4jOgmVersion.getVersionImpl();
            return value;
        }
    }

    private static String getVersionImpl() {
        try {
            Enumeration<URL> resources = Driver.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Manifest manifest = new Manifest(url.openStream());
                if (!Neo4jOgmVersion.isApplicableManifest(manifest)) continue;
                Attributes attr = manifest.getMainAttributes();
                return Neo4jOgmVersion.get(attr, "Implementation-Version").toString();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Unable to read from neo4j-ogm-core manifest.", ex);
        }
        return "unknown";
    }

    private static boolean isApplicableManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        return "Neo4j-OGM Api".equals(Neo4jOgmVersion.get(attributes, "Implementation-Title"));
    }

    private static Object get(Attributes attributes, String key) {
        return attributes.get(new Attributes.Name(key));
    }

    private Neo4jOgmVersion() {
    }
}

