/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.util.Objects;

public final class UserSelection {
    private static final UserSelection CONNECTED_USER = new UserSelection(null);
    private final String value;

    public static UserSelection connectedUser() {
        return CONNECTED_USER;
    }

    public static UserSelection impersonate(String value) {
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Cannot impersonate user without username");
        }
        return new UserSelection(value);
    }

    private UserSelection(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSelection that = (UserSelection)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

