/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.driver;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.config.ObjectMapperFactory;

public interface ParameterConversion {
    public Map<String, Object> convertParameters(Map<String, Object> var1);

    public static enum DefaultParameterConversion implements ParameterConversion
    {
        INSTANCE;

        private static final ObjectMapper OBJECT_MAPPER;
        private static final TypeReference<HashMap<String, Object>> MAP_TYPE_REF;

        @Override
        public Map<String, Object> convertParameters(Map<String, Object> originalParameter) {
            return (Map)OBJECT_MAPPER.convertValue(originalParameter, MAP_TYPE_REF);
        }

        static {
            OBJECT_MAPPER = ObjectMapperFactory.objectMapper();
            MAP_TYPE_REF = new TypeReference<HashMap<String, Object>>(){};
        }
    }
}

