/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.driver;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.ExceptionTranslator;
import org.neo4j.ogm.driver.TypeSystem;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;

public interface Driver
extends AutoCloseable {
    public void configure(Configuration var1);

    public Function<TransactionManager, BiFunction<Transaction.Type, Collection<String>, Transaction>> getTransactionFactorySupplier();

    @Override
    public void close();

    public Request request(Transaction var1);

    public Configuration getConfiguration();

    default public Function<String, String> getCypherModification() {
        return Function.identity();
    }

    default public boolean requiresTransaction() {
        return true;
    }

    default public TypeSystem getTypeSystem() {
        return TypeSystem.NoNativeTypes.INSTANCE;
    }

    default public ExceptionTranslator getExceptionTranslator() {
        return e -> e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
    }

    default public <T> T unwrap(Class<T> clazz) {
        String message = String.format("Cannot unwrap '%s' into '%s'", this.getClass().getName(), clazz.getName());
        throw new IllegalArgumentException(message);
    }
}

