/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.response.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.neo4j.ogm.model.PropertyContainer;

abstract class AbstractPropertyContainer
implements PropertyContainer {
    private final Set<String> currentDynamicCompositeProperties = ConcurrentHashMap.newKeySet();
    private Set<String> previousDynamicCompositeProperties = Collections.emptySet();

    AbstractPropertyContainer() {
    }

    @Override
    public void addCurrentDynamicCompositeProperties(Set<String> currentDynamicCompositeProperties) {
        this.currentDynamicCompositeProperties.addAll(currentDynamicCompositeProperties);
    }

    @Override
    public void setPreviousDynamicCompositeProperties(Set<String> previousDynamicCompositeProperties) {
        this.previousDynamicCompositeProperties = new HashSet<String>(previousDynamicCompositeProperties);
    }

    @Override
    public String createPropertyRemovalFragment(String variable) {
        HashSet<String> propertiesToBeRemoved = new HashSet<String>(this.previousDynamicCompositeProperties);
        propertiesToBeRemoved.removeAll(this.currentDynamicCompositeProperties);
        if (propertiesToBeRemoved.isEmpty()) {
            return "";
        }
        return propertiesToBeRemoved.stream().map(s -> String.format("%s.`%s`", variable, s)).collect(Collectors.joining(",", " REMOVE ", " "));
    }
}

