/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.result.adapter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.response.model.DefaultGraphModel;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.result.adapter.BaseAdapter;
import org.neo4j.ogm.result.adapter.ResultAdapter;

public abstract class GraphModelAdapter
extends BaseAdapter
implements ResultAdapter<Map<String, Object>, GraphModel> {
    @Override
    public GraphModel adapt(Map<String, Object> data) {
        HashSet nodeIdentities = new HashSet();
        HashSet edgeIdentities = new HashSet();
        DefaultGraphModel graphModel = new DefaultGraphModel();
        for (Map.Entry<String, Object> mapEntry : data.entrySet()) {
            if (this.isPath(mapEntry.getValue())) {
                this.buildPath(mapEntry.getValue(), graphModel, nodeIdentities, edgeIdentities);
                continue;
            }
            if (this.isNode(mapEntry.getValue())) {
                this.buildNode(mapEntry.getValue(), graphModel, nodeIdentities);
                continue;
            }
            if (this.isRelationship(mapEntry.getValue())) {
                this.buildRelationship(mapEntry.getValue(), graphModel, nodeIdentities, edgeIdentities);
                continue;
            }
            if (!(mapEntry.getValue() instanceof Iterable)) continue;
            Iterable collection = (Iterable)mapEntry.getValue();
            for (Object element : collection) {
                if (this.isPath(element)) {
                    this.buildPath(element, graphModel, nodeIdentities, edgeIdentities);
                    continue;
                }
                if (this.isNode(element)) {
                    this.buildNode(element, graphModel, nodeIdentities);
                    continue;
                }
                if (this.isRelationship(element)) {
                    this.buildRelationship(element, graphModel, nodeIdentities, edgeIdentities);
                    continue;
                }
                throw new RuntimeException("Not handled:" + mapEntry.getValue().getClass());
            }
        }
        return graphModel;
    }

    public void buildPath(Object path, GraphModel graphModel, Set nodeIdentities, Set edgeIdentities) {
        Iterator<Object> relIterator = this.relsInPath(path).iterator();
        Iterator<Object> nodeIterator = this.nodesInPath(path).iterator();
        while (relIterator.hasNext()) {
            this.buildRelationship(relIterator.next(), graphModel, nodeIdentities, edgeIdentities);
        }
        while (nodeIterator.hasNext()) {
            this.buildNode(nodeIterator.next(), graphModel, nodeIdentities);
        }
    }

    public void buildNode(Object node, GraphModel graphModel, Set nodeIdentities) {
        if (!nodeIdentities.contains(this.nodeId(node))) {
            nodeIdentities.add(this.nodeId(node));
            NodeModel nodeModel = new NodeModel();
            nodeModel.setId(this.nodeId(node));
            List<String> labelNames = this.labels(node);
            nodeModel.setLabels(labelNames.toArray(new String[0]));
            nodeModel.setProperties(this.convertArrayPropertiesToIterable(this.properties(node)));
            graphModel.getNodes().add(nodeModel);
        }
    }

    public void buildRelationship(Object relationship, GraphModel graphModel, Set nodeIdentities, Set edgeIdentities) {
        if (!edgeIdentities.contains(this.relationshipId(relationship))) {
            edgeIdentities.add(this.relationshipId(relationship));
            RelationshipModel edgeModel = new RelationshipModel();
            edgeModel.setId(this.relationshipId(relationship));
            edgeModel.setType(this.relationshipType(relationship));
            edgeModel.setStartNode(this.startNodeId(relationship));
            edgeModel.setEndNode(this.endNodeId(relationship));
            edgeModel.setProperties(this.convertArrayPropertiesToIterable(this.properties(relationship)));
            graphModel.getRelationships().add(edgeModel);
        }
    }

    public abstract boolean isPath(Object var1);

    public abstract boolean isNode(Object var1);

    public abstract boolean isRelationship(Object var1);

    public abstract long nodeId(Object var1);

    public abstract List<String> labels(Object var1);

    public abstract long relationshipId(Object var1);

    public abstract String relationshipType(Object var1);

    public abstract Long startNodeId(Object var1);

    public abstract Long endNodeId(Object var1);

    public abstract Map<String, Object> properties(Object var1);

    public abstract List<Object> nodesInPath(Object var1);

    public abstract List<Object> relsInPath(Object var1);
}

