/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.classloader;

import org.neo4j.ogm.classloader.Strategy;

class DefaultStrategy
implements Strategy {
    DefaultStrategy() {
    }

    @Override
    public ClassLoader classLoader(Class caller) {
        if (caller == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        ClassLoader callerClassLoader = caller.getClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        ClassLoader classLoader = DefaultStrategy.inHierarchy(contextClassLoader, callerClassLoader) ? callerClassLoader : contextClassLoader;
        if (DefaultStrategy.inHierarchy(classLoader, systemClassLoader)) {
            classLoader = systemClassLoader;
        }
        return classLoader;
    }

    private static boolean inHierarchy(ClassLoader loader1, ClassLoader loader2) {
        if (loader1 == null || loader2 == null || loader1 == loader2) {
            return true;
        }
        while (loader2 != null) {
            if (loader2 == loader1) {
                return true;
            }
            loader2 = loader2.getParent();
        }
        return false;
    }
}

