/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.nativeimpl;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeCallResult;

public class LinuxNativeAccess
implements NativeAccess {
    private static final int POSIX_FADV_SEQUENTIAL = 2;
    private static final int POSIX_FADV_WILLNEED = 3;
    private static final int POSIX_FADV_DONTNEED = 4;
    private static final int EINVAL = 22;
    private static final int ERANGE = 34;
    private static final boolean NATIVE_ACCESS_AVAILABLE;
    private static final Throwable INITIALIZATION_FAILURE;

    private static native int posix_fadvise(int var0, long var1, long var3, int var5) throws LastErrorException;

    private static native int posix_fallocate(int var0, long var1, long var3) throws LastErrorException;

    public static native long strerror_r(int var0, long var1, int var3);

    @Override
    public boolean isAvailable() {
        return NATIVE_ACCESS_AVAILABLE;
    }

    @Override
    public NativeCallResult tryEvictFromCache(int fd) {
        if (fd <= 0) {
            return new NativeCallResult(-1, "Incorrect file descriptor.");
        }
        return LinuxNativeAccess.wrapResult(() -> LinuxNativeAccess.posix_fadvise(fd, 0L, 0L, 4));
    }

    @Override
    public NativeCallResult tryAdviseSequentialAccess(int fd) {
        if (fd <= 0) {
            return new NativeCallResult(-1, "Incorrect file descriptor.");
        }
        return LinuxNativeAccess.wrapResult(() -> LinuxNativeAccess.posix_fadvise(fd, 0L, 0L, 2));
    }

    @Override
    public NativeCallResult tryAdviseToKeepInCache(int fd) {
        if (fd <= 0) {
            return new NativeCallResult(-1, "Incorrect file descriptor.");
        }
        return LinuxNativeAccess.wrapResult(() -> LinuxNativeAccess.posix_fadvise(fd, 0L, 0L, 3));
    }

    @Override
    public NativeCallResult tryPreallocateSpace(int fd, long bytes) {
        if (fd <= 0) {
            return new NativeCallResult(-1, "Incorrect file descriptor.");
        }
        if (bytes <= 0L) {
            return new NativeCallResult(-1, "Number of bytes to preallocate should be positive. Requested: " + bytes);
        }
        return LinuxNativeAccess.wrapResult(() -> LinuxNativeAccess.posix_fallocate(fd, 0L, bytes));
    }

    @Override
    public String describe() {
        if (NATIVE_ACCESS_AVAILABLE) {
            return "Linux native access is available.";
        }
        StringBuilder descriptionBuilder = new StringBuilder("Linux native access is not available.");
        if (INITIALIZATION_FAILURE != null) {
            String exception = ExceptionUtils.getStackTrace((Throwable)INITIALIZATION_FAILURE);
            descriptionBuilder.append(" Details: ").append(exception);
        }
        return descriptionBuilder.toString();
    }

    private static NativeCallResult wrapResult(NativeCall call) {
        try {
            int result = call.call();
            if (result == 0) {
                return NativeCallResult.SUCCESS;
            }
            return new NativeCallResult(result, LinuxNativeAccess.tryExtractError(result));
        }
        catch (LastErrorException e) {
            return new NativeCallResult(e.getErrorCode(), e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String tryExtractError(int errorCode) {
        int bufferLength = 1024;
        long bufferPointer = Native.malloc((long)1024L);
        if (bufferPointer > 0L) {
            try {
                long result = LinuxNativeAccess.strerror_r(errorCode, bufferPointer, 1024);
                if (result == 0L) {
                    String string = new Pointer(bufferPointer).getString(0L);
                    return string;
                }
                if (result != -1L && result != 22L && result != 34L) {
                    String string = new Pointer(result).getString(0L);
                    return string;
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                Native.free((long)bufferPointer);
            }
        }
        return "Error occurred calling native function. Please check error code.";
    }

    static {
        Throwable initFailure = null;
        boolean available = false;
        try {
            if (Platform.isLinux()) {
                Native.register((String)Platform.C_LIBRARY_NAME);
                available = true;
            }
        }
        catch (Throwable t) {
            initFailure = t;
        }
        NATIVE_ACCESS_AVAILABLE = available;
        INITIALIZATION_FAILURE = initFailure;
    }

    @FunctionalInterface
    private static interface NativeCall {
        public int call() throws LastErrorException;
    }
}

