/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.DuplicatingLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.AbstractLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.Neo4jLoggerContext;

public class SimpleLogService
extends AbstractLogService
implements Lifecycle {
    private final LogProvider userLogProvider;
    private final LogProvider internalLogProvider;

    public SimpleLogService(LogProvider commonLogProvider) {
        this.userLogProvider = commonLogProvider;
        this.internalLogProvider = commonLogProvider;
    }

    public SimpleLogService(LogProvider userLogProvider, LogProvider internalLogProvider) {
        this.userLogProvider = new DuplicatingLogProvider(userLogProvider, internalLogProvider);
        this.internalLogProvider = internalLogProvider;
    }

    public SimpleLogService(Neo4jLoggerContext ctx) {
        this(new Log4jLogProvider(ctx));
    }

    @Override
    public LogProvider getUserLogProvider() {
        return this.userLogProvider;
    }

    @Override
    public LogProvider getInternalLogProvider() {
        return this.internalLogProvider;
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
        if (this.internalLogProvider instanceof Log4jLogProvider) {
            ((Log4jLogProvider)this.internalLogProvider).close();
        }
    }
}

