/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.BooleanSupplier;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.lock.LockTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class IndexedStoreScan
implements StoreScan {
    private final LockManager lockManager;
    private final Config config;
    private final BooleanSupplier indexExistenceChecker;
    private final StoreScan delegate;
    private final IndexDescriptor index;

    public IndexedStoreScan(LockManager lockManager, IndexDescriptor index, Config config, BooleanSupplier indexExistenceChecker, StoreScan delegate) {
        this.lockManager = lockManager;
        this.config = config;
        this.indexExistenceChecker = indexExistenceChecker;
        this.delegate = delegate;
        this.index = index;
    }

    @Override
    public void run(StoreScan.ExternalUpdatesCheck externalUpdatesCheck) {
        try (LockManager.Client client = this.lockManager.newClient();){
            client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.config);
            client.acquireShared(LockTracer.NONE, this.index.schema().keyType(), this.index.schema().lockingKeys());
            Preconditions.checkState((boolean)this.indexExistenceChecker.getAsBoolean(), (String)"%s no longer exists", (Object[])new Object[]{this.index});
            this.delegate.run(externalUpdatesCheck);
        }
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public PopulationProgress getProgress() {
        return this.delegate.getProgress();
    }

    @Override
    public void setPhaseTracker(PhaseTracker phaseTracker) {
        this.delegate.setPhaseTracker(phaseTracker);
    }
}

