/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.values.storable.Value;

public class PropertyTypeException
extends ConstraintValidationException {
    private final long entityId;
    private final TypeConstraintDescriptor descriptor;
    private final Value value;

    public PropertyTypeException(TypeConstraintDescriptor descriptor, ConstraintValidationException.Phase phase, long entityId, TokenNameLookup tokenNameLookup, Value value) {
        super((ConstraintDescriptor)descriptor, phase, String.format(descriptor.schema().entityType() == EntityType.NODE ? "Node(%s)" : "Relationship(%s)", entityId), tokenNameLookup);
        this.entityId = entityId;
        this.descriptor = descriptor;
        this.value = value;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        SchemaDescriptor schema = this.descriptor.schema();
        EntityType entityType = schema.entityType();
        String entityString = entityType == EntityType.NODE ? "Node" : "Relationship";
        String entityTokenType = entityType == EntityType.NODE ? "label" : "type";
        String entityToken = entityType == EntityType.NODE ? tokenNameLookup.labelGetName(schema.getLabelId()) : tokenNameLookup.relationshipTypeGetName(schema.getRelTypeId());
        String propertyKey = tokenNameLookup.propertyKeyGetName(schema.getPropertyId());
        return String.format("%s(%s) with %s `%s` has property `%s` of wrong type `%s`. Allowed types: %s", entityString, this.entityId, entityTokenType, entityToken, propertyKey, this.value.getTypeName(), this.descriptor.propertyType().userDescription());
    }
}

