/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.AbstractSystemGraphComponent;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponentWithVersion;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.util.Preconditions;

public abstract class AbstractVersionComponent<T extends ComponentVersion>
extends AbstractSystemGraphComponent
implements SystemGraphComponentWithVersion {
    private final SystemGraphComponent.Name componentName;
    protected final T latestVersion;
    protected final Function<Integer, T> convertToVersion;

    public AbstractVersionComponent(SystemGraphComponent.Name componentName, T latestVersion, Config config, Function<Integer, T> convertFunction) {
        super(config);
        this.componentName = componentName;
        this.latestVersion = latestVersion;
        this.convertToVersion = convertFunction;
    }

    abstract T getFallbackVersion();

    @Override
    public SystemGraphComponent.Name componentName() {
        return this.componentName;
    }

    @Override
    public int getLatestSupportedVersion() {
        return this.latestVersion.getVersion();
    }

    @Override
    public SystemGraphComponent.Status detect(Transaction tx) {
        try {
            Integer versionNumber = this.getVersion(tx, this.componentName);
            if (versionNumber == null) {
                return SystemGraphComponent.Status.UNINITIALIZED;
            }
            ComponentVersion version = (ComponentVersion)this.convertToVersion.apply(versionNumber);
            if (this.latestVersion.isGreaterThan(version)) {
                return SystemGraphComponent.Status.REQUIRES_UPGRADE;
            }
            if (this.latestVersion.equals(version)) {
                return SystemGraphComponent.Status.CURRENT;
            }
            return SystemGraphComponent.Status.UNSUPPORTED_FUTURE;
        }
        catch (IllegalArgumentException e) {
            return SystemGraphComponent.Status.UNSUPPORTED_FUTURE;
        }
    }

    @Override
    public void initializeSystemGraph(GraphDatabaseService system, boolean firstInitialization) throws Exception {
        SystemGraphComponent.Status status;
        boolean mayUpgrade = (Boolean)this.config.get(GraphDatabaseInternalSettings.allow_single_automatic_upgrade);
        Preconditions.checkState((boolean)system.databaseName().equals("system"), (String)("Cannot initialize system graph on database '" + system.databaseName() + "'"));
        try (Transaction tx = system.beginTx();){
            status = this.detect(tx);
            tx.commit();
        }
        switch (status) {
            case CURRENT: {
                break;
            }
            case UNINITIALIZED: {
                if (!mayUpgrade && !firstInitialization) break;
                this.initializeSystemGraphModel(system);
                break;
            }
            case REQUIRES_UPGRADE: {
                if (!mayUpgrade) break;
                this.upgradeToCurrent(system);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unsupported component state for '%s': %s", this.componentName(), status.description()));
            }
        }
    }

    @Override
    protected void initializeSystemGraphModel(GraphDatabaseService system) throws Exception {
        SystemGraphComponent.executeWithFullAccess(system, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)this::setToLatestVersion));
    }

    void setToLatestVersion(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(VERSION_LABEL);){
            Node node = nodes.stream().findFirst().orElseGet(() -> tx.createNode(new Label[]{VERSION_LABEL}));
            node.setProperty(this.componentName.name(), (Object)this.latestVersion.getVersion());
        }
    }

    @Override
    public void upgradeToCurrent(GraphDatabaseService system) throws Exception {
        this.initializeSystemGraphModel(system);
    }

    T fetchStateFromSystemDatabase(GraphDatabaseService system) {
        Object result = this.getFallbackVersion();
        try (Transaction tx = system.beginTx();){
            Integer version = this.getVersion(tx, this.componentName);
            if (version != null) {
                result = (ComponentVersion)this.convertToVersion.apply(version);
            }
        }
        return result;
    }
}

