/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.IntPredicate;
import org.neo4j.configuration.Config;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeRelationshipTypesStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.util.Preconditions;

public class FullScanStoreView
implements IndexStoreView {
    protected final LockService locks;
    protected final ReadableStorageEngine storageEngine;
    protected final Config config;
    protected final JobScheduler scheduler;

    public FullScanStoreView(LockService locks, ReadableStorageEngine storageEngine, Config config, JobScheduler scheduler) {
        this.locks = locks;
        this.storageEngine = storageEngine;
        this.config = config;
        this.scheduler = scheduler;
    }

    @Override
    public StoreScan visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer labelScanConsumer, boolean forceStoreScan, boolean parallelWrite, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        return new NodeStoreScan(this.config, this.storageEngine.newReader(), arg_0 -> ((ReadableStorageEngine)this.storageEngine).createStorageCursors(arg_0), this.locks, labelScanConsumer, propertyScanConsumer, labelIds, propertyKeyIdFilter, parallelWrite, this.scheduler, contextFactory, memoryTracker);
    }

    @Override
    public StoreScan visitRelationships(int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter, PropertyScanConsumer propertyScanConsumer, TokenScanConsumer relationshipTypeScanConsumer, boolean forceStoreScan, boolean parallelWrite, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        if (relationshipTypeScanConsumer != null && this.storageEngine.indexingBehaviour().useNodeIdsInRelationshipTokenIndex()) {
            Preconditions.checkArgument((propertyScanConsumer == null ? 1 : 0) != 0, (String)"Cannot run a node-based relationship type lookup index population together with a relationship property index population");
            return new NodeRelationshipTypesStoreScan(this.config, this.storageEngine.newReader(), arg_0 -> ((ReadableStorageEngine)this.storageEngine).createStorageCursors(arg_0), this.locks, relationshipTypeScanConsumer, relationshipTypeIds, parallelWrite, this.scheduler, contextFactory, memoryTracker);
        }
        return new RelationshipStoreScan(this.config, this.storageEngine.newReader(), arg_0 -> ((ReadableStorageEngine)this.storageEngine).createStorageCursors(arg_0), this.locks, relationshipTypeScanConsumer, propertyScanConsumer, relationshipTypeIds, propertyKeyIdFilter, parallelWrite, this.scheduler, contextFactory, memoryTracker);
    }

    @Override
    public boolean isEmpty(CursorContext cursorContext) {
        try (StorageReader reader = this.storageEngine.newReader();){
            boolean bl = reader.nodesGetCount(cursorContext) == 0L && reader.relationshipsGetCount(cursorContext) == 0L;
            return bl;
        }
    }
}

