/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.QueryRegistry;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.QueryStatement;
import org.neo4j.kernel.impl.api.StatementQueryRegistry;
import org.neo4j.kernel.impl.api.TransactionClockContext;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.LockTracer;
import org.neo4j.resources.CpuClock;

public class KernelStatement
extends QueryStatement {
    private static final int EMPTY_COUNTER = 0;
    private static final int STATEMENT_TRACK_HISTORY_MAX_SIZE = 100;
    private static final Deque<StackTraceElement[]> EMPTY_STATEMENT_HISTORY = new ArrayDeque<StackTraceElement[]>(0);
    private final QueryRegistry queryRegistry;
    private final KernelTransactionImplementation transaction;
    private final NamedDatabaseId namedDatabaseId;
    private final boolean traceStatements;
    private final boolean trackStatementClose;
    private Locks.Client lockClient;
    private CursorContext cursorContext;
    private int referenceCount;
    private final LockTracer systemLockTracer;
    private final Deque<StackTraceElement[]> statementOpenCloseCalls;
    private final TransactionClockContext clockContext;
    private long initialStatementHits;
    private long initialStatementFaults;

    public KernelStatement(KernelTransactionImplementation transaction, LockTracer systemLockTracer, TransactionClockContext clockContext, AtomicReference<CpuClock> cpuClockRef, NamedDatabaseId namedDatabaseId, Config config) {
        this.transaction = transaction;
        this.queryRegistry = new StatementQueryRegistry(this, clockContext.systemClock(), cpuClockRef);
        this.systemLockTracer = systemLockTracer;
        this.traceStatements = (Boolean)config.get(GraphDatabaseInternalSettings.trace_tx_statements);
        this.trackStatementClose = (Boolean)config.get(GraphDatabaseInternalSettings.track_tx_statement_close);
        this.statementOpenCloseCalls = this.traceStatements ? new ArrayDeque() : EMPTY_STATEMENT_HISTORY;
        this.clockContext = clockContext;
        this.namedDatabaseId = namedDatabaseId;
    }

    @Override
    public QueryRegistry queryRegistry() {
        return this.queryRegistry;
    }

    @Override
    public NamedDatabaseId namedDatabaseId() {
        return this.namedDatabaseId;
    }

    @Override
    public ClientConnectionInfo clientInfo() {
        return this.transaction.clientInfo();
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.transaction.getMetaData();
    }

    public void close() {
        if (this.referenceCount > 0 && --this.referenceCount == 0) {
            this.cleanupResources();
        }
        this.recordOpenCloseMethods();
    }

    public void initialize(Locks.Client lockClient, CursorContext cursorContext, long startTimeMillis) {
        this.lockClient = lockClient;
        this.cursorContext = cursorContext;
        this.clockContext.initializeTransaction(startTimeMillis);
        this.clearQueryExecution();
    }

    public Locks.Client locks() {
        return this.lockClient;
    }

    public LockTracer lockTracer() {
        LockTracer tracer = this.executingQuery().map(ExecutingQuery::lockTracer).orElse(null);
        return tracer == null ? this.systemLockTracer : this.systemLockTracer.combine(tracer);
    }

    @Override
    public long activeLockCount() {
        return this.lockClient.activeLockCount();
    }

    @Override
    public long getHits() {
        return this.isAcquired() ? Math.subtractExact(this.cursorContext.getCursorTracer().hits(), this.initialStatementHits) : 0L;
    }

    @Override
    public long getFaults() {
        return this.isAcquired() ? Math.subtractExact(this.cursorContext.getCursorTracer().faults(), this.initialStatementFaults) : 0L;
    }

    public final void acquire() {
        if (this.referenceCount++ == 0) {
            this.clockContext.initializeStatement();
            this.cursorContext.getVersionContext().refreshVisibilityBoundaries();
            PageCursorTracer cursorTracer = this.cursorContext.getCursorTracer();
            this.initialStatementHits = cursorTracer.hits();
            this.initialStatementFaults = cursorTracer.faults();
        }
        this.recordOpenCloseMethods();
    }

    final boolean isAcquired() {
        return this.referenceCount > 0;
    }

    final void forceClose() {
        if (this.referenceCount > 0) {
            int leakedStatements = this.referenceCount;
            this.referenceCount = 0;
            this.cleanupResources();
            if (this.trackStatementClose && !this.transaction.isRollback()) {
                String message = this.getStatementNotClosedMessage(leakedStatements);
                throw new StatementNotClosedException(message, this.statementOpenCloseCalls);
            }
        }
        this.clearQueryExecution();
    }

    private String getStatementNotClosedMessage(int leakedStatements) {
        String additionalInstruction = this.traceStatements ? "" : String.format(" To see statement open/close stack traces please set '%s' setting to true", GraphDatabaseInternalSettings.trace_tx_statements.name());
        return String.format("Statements were not correctly closed. Number of leaked statements: %d.%s", leakedStatements, additionalInstruction);
    }

    @Override
    public final String authenticatedUser() {
        return this.transaction.securityContext().subject().authenticatedUser();
    }

    @Override
    public final String executingUser() {
        return this.transaction.securityContext().subject().executingUser();
    }

    @Override
    public long getTransactionSequenceNumber() {
        return this.transaction.getTransactionSequenceNumber();
    }

    @Override
    final void stopQueryExecution(ExecutingQuery executingQuery) {
        super.stopQueryExecution(executingQuery);
        this.transaction.getStatistics().addWaitingTime(executingQuery.reportedWaitingTimeNanos());
    }

    private void cleanupResources() {
        this.transaction.releaseStatementResources();
        this.initialStatementHits = 0L;
        this.initialStatementFaults = 0L;
        this.closeAllCloseableResources();
    }

    public KernelTransactionImplementation getTransaction() {
        return this.transaction;
    }

    private void recordOpenCloseMethods() {
        if (this.traceStatements) {
            if (this.statementOpenCloseCalls.size() > 100) {
                this.statementOpenCloseCalls.pop();
            }
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            this.statementOpenCloseCalls.add(Arrays.copyOfRange(stackTrace, 2, stackTrace.length));
        }
    }

    public TransactionClockContext clocks() {
        return this.clockContext;
    }

    static class StatementNotClosedException
    extends IllegalStateException {
        StatementNotClosedException(String s, Deque<StackTraceElement[]> openCloseTraces) {
            super(s);
            this.addSuppressed(new StatementTraceException(StatementNotClosedException.buildMessage(openCloseTraces)));
        }

        private static String buildMessage(Deque<StackTraceElement[]> openCloseTraces) {
            if (openCloseTraces.isEmpty()) {
                return "";
            }
            int separatorLength = 80;
            String paddingString = "=";
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)out, false, StandardCharsets.UTF_8);
            printStream.println();
            printStream.println("Last 100 statements open/close stack traces are:");
            int element = 0;
            for (StackTraceElement[] traceElements : openCloseTraces) {
                printStream.println(StringUtils.center((String)("*StackTrace " + element + "*"), (int)separatorLength, (String)paddingString));
                for (StackTraceElement traceElement : traceElements) {
                    printStream.println("\tat " + traceElement);
                }
                printStream.println(StringUtils.center((String)"", (int)separatorLength, (String)paddingString));
                printStream.println();
                ++element;
            }
            printStream.println("All statement open/close stack traces printed.");
            return out.toString(StandardCharsets.UTF_8);
        }

        private static class StatementTraceException
        extends RuntimeException {
            StatementTraceException(String message) {
                super(message);
            }

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        }
    }
}

