/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import java.util.function.Predicate;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.graphdb.WriteOperationsNotAllowedException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.LeaseException;

public class TransientFailurePredicate
implements Predicate<Throwable> {
    private static final List<Class<? extends Throwable>> transientFailureClasses = List.of(LeaseException.class, TransientTransactionFailureException.class, WriteOperationsNotAllowedException.class);

    @Override
    public boolean test(Throwable error) {
        if (TransientFailurePredicate.isLockExpired(error)) {
            return true;
        }
        return transientFailureClasses.stream().anyMatch(clazz -> clazz.isInstance(error));
    }

    private static boolean isLockExpired(Throwable error) {
        return error instanceof TransactionFailureException && ((TransactionFailureException)error).status() == Status.Transaction.LeaseExpired || error.getCause() instanceof TransactionFailureException && ((TransactionFailureException)error.getCause()).status() == Status.Transaction.LeaseExpired;
    }
}

