/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import java.util.Map;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.internal.helpers.collection.AbstractResourceIterable;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextNode;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextRelationship;
import org.neo4j.kernel.impl.coreapi.DataLookup;
import org.neo4j.kernel.impl.coreapi.internal.CursorIterator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.ElementIdMapper;

public class ExecutionContextProcedureTransaction
extends DataLookup
implements Transaction {
    private final ExecutionContext executionContext;

    public ExecutionContextProcedureTransaction(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public Node createNode() {
        throw new UnsupportedOperationException("Write operations are unsupported during parallel execution");
    }

    public Node createNode(Label ... labels) {
        throw new UnsupportedOperationException("Write operations are unsupported during parallel execution");
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        throw new UnsupportedOperationException("Traversal operations are unsupported during parallel execution");
    }

    public TraversalDescription traversalDescription() {
        throw new UnsupportedOperationException("Traversal operations are unsupported during parallel execution");
    }

    public Result execute(String query) throws QueryExecutionException {
        throw new UnsupportedOperationException("Execution of other queries is unsupported during parallel execution");
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        throw new UnsupportedOperationException("Execution of other queries is unsupported during parallel execution");
    }

    public ResourceIterable<Node> getAllNodes() {
        AbstractResourceIterable<Node> result = new AbstractResourceIterable<Node>(){

            protected ResourceIterator<Node> newIterator() {
                NodeCursor cursor = ExecutionContextProcedureTransaction.this.cursors().allocateNodeCursor(ExecutionContextProcedureTransaction.this.cursorContext());
                ExecutionContextProcedureTransaction.this.dataRead().allNodesScan(cursor);
                return new CursorIterator<NodeCursor, Node>(cursor, NodeCursor::nodeReference, c -> ExecutionContextProcedureTransaction.this.newNodeEntity(c.nodeReference()));
            }

            protected void onClosed() {
                ExecutionContextProcedureTransaction.this.executionContext.unregisterCloseableResource((AutoCloseable)((Object)this));
            }
        };
        this.executionContext.registerCloseableResource((AutoCloseable)result);
        return result;
    }

    public ResourceIterable<Relationship> getAllRelationships() {
        AbstractResourceIterable<Relationship> result = new AbstractResourceIterable<Relationship>(){

            protected ResourceIterator<Relationship> newIterator() {
                RelationshipScanCursor cursor = ExecutionContextProcedureTransaction.this.cursors().allocateRelationshipScanCursor(ExecutionContextProcedureTransaction.this.cursorContext());
                ExecutionContextProcedureTransaction.this.dataRead().allRelationshipsScan(cursor);
                return new CursorIterator<RelationshipScanCursor, Relationship>(cursor, RelationshipDataAccessor::relationshipReference, c -> ExecutionContextProcedureTransaction.this.newRelationshipEntity(c.relationshipReference()));
            }

            protected void onClosed() {
                ExecutionContextProcedureTransaction.this.executionContext.unregisterCloseableResource((AutoCloseable)((Object)this));
            }
        };
        this.executionContext.registerCloseableResource((AutoCloseable)result);
        return result;
    }

    public Lock acquireWriteLock(Entity entity) {
        throw new UnsupportedOperationException("Acquiring locks is unsupported during parallel execution.");
    }

    public Lock acquireReadLock(Entity entity) {
        throw new UnsupportedOperationException("Acquiring locks is unsupported during parallel execution.");
    }

    public Schema schema() {
        throw new UnsupportedOperationException("Working with schema is unsupported during parallel execution.");
    }

    public void terminate() {
        throw new UnsupportedOperationException("Terminating ongoing transaction inside of a procedure or a function is unsupported.");
    }

    public void commit() {
        throw new UnsupportedOperationException("Committing ongoing transaction inside of a procedure or a function is unsupported.");
    }

    public void rollback() {
        throw new UnsupportedOperationException("Rolling back ongoing transaction inside of a procedure or a function is unsupported.");
    }

    public void close() {
        throw new UnsupportedOperationException("Closing ongoing transaction inside of a procedure or a function is unsupported.");
    }

    @Override
    protected TokenRead tokenRead() {
        return this.executionContext.tokenRead();
    }

    @Override
    protected SchemaRead schemaRead() {
        return this.executionContext.schemaRead();
    }

    @Override
    protected Read dataRead() {
        return this.executionContext.dataRead();
    }

    @Override
    protected ResourceMonitor resourceMonitor() {
        return this.executionContext;
    }

    @Override
    protected Node newNodeEntity(long nodeId) {
        return new ExecutionContextNode(nodeId, this.executionContext);
    }

    @Override
    protected Relationship newRelationshipEntity(long relationshipId) {
        return new ExecutionContextRelationship(relationshipId, this.executionContext);
    }

    @Override
    protected Relationship newRelationshipEntity(long id, long startNodeId, int typeId, long endNodeId) {
        return this.newRelationshipEntity(id);
    }

    @Override
    protected CursorFactory cursors() {
        return this.executionContext.cursors();
    }

    @Override
    protected CursorContext cursorContext() {
        return this.executionContext.cursorContext();
    }

    @Override
    protected MemoryTracker memoryTracker() {
        return this.executionContext.memoryTracker();
    }

    @Override
    protected QueryContext queryContext() {
        return this.executionContext.queryContext();
    }

    @Override
    protected ElementIdMapper elementIdMapper() {
        return this.executionContext.elementIdMapper();
    }

    @Override
    protected void performCheckBeforeOperation() {
        this.executionContext.performCheckBeforeOperation();
    }
}

