/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.notification;

import java.util.Objects;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.NotificationCategory;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.graphdb.impl.notification.NotificationCodeWithDescription;
import org.neo4j.kernel.api.exceptions.Status;

public final class NotificationImplementation
implements Notification {
    private final Status.Code statusCode;
    private final String title;
    private final String description;
    private final SeverityLevel severity;
    private final NotificationCategory category;
    private final InputPosition position;

    NotificationImplementation(NotificationCodeWithDescription notificationCodeWithDescription, InputPosition position, String title, String description) {
        this.statusCode = notificationCodeWithDescription.getStatus().code();
        if (!(this.statusCode instanceof Status.NotificationCode)) {
            throw new IllegalStateException("'" + this.statusCode + "' is not a notification code.");
        }
        this.severity = this.mapSeverity(((Status.NotificationCode)this.statusCode).getSeverity());
        this.category = this.mapCategory(((Status.NotificationCode)this.statusCode).getNotificationCategory());
        this.position = position;
        this.title = title;
        this.description = description;
    }

    public String getCode() {
        return this.statusCode.serialize();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public InputPosition getPosition() {
        return this.position;
    }

    public NotificationCategory getCategory() {
        return this.category;
    }

    public SeverityLevel getSeverity() {
        return this.severity;
    }

    public String toString() {
        return "Notification{position=" + this.position + ", description='" + this.description + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationImplementation that = (NotificationImplementation)o;
        return Objects.equals(this.position, that.position) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.description);
    }

    private SeverityLevel mapSeverity(String severityLevel) {
        return SeverityLevel.valueOf((String)severityLevel);
    }

    private NotificationCategory mapCategory(String category) {
        return NotificationCategory.valueOf((String)category);
    }

    public static class NotificationBuilder {
        private final NotificationCodeWithDescription notificationCodeWithDescription;
        private String title;
        private String description;
        private InputPosition position;

        public NotificationBuilder(NotificationCodeWithDescription notificationCodeWithDescription) {
            this.notificationCodeWithDescription = notificationCodeWithDescription;
            this.description = notificationCodeWithDescription.getDescription();
            this.title = notificationCodeWithDescription.getStatus().code().description();
            this.position = InputPosition.empty;
        }

        public NotificationBuilder setPosition(InputPosition position) {
            this.position = position;
            return this;
        }

        public NotificationBuilder setTitleDetails(String ... details) {
            if (details.length > 0) {
                this.title = String.format(this.title, details);
            }
            return this;
        }

        public NotificationBuilder setNotificationDetails(String ... details) {
            if (details.length > 0) {
                this.description = String.format(this.description, details);
            }
            return this;
        }

        public NotificationImplementation build() {
            return new NotificationImplementation(this.notificationCodeWithDescription, this.position, this.title, this.description);
        }
    }
}

