/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.UnclosableChannel;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointWriters;
import org.neo4j.kernel.impl.transaction.log.entry.CheckpointLogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogChannelAllocator;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.DetachedLogTailScanner;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.monitoring.Panic;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;

public class DetachedCheckpointAppender
extends LifecycleAdapter
implements CheckpointAppender {
    private final LogFiles logFiles;
    private final CheckpointFile checkpointFile;
    private final TransactionLogChannelAllocator channelAllocator;
    private final TransactionLogFilesContext context;
    private final Panic databasePanic;
    private final LogRotation logRotation;
    private StoreId storeId;
    private PositionAwarePhysicalFlushableChecksumChannel writer;
    private CheckpointWriters checkpointWriters;
    private NativeScopedBuffer buffer;
    private PhysicalLogVersionedStoreChannel channel;
    private LogVersionRepository logVersionRepository;
    private final InternalLog log;
    private final DetachedLogTailScanner logTailScanner;

    public DetachedCheckpointAppender(LogFiles logFiles, TransactionLogChannelAllocator channelAllocator, TransactionLogFilesContext context, CheckpointFile checkpointFile, LogRotation checkpointRotation, DetachedLogTailScanner logTailScanner) {
        this.logFiles = logFiles;
        this.checkpointFile = Objects.requireNonNull(checkpointFile);
        this.context = Objects.requireNonNull(context);
        this.channelAllocator = Objects.requireNonNull(channelAllocator);
        this.databasePanic = (Panic)Objects.requireNonNull(context.getDatabaseHealth());
        this.logRotation = Objects.requireNonNull(checkpointRotation);
        this.log = context.getLogProvider().getLog(DetachedCheckpointAppender.class);
        this.logTailScanner = logTailScanner;
    }

    public void start() throws IOException {
        this.storeId = this.context.getStoreId();
        this.logVersionRepository = Objects.requireNonNull(this.context.getLogVersionRepositoryProvider().logVersionRepository(this.logFiles));
        long version = this.logVersionRepository.getCheckpointLogVersion();
        this.channel = this.channelAllocator.createLogChannel(version, () -> this.context.getLastCommittedTransactionIdProvider().getLastCommittedTransactionId(this.logFiles));
        ((LogRotationMonitor)this.context.getMonitors().newMonitor(LogRotationMonitor.class, new String[0])).started(this.channel.getPath(), version);
        this.seekCheckpointChannel(version);
        this.buffer = new NativeScopedBuffer(ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, this.context.getMemoryTracker());
        this.writer = new PositionAwarePhysicalFlushableChecksumChannel(this.channel, (ScopedBuffer)this.buffer);
        this.checkpointWriters = new CheckpointWriters((WritableChecksumChannel)this.writer);
    }

    private void seekCheckpointChannel(long expectedVersion) throws IOException {
        LogTailMetadata tailMetadata = this.logTailScanner.getTailMetadata();
        if (tailMetadata.hasUnreadableBytesInCheckpointLogs()) {
            return;
        }
        Optional lastCheckPoint = tailMetadata.getLastCheckPoint();
        if (lastCheckPoint.isEmpty()) {
            this.channel.position(this.lastReadablePosition());
            return;
        }
        LogPosition channelPosition = ((CheckpointInfo)lastCheckPoint.get()).channelPositionAfterCheckpoint();
        if (channelPosition.getLogVersion() != expectedVersion) {
            throw new IllegalStateException("Expected version of checkpoint log " + expectedVersion + ", does not match to found tail version " + channelPosition.getLogVersion());
        }
        this.channel.position(channelPosition.getByteOffset());
    }

    private long lastReadablePosition() throws IOException {
        try (ReadAheadLogChannel reader = new ReadAheadLogChannel(new UnclosableChannel(this.channel), LogVersionBridge.NO_MORE_CHANNELS, this.context.getMemoryTracker());){
            long l;
            try (LogEntryCursor logEntryCursor = new LogEntryCursor((LogEntryReader)new VersionAwareLogEntryReader(CommandReaderFactory.NO_COMMANDS, true, KernelVersion.getLatestVersion((Config)this.context.getConfig())), (ReadableClosablePositionAwareChecksumChannel)reader);){
                while (logEntryCursor.next()) {
                    logEntryCursor.get();
                }
                l = reader.getCurrentPosition().getByteOffset();
            }
            return l;
        }
    }

    public void shutdown() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.writer, this.buffer, this.channel});
        this.writer = null;
        this.buffer = null;
        this.channel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPoint(LogCheckPointEvent logCheckPointEvent, TransactionId transactionId, KernelVersion kernelVersion, LogPosition logPosition, Instant checkpointTime, String reason) throws IOException {
        if (this.writer == null) {
            this.log.warn("Checkpoint was attempted while appender is not started. No checkpoint record will be appended.");
            return;
        }
        CheckpointFile checkpointFile = this.checkpointFile;
        synchronized (checkpointFile) {
            try {
                this.databasePanic.assertNoPanic(IOException.class);
                LogPosition logPositionBeforeCheckpoint = this.writer.getCurrentPosition();
                this.getCheckpointLogEntryWriter(kernelVersion).writeCheckPointEntry(transactionId, kernelVersion, logPosition, checkpointTime, this.storeId, reason);
                LogPosition logPositionAfterCheckpoint = this.writer.getCurrentPosition();
                logCheckPointEvent.appendToLogFile(logPositionBeforeCheckpoint, logPositionAfterCheckpoint);
                this.forceAfterAppend(logCheckPointEvent);
                this.logRotation.rotateLogIfNeeded(logCheckPointEvent);
            }
            catch (Throwable cause) {
                this.databasePanic.panic(cause);
                throw cause;
            }
        }
    }

    private CheckpointLogEntryWriter getCheckpointLogEntryWriter(KernelVersion kernelVersion) {
        return this.checkpointWriters.writer(kernelVersion);
    }

    public long getCurrentPosition() {
        return this.channel.position();
    }

    private void forceAfterAppend(LogCheckPointEvent logCheckPointEvent) throws IOException {
        try (LogForceEvent logForceEvent = logCheckPointEvent.beginLogForce();){
            this.writer.prepareForFlush().flush();
        }
    }

    public Path rotate() throws IOException {
        this.channel = this.rotateChannel(this.channel);
        this.writer.setChannel(this.channel);
        return this.channel.getPath();
    }

    private PhysicalLogVersionedStoreChannel rotateChannel(PhysicalLogVersionedStoreChannel channel) throws IOException {
        long newLogVersion = this.logVersionRepository.incrementAndGetCheckpointLogVersion();
        this.writer.prepareForFlush().flush();
        PhysicalLogVersionedStoreChannel newChannel = this.channelAllocator.createLogChannel(newLogVersion, this.context::committingTransactionId);
        channel.close();
        return newChannel;
    }
}

