/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogIndexEncoding;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.util.VisibleForTesting;

public class TransactionLogWriter {
    private final FlushablePositionAwareChecksumChannel channel;
    private final LogEntryWriter<FlushablePositionAwareChecksumChannel> writer;
    private final KernelVersionProvider versionProvider;

    public TransactionLogWriter(FlushablePositionAwareChecksumChannel channel, KernelVersionProvider versionProvider) {
        this(channel, new LogEntryWriter<FlushablePositionAwareChecksumChannel>(channel), versionProvider);
    }

    @VisibleForTesting
    public TransactionLogWriter(FlushablePositionAwareChecksumChannel channel, LogEntryWriter<FlushablePositionAwareChecksumChannel> writer, KernelVersionProvider versionProvider) {
        this.channel = channel;
        this.writer = writer;
        this.versionProvider = versionProvider;
    }

    public int append(CommandBatch batch, long transactionId, long chunkId, int previousChecksum, LogPosition previousBatchPosition) throws IOException {
        KernelVersion kernelVersion = batch.kernelVersion();
        if (kernelVersion == null) {
            kernelVersion = this.versionProvider.kernelVersion();
        }
        byte version = kernelVersion.version();
        if (batch.isRollback()) {
            return this.writer.writeRollbackEntry(version, transactionId, batch.getTimeCommitted());
        }
        if (batch.isFirst()) {
            this.writer.writeStartEntry(version, batch.getTimeStarted(), batch.getLatestCommittedTxWhenStarted(), previousChecksum, LogIndexEncoding.encodeLogIndex(batch.consensusIndex()));
        } else {
            this.writer.writeChunkStartEntry(version, batch.getTimeCommitted(), chunkId, previousBatchPosition);
        }
        this.writer.serialize((Iterable<StorageCommand>)batch, kernelVersion);
        if (batch.isLast()) {
            return this.writer.writeCommitEntry(version, transactionId, batch.getTimeCommitted());
        }
        return this.writer.writeChunkEndEntry(version, transactionId, chunkId);
    }

    public int append(CommittedCommandBatch commandBatch) throws IOException {
        return commandBatch.serialize(this.writer);
    }

    public LogPosition getCurrentPosition() throws IOException {
        return this.channel.getCurrentPosition();
    }

    public LogPositionMarker getCurrentPosition(LogPositionMarker logPositionMarker) throws IOException {
        return this.channel.getCurrentPosition(logPositionMarker);
    }

    @VisibleForTesting
    public FlushablePositionAwareChecksumChannel getChannel() {
        return this.channel;
    }

    public void append(ByteBuffer byteBuffer) throws IOException {
        this.channel.write(byteBuffer);
    }

    @VisibleForTesting
    public LogEntryWriter<FlushablePositionAwareChecksumChannel> getWriter() {
        return this.writer;
    }
}

