/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;

public class DelegateReadableChannel
implements ReadableClosablePositionAwareChecksumChannel {
    private ReadableChannel delegate;

    public void delegateTo(ReadableChannel delegate) {
        this.delegate = delegate;
    }

    public byte get() throws IOException {
        this.assertAssigned();
        return this.delegate.get();
    }

    public short getShort() throws IOException {
        this.assertAssigned();
        return this.delegate.getShort();
    }

    public int getInt() throws IOException {
        this.assertAssigned();
        return this.delegate.getInt();
    }

    public long getLong() throws IOException {
        this.assertAssigned();
        return this.delegate.getLong();
    }

    public float getFloat() throws IOException {
        this.assertAssigned();
        return this.delegate.getFloat();
    }

    public double getDouble() throws IOException {
        this.assertAssigned();
        return this.delegate.getDouble();
    }

    public void get(byte[] bytes, int length) throws IOException {
        this.assertAssigned();
        this.delegate.get(bytes, length);
    }

    public byte markAndGet(LogPositionMarker marker) throws IOException {
        ReadableChannel readableChannel = this.delegate;
        if (readableChannel instanceof ReadableClosablePositionAwareChecksumChannel) {
            ReadableClosablePositionAwareChecksumChannel posChannel = (ReadableClosablePositionAwareChecksumChannel)readableChannel;
            return posChannel.markAndGet(marker);
        }
        return super.markAndGet(marker);
    }

    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) {
        this.assertAssigned();
        positionMarker.unspecified();
        return positionMarker;
    }

    public LogPosition getCurrentPosition() {
        this.assertAssigned();
        return LogPosition.UNSPECIFIED;
    }

    private void assertAssigned() {
        if (this.delegate == null) {
            throw new IllegalArgumentException("No assigned channel to delegate reads");
        }
    }

    public void close() {
    }

    public void beginChecksum() {
    }

    public int getChecksum() {
        return 0;
    }

    public int endChecksumAndValidate() {
        return 0;
    }
}

