/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexMonitorAdaptor;
import org.neo4j.kernel.impl.index.schema.TokenIndexUpdater;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.monitoring.Monitors;
import org.neo4j.util.Preconditions;

public class TokenIndex
implements ConsistencyCheckable {
    private static final byte CLEAN = 0;
    static final byte ONLINE = 0;
    private static final byte NEEDS_REBUILDING = 1;
    static final byte POPULATING = 1;
    static final byte FAILED = 2;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private final Monitors monitors;
    private final String monitorTag;
    private final PageCache pageCache;
    final IndexFiles indexFiles;
    final FileSystemAbstraction fs;
    private final String databaseName;
    private final CursorContextFactory contextFactory;
    private final ImmutableSet<OpenOption> openOptions;
    private final boolean readOnly;
    private final DependencyResolver dependencyResolver;
    GBPTree<TokenScanKey, TokenScanValue> index;
    TokenIndexUpdater singleUpdater;
    private final String tokenStoreName;
    final PageCacheTracer pageCacheTracer;
    private final IndexDescriptor monitoringDescriptor;

    public TokenIndex(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexDescriptor descriptor, ImmutableSet<OpenOption> openOptions, boolean readOnly) {
        this.readOnlyChecker = databaseIndexContext.readOnlyChecker;
        this.monitors = databaseIndexContext.monitors;
        this.monitorTag = databaseIndexContext.monitorTag;
        this.pageCache = databaseIndexContext.pageCache;
        this.fs = databaseIndexContext.fileSystem;
        this.databaseName = databaseIndexContext.databaseName;
        this.contextFactory = databaseIndexContext.contextFactory;
        this.pageCacheTracer = databaseIndexContext.pageCacheTracer;
        this.dependencyResolver = databaseIndexContext.dependencyResolver;
        this.indexFiles = indexFiles;
        this.tokenStoreName = descriptor.getName();
        this.monitoringDescriptor = descriptor;
        this.openOptions = openOptions;
        this.readOnly = readOnly;
    }

    void instantiateTree(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        this.ensureDirectoryExist();
        MultiRootGBPTree.Monitor monitor = this.treeMonitor();
        this.index = new GBPTree(this.pageCache, this.fs, this.indexFiles.getStoreFile(), (Layout)new TokenScanLayout(), monitor, GBPTree.NO_HEADER_READER, recoveryCleanupWorkCollector, this.readOnly, this.openOptions, this.databaseName, this.tokenStoreName, this.contextFactory, this.pageCacheTracer, this.dependencyResolver);
    }

    void instantiateUpdater() {
        this.singleUpdater = new TokenIndexUpdater(1000);
    }

    private MultiRootGBPTree.Monitor treeMonitor() {
        MultiRootGBPTree.Monitor treeMonitor = (MultiRootGBPTree.Monitor)this.monitors.newMonitor(MultiRootGBPTree.Monitor.class, new String[]{this.monitorTag});
        IndexProvider.Monitor indexMonitor = (IndexProvider.Monitor)this.monitors.newMonitor(IndexProvider.Monitor.class, new String[]{this.monitorTag});
        return new IndexMonitorAdaptor(treeMonitor, indexMonitor, this.indexFiles, this.monitoringDescriptor);
    }

    private void ensureDirectoryExist() {
        this.indexFiles.ensureDirectoryExist();
    }

    void closeResources() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new GBPTree[]{this.index});
        this.index = null;
    }

    void assertTreeOpen() {
        Preconditions.checkState((this.index != null ? 1 : 0) != 0, (String)"Index tree has been closed or was never instantiated.");
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class), contextFactory, numThreads);
    }

    private boolean consistencyCheck(GBPTreeConsistencyCheckVisitor visitor, CursorContextFactory contextFactory, int numThreads) {
        try {
            return this.index.consistencyCheck(visitor, contextFactory, numThreads);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void assertWritable() {
        if (this.readOnlyChecker.isReadOnly()) {
            throw new UnsupportedOperationException("Database currently is in read only mode and can not perform writes");
        }
    }
}

