/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.context;

import org.neo4j.io.pagecache.context.OldestTransactionIdFactory;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.io.pagecache.context.TransactionIdSnapshotFactory;
import org.neo4j.io.pagecache.context.VersionContext;

public class TransactionVersionContext
implements VersionContext {
    private final TransactionIdSnapshotFactory transactionIdSnapshotFactory;
    private final OldestTransactionIdFactory oldestTransactionIdFactory;
    private long transactionId = 1L;
    private TransactionIdSnapshot transactionIds;
    private long oldestTransactionId = 1L;
    private boolean dirty;

    public TransactionVersionContext(TransactionIdSnapshotFactory transactionIdSnapshotFactory, OldestTransactionIdFactory oldestIdFactory) {
        this.transactionIdSnapshotFactory = transactionIdSnapshotFactory;
        this.oldestTransactionIdFactory = oldestIdFactory;
    }

    public void initRead() {
        this.transactionIds = this.transactionIdSnapshotFactory.createSnapshot();
        this.dirty = false;
    }

    public void initWrite(long committingTxId) {
        assert (committingTxId >= 1L);
        this.transactionId = committingTxId;
        this.oldestTransactionId = this.oldestTransactionIdFactory.oldestTransactionId();
    }

    public long committingTransactionId() {
        return this.transactionId;
    }

    public long lastClosedTransactionId() {
        return this.transactionIds.lastClosedTxId();
    }

    public long highestClosed() {
        return this.transactionIds.highestEverSeen();
    }

    public long[] notVisibleTransactionIds() {
        return this.transactionIds.notVisibleTransactions();
    }

    public long oldestVisibleTransactionNumber() {
        return this.oldestTransactionId;
    }

    public void markAsDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

