/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Optional;
import java.util.Set;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public interface DatabaseReferenceRepository {
    public Optional<DatabaseReference> getByAlias(NormalizedDatabaseName var1);

    default public Optional<DatabaseReference.Internal> getInternalByAlias(NormalizedDatabaseName databaseAlias) {
        return this.getByAlias(databaseAlias).filter(DatabaseReference.Internal.class::isInstance).map(DatabaseReference.Internal.class::cast);
    }

    default public Optional<DatabaseReference.External> getExternalByAlias(NormalizedDatabaseName databaseAlias) {
        return this.getByAlias(databaseAlias).filter(DatabaseReference.External.class::isInstance).map(DatabaseReference.External.class::cast);
    }

    default public Optional<DatabaseReference> getByAlias(String databaseName) {
        return this.getByAlias(new NormalizedDatabaseName(databaseName));
    }

    default public Optional<DatabaseReference.Internal> getInternalByAlias(String databaseName) {
        return this.getInternalByAlias(new NormalizedDatabaseName(databaseName));
    }

    default public Optional<DatabaseReference.External> getExternalByAlias(String databaseName) {
        return this.getExternalByAlias(new NormalizedDatabaseName(databaseName));
    }

    public Set<DatabaseReference> getAllDatabaseReferences();

    public Set<DatabaseReference.Internal> getInternalDatabaseReferences();

    public Set<DatabaseReference.External> getExternalDatabaseReferences();

    public Set<DatabaseReference.Composite> getCompositeDatabaseReferences();

    public static interface Caching
    extends DatabaseReferenceRepository {
        public void invalidateAll();
    }
}

