/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.SystemGraphComponent;

public interface ComponentVersion {
    public static final SystemGraphComponent.Name SECURITY_USER_COMPONENT = new SystemGraphComponent.Name("security-users");
    public static final SystemGraphComponent.Name SECURITY_PRIVILEGE_COMPONENT = new SystemGraphComponent.Name("security-privileges");
    public static final SystemGraphComponent.Name DBMS_RUNTIME_COMPONENT = new SystemGraphComponent.Name("dbms-runtime");
    public static final SystemGraphComponent.Name TOPOLOGY_GRAPH_COMPONENT = new SystemGraphComponent.Name("topology-graph");
    public static final SystemGraphComponent.Name COMMUNITY_TOPOLOGY_GRAPH_COMPONENT = new SystemGraphComponent.Name("community-topology-graph");
    public static final SystemGraphComponent.Name FABRIC_DATABASE_COMPONENT = new SystemGraphComponent.Name("fabric-database");
    public static final SystemGraphComponent.Name MULTI_DATABASE_COMPONENT = new SystemGraphComponent.Name("multi-database");
    public static final SystemGraphComponent.Name SYSTEM_GRAPH_COMPONENT = new SystemGraphComponent.Name("system-graph");

    public int getVersion();

    public SystemGraphComponent.Name getComponentName();

    public String getDescription();

    public boolean isCurrent(Config var1);

    public boolean migrationSupported();

    public boolean runtimeSupported();

    default public boolean isGreaterThan(ComponentVersion other) {
        return this.getVersion() > other.getVersion();
    }

    public static class Neo4jVersions {
        public static final String VERSION_40 = "Neo4j 4.0";
        public static final String VERSION_41D1 = "Neo4j 4.1.0-Drop01";
        public static final String VERSION_41 = "Neo4j 4.1";
        public static final String VERSION_42D4 = "Neo4j 4.2.0-Drop04";
        public static final String VERSION_42D6 = "Neo4j 4.2.0-Drop06";
        public static final String VERSION_42D7 = "Neo4j 4.2.0-Drop07";
        public static final String VERSION_42 = "Neo4j 4.2.0";
        public static final String VERSION_42P1 = "Neo4j 4.2.1";
        public static final String VERSION_43D1 = "Neo4j 4.3.0-Drop01";
        public static final String VERSION_43D2 = "Neo4j 4.3.0-Drop02";
        public static final String VERSION_43D3 = "Neo4j 4.3.0-Drop03";
        public static final String VERSION_43D4 = "Neo4j 4.3.0-Drop04";
        public static final String VERSION_44 = "Neo4j 4.4";
        public static final String VERSION_44P7 = "Neo4j 4.4.7";
        public static final String VERSION_50D6 = "Neo4j 5.0.0-Drop06";
        public static final String VERSION_50 = "Neo4j 5.0";
        public static final String VERSION_56 = "Neo4j 5.6";
    }
}

