/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.TimeUnit;
import org.neo4j.common.ProgressReporter;
import org.neo4j.dbms.database.DatabaseStartAbortedException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatch;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryPredicate;
import org.neo4j.kernel.recovery.RecoveryPredicateException;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;
import org.neo4j.kernel.recovery.RecoveryStartupChecker;
import org.neo4j.kernel.recovery.TransactionIdTracker;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.time.Stopwatch;

public class TransactionLogsRecovery
extends LifecycleAdapter {
    private static final String REVERSE_RECOVERY_TAG = "restoreDatabase";
    private static final String RECOVERY_TAG = "recoverDatabase";
    private static final String RECOVERY_COMPLETED_TAG = "databaseRecoveryCompleted";
    private final RecoveryService recoveryService;
    private final RecoveryMonitor monitor;
    private final CorruptedLogsTruncator logsTruncator;
    private final Lifecycle schemaLife;
    private final ProgressReporter progressReporter;
    private final boolean failOnCorruptedLogFiles;
    private final RecoveryStartupChecker recoveryStartupChecker;
    private final CursorContextFactory contextFactory;
    private final RecoveryPredicate recoveryPredicate;

    public TransactionLogsRecovery(RecoveryService recoveryService, CorruptedLogsTruncator logsTruncator, Lifecycle schemaLife, RecoveryMonitor monitor, ProgressReporter progressReporter, boolean failOnCorruptedLogFiles, RecoveryStartupChecker recoveryStartupChecker, RecoveryPredicate recoveryPredicate, CursorContextFactory contextFactory) {
        this.recoveryService = recoveryService;
        this.monitor = monitor;
        this.logsTruncator = logsTruncator;
        this.schemaLife = schemaLife;
        this.progressReporter = progressReporter;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.recoveryStartupChecker = recoveryStartupChecker;
        this.contextFactory = contextFactory;
        this.recoveryPredicate = recoveryPredicate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws Exception {
        RecoveryStartInformation recoveryStartInformation = this.recoveryService.getRecoveryStartInformation();
        if (!recoveryStartInformation.isRecoveryRequired()) {
            this.schemaLife.init();
            return;
        }
        Stopwatch recoveryStartTime = Stopwatch.start();
        LogPosition recoveryStartPosition = recoveryStartInformation.getTransactionLogPosition();
        this.monitor.recoveryRequired(recoveryStartPosition);
        LogPosition recoveryToPosition = recoveryStartPosition;
        LogPosition lastTransactionPosition = recoveryStartPosition;
        CommittedCommandBatch lastCommandBatch = null;
        CommittedCommandBatch lastReversedCommandBatch = null;
        if (!recoveryStartInformation.isMissingLogs()) {
            try {
                long lowestRecoveredTxId = 1L;
                TransactionIdTracker transactionIdTracker = new TransactionIdTracker();
                try (CommandBatchCursor transactionsToRecover = this.recoveryService.getCommandBatchesInReverseOrder(recoveryStartPosition);
                     RecoveryApplier recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.REVERSE_RECOVERY, this.contextFactory, REVERSE_RECOVERY_TAG);){
                    while (transactionsToRecover.next()) {
                        this.recoveryStartupChecker.checkIfCanceled();
                        CommittedCommandBatch commandBatch = (CommittedCommandBatch)transactionsToRecover.get();
                        if (lastReversedCommandBatch == null) {
                            lastReversedCommandBatch = commandBatch;
                            this.initProgressReporter(recoveryStartInformation, lastReversedCommandBatch);
                        }
                        recoveryVisitor.visit(commandBatch);
                        transactionIdTracker.trackBatch(commandBatch);
                        lowestRecoveredTxId = commandBatch.txId();
                        this.reportProgress();
                    }
                }
                this.monitor.reverseStoreRecoveryCompleted(lowestRecoveredTxId);
                this.schemaLife.init();
                boolean fullRecovery = true;
                try (CommandBatchCursor transactionsToRecover = this.recoveryService.getCommandBatches(recoveryStartPosition);
                     RecoveryApplier recoveryVisitor = this.recoveryService.getRecoveryApplier(TransactionApplicationMode.RECOVERY, this.contextFactory, RECOVERY_TAG);){
                    while (fullRecovery && transactionsToRecover.next()) {
                        CommittedCommandBatch nextCommandBatch = (CommittedCommandBatch)transactionsToRecover.get();
                        if (!this.recoveryPredicate.test(nextCommandBatch)) {
                            this.monitor.partialRecovery(this.recoveryPredicate, lastCommandBatch);
                            fullRecovery = false;
                            if (lastCommandBatch != null) continue;
                            long beforeCheckpointTransaction = recoveryStartInformation.getFirstTxIdAfterLastCheckPoint() - 1L;
                            if (beforeCheckpointTransaction < 1L) {
                                throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and transaction before checkpoint is not valid. Transaction id before checkpoint: %d, criteria %s.", beforeCheckpointTransaction, this.recoveryPredicate.describe()));
                            }
                            try {
                                CommandBatchCursor beforeCheckpointCursor = this.recoveryService.getCommandBatches(beforeCheckpointTransaction);
                                try {
                                    if (beforeCheckpointCursor.next()) {
                                        CommittedCommandBatch candidate = (CommittedCommandBatch)beforeCheckpointCursor.get();
                                        if (!this.recoveryPredicate.test(candidate)) {
                                            throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. Transaction after and before checkpoint does not satisfy provided recovery criteria. Observed transaction id: %d, recovery criteria: %s.", candidate.txId(), this.recoveryPredicate.describe()));
                                        }
                                        lastCommandBatch = candidate;
                                        lastTransactionPosition = beforeCheckpointCursor.position();
                                        continue;
                                    }
                                    throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and transaction before checkpoint not found. Recovery criteria: %s.", this.recoveryPredicate.describe()));
                                }
                                finally {
                                    if (beforeCheckpointCursor == null) continue;
                                    beforeCheckpointCursor.close();
                                    continue;
                                }
                            }
                            catch (RecoveryPredicateException re) {
                                throw re;
                            }
                            catch (Exception e) {
                                throw new RecoveryPredicateException(String.format("Partial recovery criteria can't be satisfied. No transaction after checkpoint matching to provided criteria found and fail to read transaction before checkpoint. Recovery criteria: %s.", this.recoveryPredicate.describe()), e);
                            }
                        }
                        this.recoveryStartupChecker.checkIfCanceled();
                        if (transactionIdTracker.isCompletedTransaction(nextCommandBatch.txId())) {
                            recoveryVisitor.visit(nextCommandBatch);
                            this.monitor.batchRecovered(nextCommandBatch);
                        } else {
                            this.monitor.batchRolledback(nextCommandBatch);
                        }
                        if (lastCommandBatch == null || lastCommandBatch.txId() < nextCommandBatch.txId()) {
                            lastCommandBatch = nextCommandBatch;
                        }
                        recoveryToPosition = lastTransactionPosition = transactionsToRecover.position();
                        this.reportProgress();
                    }
                    recoveryToPosition = fullRecovery ? transactionsToRecover.position() : lastTransactionPosition;
                }
            }
            catch (Error | ClosedByInterruptException | DatabaseStartAbortedException | RecoveryPredicateException e) {
                throw e;
            }
            catch (Throwable t) {
                if (this.failOnCorruptedLogFiles) {
                    Recovery.throwUnableToCleanRecover(t);
                }
                if (lastCommandBatch != null) {
                    this.monitor.failToRecoverTransactionsAfterCommit(t, lastCommandBatch, recoveryToPosition);
                }
                this.monitor.failToRecoverTransactionsAfterPosition(t, recoveryStartPosition);
            }
            this.progressReporter.completed();
            this.logsTruncator.truncate(recoveryToPosition);
        }
        try (CursorContext cursorContext = this.contextFactory.create(RECOVERY_COMPLETED_TAG);){
            boolean missingLogs = recoveryStartInformation.isMissingLogs();
            this.recoveryService.transactionsRecovered(lastCommandBatch, lastTransactionPosition, recoveryToPosition, recoveryStartInformation.getCheckpointPosition(), missingLogs, cursorContext);
        }
        this.monitor.recoveryCompleted(recoveryStartTime.elapsed(TimeUnit.MILLISECONDS));
    }

    private void initProgressReporter(RecoveryStartInformation recoveryStartInformation, CommittedCommandBatch lastReversedBatch) {
        long numberOfTransactionToRecover = TransactionLogsRecovery.estimateNumberOfTransactionToRecover(recoveryStartInformation, lastReversedBatch);
        this.progressReporter.start(numberOfTransactionToRecover * 2L);
    }

    private void reportProgress() {
        this.progressReporter.progress(1L);
    }

    private static long estimateNumberOfTransactionToRecover(RecoveryStartInformation recoveryStartInformation, CommittedCommandBatch lastReversedCommandBatch) {
        return lastReversedCommandBatch.txId() - recoveryStartInformation.getFirstTxIdAfterLastCheckPoint() + 1L;
    }

    public void start() throws Exception {
        this.schemaLife.start();
    }

    public void stop() throws Exception {
        this.schemaLife.stop();
    }

    public void shutdown() throws Exception {
        this.schemaLife.shutdown();
    }
}

