/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.collection.trackable.HeapTrackingConcurrentBag;
import org.neo4j.collection.trackable.HeapTrackingConcurrentHashMap;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;

public class ConcurrentProbeTable<K extends Measurable, V extends Measurable>
extends DefaultCloseListenable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ConcurrentProbeTable.class);
    private final MemoryTracker scopedMemoryTracker;
    private HeapTrackingConcurrentHashMap<K, HeapTrackingConcurrentBag<V>> map;

    public static <K extends Measurable, V extends Measurable> ConcurrentProbeTable<K, V> createProbeTable(MemoryTracker memoryTracker) {
        MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        return new ConcurrentProbeTable<K, V>(scopedMemoryTracker);
    }

    private ConcurrentProbeTable(MemoryTracker scopedMemoryTracker) {
        this.scopedMemoryTracker = scopedMemoryTracker;
        this.map = HeapTrackingConcurrentHashMap.newMap((MemoryTracker)scopedMemoryTracker);
    }

    public void put(K key, V value) {
        MutableLong heapUsage = new MutableLong(value.estimatedHeapUsage() + HeapTrackingConcurrentBag.staticSizeOfWrapperObject());
        ((HeapTrackingConcurrentBag)this.map.computeIfAbsent(key, p -> {
            heapUsage.add(key.estimatedHeapUsage() + this.map.sizeOfWrapperObject());
            return HeapTrackingConcurrentBag.newBag((MemoryTracker)this.scopedMemoryTracker);
        })).add(value);
        this.scopedMemoryTracker.allocateHeap(heapUsage.longValue());
    }

    public Iterator<V> get(K key) {
        HeapTrackingConcurrentBag entry = (HeapTrackingConcurrentBag)this.map.get(key);
        if (entry == null) {
            return Collections.emptyIterator();
        }
        return entry.iterator();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void closeInternal() {
        if (this.map != null) {
            this.scopedMemoryTracker.close();
            this.map = null;
        }
    }

    public boolean isClosed() {
        return this.map == null;
    }
}

