/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.FilteringNativeHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeHitIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;

abstract class NativeIndexReader<KEY extends NativeIndexKey<KEY>>
implements ValueIndexReader {
    protected final IndexDescriptor descriptor;
    final IndexLayout<KEY> layout;
    final GBPTree<KEY, NullValue> tree;

    NativeIndexReader(GBPTree<KEY, NullValue> tree, IndexLayout<KEY> layout, IndexDescriptor descriptor) {
        this.tree = tree;
        this.layout = layout;
        this.descriptor = descriptor;
    }

    public void close() {
    }

    public IndexSampler createSampler() {
        FullScanNonUniqueIndexSampler sampler = new FullScanNonUniqueIndexSampler(this.tree, this.layout);
        return tracer -> {
            try {
                return sampler.sample(tracer);
            }
            catch (UncheckedIOException e) {
                if (ExceptionUtils.getRootCause((Throwable)e) instanceof FileIsNotMappedException) {
                    IndexNotFoundKernelException exception = new IndexNotFoundKernelException("Index dropped while sampling.");
                    exception.addSuppressed((Throwable)e);
                    throw exception;
                }
                throw e;
            }
        };
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        long l;
        block10: {
            NativeIndexKey treeKeyFrom = (NativeIndexKey)((Object)this.layout.newKey());
            NativeIndexKey treeKeyTo = (NativeIndexKey)((Object)this.layout.newKey());
            treeKeyFrom.initialize(entityId);
            treeKeyTo.initialize(entityId);
            for (int i = 0; i < propertyValues.length; ++i) {
                treeKeyFrom.initFromValue(i, propertyValues[i], NativeIndexKey.Inclusion.NEUTRAL);
                treeKeyTo.initFromValue(i, propertyValues[i], NativeIndexKey.Inclusion.NEUTRAL);
            }
            Seeker seeker = this.tree.seek((Object)treeKeyFrom, (Object)treeKeyTo, cursorContext);
            try {
                long count = 0L;
                while (seeker.next()) {
                    if (((NativeIndexKey)((Object)seeker.key())).getEntityId() != entityId) continue;
                    ++count;
                }
                l = count;
                if (seeker == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (seeker != null) {
                        try {
                            seeker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            seeker.close();
        }
        return l;
    }

    public void query(IndexProgressor.EntityValueClient cursor, QueryContext context, AccessMode accessMode, IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) {
        this.validateQuery(constraints, predicates);
        context.monitor().queried(this.descriptor);
        NativeIndexKey treeKeyFrom = (NativeIndexKey)((Object)this.layout.newKey());
        NativeIndexKey treeKeyTo = (NativeIndexKey)((Object)this.layout.newKey());
        this.initializeFromToKeys(treeKeyFrom, treeKeyTo);
        boolean needFilter = this.initializeRangeForQuery(treeKeyFrom, treeKeyTo, predicates);
        this.startSeekForInitializedRange(cursor, treeKeyFrom, treeKeyTo, context.cursorContext(), accessMode, needFilter, constraints, predicates);
    }

    void initializeFromToKeys(KEY treeKeyFrom, KEY treeKeyTo) {
        ((NativeIndexKey)((Object)treeKeyFrom)).initialize(Long.MIN_VALUE);
        ((NativeIndexKey)((Object)treeKeyTo)).initialize(Long.MAX_VALUE);
    }

    abstract void validateQuery(IndexQueryConstraints var1, PropertyIndexQuery ... var2);

    abstract boolean initializeRangeForQuery(KEY var1, KEY var2, PropertyIndexQuery ... var3);

    void startSeekForInitializedRange(IndexProgressor.EntityValueClient client, KEY treeKeyFrom, KEY treeKeyTo, CursorContext cursorContext, AccessMode accessMode, boolean needFilter, IndexQueryConstraints constraints, PropertyIndexQuery ... query) {
        if (this.isEmptyRange(treeKeyFrom, treeKeyTo) || this.isEmptyResultQuery(query)) {
            client.initialize(this.descriptor, IndexProgressor.EMPTY, accessMode, false, false, constraints, query);
            return;
        }
        try {
            Seeker<KEY, NullValue> seeker = this.makeIndexSeeker(treeKeyFrom, treeKeyTo, constraints.order(), cursorContext);
            IndexProgressor hitProgressor = this.getIndexProgressor(seeker, client, needFilter, query);
            client.initialize(this.descriptor, hitProgressor, accessMode, false, false, constraints, query);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    Seeker<KEY, NullValue> makeIndexSeeker(KEY treeKeyFrom, KEY treeKeyTo, IndexOrder indexOrder, CursorContext cursorContext) throws IOException {
        if (indexOrder == IndexOrder.DESCENDING) {
            KEY tmpKey = treeKeyFrom;
            treeKeyFrom = treeKeyTo;
            treeKeyTo = tmpKey;
        }
        return this.tree.seek(treeKeyFrom, treeKeyTo, cursorContext);
    }

    private IndexProgressor getIndexProgressor(Seeker<KEY, NullValue> seeker, IndexProgressor.EntityValueClient client, boolean needFilter, PropertyIndexQuery ... query) {
        return needFilter ? new FilteringNativeHitIndexProgressor<KEY>(seeker, client, query) : new NativeHitIndexProgressor<KEY>(seeker, client);
    }

    private boolean isEmptyRange(KEY treeKeyFrom, KEY treeKeyTo) {
        return this.layout.compare(treeKeyFrom, treeKeyTo) > 0;
    }

    private boolean isEmptyResultQuery(PropertyIndexQuery ... predicates) {
        for (PropertyIndexQuery predicate : predicates) {
            if (!(predicate instanceof PropertyIndexQuery.IncomparableRangePredicate) && !(predicate instanceof PropertyIndexQuery.IncomparableExactPredicate)) continue;
            return true;
        }
        return false;
    }

    public PartitionedValueSeek valueSeek(int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) {
        try {
            return new NativePartitionedValueSeek(desiredNumberOfPartitions, queryContext, query);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    class NativePartitionedValueSeek
    implements PartitionedValueSeek {
        private final PropertyIndexQuery[] query;
        private final boolean filter;
        private final List<KEY> partitionEdges;
        private final AtomicInteger nextFrom = new AtomicInteger();

        NativePartitionedValueSeek(int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws IOException {
            Preconditions.requirePositive((int)desiredNumberOfPartitions);
            NativeIndexReader.this.validateQuery(IndexQueryConstraints.unorderedValues(), query);
            this.query = query;
            NativeIndexKey fromInclusive = (NativeIndexKey)((Object)NativeIndexReader.this.layout.newKey());
            NativeIndexKey toExclusive = (NativeIndexKey)((Object)NativeIndexReader.this.layout.newKey());
            NativeIndexReader.this.initializeFromToKeys(fromInclusive, toExclusive);
            this.filter = NativeIndexReader.this.initializeRangeForQuery(fromInclusive, toExclusive, this.query);
            this.partitionEdges = !NativeIndexReader.this.isEmptyResultQuery(query) ? NativeIndexReader.this.tree.partitionedSeek((Object)fromInclusive, (Object)toExclusive, desiredNumberOfPartitions, queryContext.cursorContext()) : Collections.emptyList();
        }

        public int getNumberOfPartitions() {
            return this.partitionEdges.size() - 1;
        }

        public IndexProgressor reservePartition(IndexProgressor.EntityValueClient client, CursorContext cursorContext) {
            int from = this.nextFrom.getAndIncrement();
            int to = from + 1;
            if (to >= this.partitionEdges.size()) {
                return IndexProgressor.EMPTY;
            }
            try {
                NativeIndexKey fromInclusive = (NativeIndexKey)((Object)this.partitionEdges.get(from));
                NativeIndexKey toExclusive = (NativeIndexKey)((Object)this.partitionEdges.get(to));
                return NativeIndexReader.this.getIndexProgressor(NativeIndexReader.this.tree.seek((Object)fromInclusive, (Object)toExclusive, cursorContext), client, this.filter, this.query);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

