/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.UpgradeLocker;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.InternalTransactionEventListener;
import org.neo4j.lock.Lock;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

class DatabaseUpgradeTransactionHandler {
    private final DbmsRuntimeRepository dbmsRuntimeRepository;
    private final KernelVersionProvider kernelVersionProvider;
    private final DatabaseTransactionEventListeners transactionEventListeners;
    private final AtomicBoolean unregistered = new AtomicBoolean();
    private final UpgradeLocker locker;
    private final InternalLog log;

    DatabaseUpgradeTransactionHandler(DbmsRuntimeRepository dbmsRuntimeRepository, KernelVersionProvider kernelVersionProvider, DatabaseTransactionEventListeners transactionEventListeners, UpgradeLocker locker, InternalLogProvider logProvider) {
        this.dbmsRuntimeRepository = dbmsRuntimeRepository;
        this.kernelVersionProvider = kernelVersionProvider;
        this.transactionEventListeners = transactionEventListeners;
        this.locker = locker;
        this.log = logProvider.getLog(this.getClass());
    }

    void registerUpgradeListener(InternalUpgradeTransactionHandler internalUpgradeTransactionHandler) {
        if (!this.kernelVersionProvider.kernelVersion().isLatest()) {
            this.transactionEventListeners.registerTransactionEventListener(new DatabaseUpgradeListener(internalUpgradeTransactionHandler));
        }
    }

    private class DatabaseUpgradeListener
    extends InternalTransactionEventListener.Adapter<Lock> {
        private final InternalUpgradeTransactionHandler internalUpgradeTransactionHandler;

        DatabaseUpgradeListener(InternalUpgradeTransactionHandler internalUpgradeTransactionHandler) {
            this.internalUpgradeTransactionHandler = internalUpgradeTransactionHandler;
        }

        @Override
        public Lock beforeCommit(TransactionData data, KernelTransaction tx, GraphDatabaseService databaseService) throws Exception {
            KernelVersion checkKernelVersion = DatabaseUpgradeTransactionHandler.this.kernelVersionProvider.kernelVersion();
            if (DatabaseUpgradeTransactionHandler.this.dbmsRuntimeRepository.getVersion().kernelVersion().isGreaterThan(checkKernelVersion)) {
                try (Lock lock = DatabaseUpgradeTransactionHandler.this.locker.acquireWriteLock(tx);){
                    KernelVersion kernelVersionToUpgradeTo = DatabaseUpgradeTransactionHandler.this.dbmsRuntimeRepository.getVersion().kernelVersion();
                    KernelVersion currentKernelVersion = DatabaseUpgradeTransactionHandler.this.kernelVersionProvider.kernelVersion();
                    if (kernelVersionToUpgradeTo.isGreaterThan(currentKernelVersion)) {
                        DatabaseUpgradeTransactionHandler.this.log.info("Upgrade transaction from %s to %s started", new Object[]{currentKernelVersion, kernelVersionToUpgradeTo});
                        this.internalUpgradeTransactionHandler.upgrade(currentKernelVersion, kernelVersionToUpgradeTo);
                        DatabaseUpgradeTransactionHandler.this.log.info("Upgrade transaction from %s to %s completed", new Object[]{currentKernelVersion, kernelVersionToUpgradeTo});
                    }
                }
                catch (DeadlockDetectedException | LockAcquisitionTimeoutException ignore) {
                    DatabaseUpgradeTransactionHandler.this.log.info("Upgrade transaction from %s to %s not possible right now due to conflicting transaction, will retry on next write", new Object[]{checkKernelVersion, DatabaseUpgradeTransactionHandler.this.dbmsRuntimeRepository.getVersion().kernelVersion()});
                }
            }
            return DatabaseUpgradeTransactionHandler.this.locker.acquireReadLock(tx);
        }

        public void afterCommit(TransactionData data, Lock readLock, GraphDatabaseService databaseService) {
            this.checkUnlockAndUnregister(readLock);
        }

        public void afterRollback(TransactionData data, Lock readLock, GraphDatabaseService databaseService) {
            this.checkUnlockAndUnregister(readLock);
        }

        private void checkUnlockAndUnregister(Lock readLock) {
            if (readLock == null) {
                return;
            }
            readLock.close();
            if (DatabaseUpgradeTransactionHandler.this.kernelVersionProvider.kernelVersion().isLatest() && DatabaseUpgradeTransactionHandler.this.unregistered.compareAndSet(false, true)) {
                try {
                    DatabaseUpgradeTransactionHandler.this.transactionEventListeners.unregisterTransactionEventListener(this);
                }
                catch (Throwable e) {
                    DatabaseUpgradeTransactionHandler.this.unregistered.set(false);
                    throw e;
                }
            }
        }
    }

    static interface InternalUpgradeTransactionHandler {
        public void upgrade(KernelVersion var1, KernelVersion var2) throws TransactionFailureException;
    }
}

