/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.recovery.RecoveryApplier;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;

final class RecoveryVisitor
implements RecoveryApplier {
    private final StorageEngine storageEngine;
    private final TransactionApplicationMode mode;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;

    RecoveryVisitor(StorageEngine storageEngine, TransactionApplicationMode mode, CursorContextFactory contextFactory, String tracerTag) {
        this.storageEngine = storageEngine;
        this.mode = mode;
        this.cursorContext = contextFactory.create(tracerTag);
        this.storeCursors = storageEngine.createStorageCursors(this.cursorContext);
    }

    public boolean visit(CommittedTransactionRepresentation transaction) throws Exception {
        TransactionToApply tx = new TransactionToApply(transaction, this.cursorContext, this.storeCursors);
        this.storageEngine.apply((CommandBatchToApply)tx, this.mode);
        return false;
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.storeCursors, this.cursorContext});
    }
}

