/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import jdk.jfr.Configuration;
import jdk.jfr.consumer.RecordingStream;

public class JvmMetadataRepository {
    public String getJavaVmName() {
        return System.getProperty("java.vm.name");
    }

    public Runtime.Version getJavaVersion() {
        return Runtime.version();
    }

    public List<String> getJvmInputArguments() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getInputArguments();
    }

    public MemoryUsage getHeapMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
    }

    public long getReservedCodeCacheSize() {
        AtomicLong reservedSize = new AtomicLong(-1L);
        try (RecordingStream rs = new RecordingStream(Configuration.getConfiguration("default"));){
            CountDownLatch latch = new CountDownLatch(1);
            rs.onEvent("jdk.CodeCacheConfiguration", event -> {
                try {
                    reservedSize.set(event.getLong("reservedSize"));
                }
                finally {
                    latch.countDown();
                }
            });
            rs.startAsync();
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (IOException | InterruptedException | ParseException exception) {
            // empty catch block
        }
        return reservedSize.get();
    }

    public long getMaxMetaspaceSize() {
        for (MemoryPoolMXBean memoryMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!"Metaspace".equals(memoryMXBean.getName())) continue;
            return memoryMXBean.getUsage().getMax();
        }
        return -1L;
    }
}

