/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.chunk;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.common.Subject;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.chunk.CommandChunk;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.Commitment;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class ChunkedTransaction
implements CommandBatchToApply,
CommandBatch {
    private CommandChunk chunk;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;
    private final Commitment commitment;
    private final TransactionIdGenerator transactionIdGenerator;
    private boolean idGenerated;
    private long transactionId = 0L;
    private CommandBatchToApply next;

    public ChunkedTransaction(CursorContext cursorContext, StoreCursors storeCursors, Commitment commitment, TransactionIdGenerator transactionIdGenerator) {
        this.cursorContext = cursorContext;
        this.storeCursors = storeCursors;
        this.commitment = commitment;
        this.transactionIdGenerator = transactionIdGenerator;
    }

    public void init(CommandChunk chunk) {
        this.chunk = chunk;
    }

    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        for (StorageCommand command : this.chunk.commands()) {
            if (!visitor.visit((Object)command)) continue;
            return true;
        }
        return false;
    }

    public long transactionId() {
        if (this.idGenerated) {
            return this.transactionId;
        }
        this.transactionId = this.transactionIdGenerator.nextId(this.transactionId);
        this.idGenerated = true;
        return this.transactionId;
    }

    public long chunkId() {
        return this.chunk.chunkMetadata().chunkId();
    }

    public byte[] additionalHeader() {
        return ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    public long getTimeStarted() {
        return this.chunk.chunkMetadata().startTimeMillis();
    }

    public long getLatestCommittedTxWhenStarted() {
        return this.chunk.chunkMetadata().lastTransactionIdWhenStarted();
    }

    public long getTimeCommitted() {
        return this.chunk.chunkMetadata().chunkCommitTime();
    }

    public int getLeaseId() {
        return this.chunk.chunkMetadata().leaseId();
    }

    public Subject subject() {
        return this.chunk.chunkMetadata().subject();
    }

    public KernelVersion kernelVersion() {
        return this.chunk.chunkMetadata().kernelVersion();
    }

    public String toString(boolean includeCommands) {
        return "ChunkedTransaction{chunk=" + this.chunk + ", commitment=" + this.commitment + ", transactionId=" + this.transactionId + "}";
    }

    public boolean isLast() {
        return this.chunk.chunkMetadata().last();
    }

    public boolean isFirst() {
        return this.chunk.chunkMetadata().first();
    }

    public CursorContext cursorContext() {
        return this.cursorContext;
    }

    public StoreCursors storeCursors() {
        return this.storeCursors;
    }

    public CommandBatchToApply next() {
        return this.next;
    }

    public void next(CommandBatchToApply next) {
        this.next = next;
    }

    public void commit() {
        if (this.isLast()) {
            this.commitment.publishAsCommitted(this.chunk.chunkMetadata().chunkCommitTime());
        }
    }

    public CommandBatch commandBatch() {
        return this;
    }

    public void batchAppended(LogPosition beforeCommit, LogPosition positionAfter, int checksum) {
        if (this.isFirst()) {
            this.commitment.commit(this.transactionId, beforeCommit, positionAfter, checksum);
            this.cursorContext.getVersionContext().initWrite(this.transactionId);
        }
    }

    public void close() {
        this.commitment.publishAsClosed();
    }

    public Iterator<StorageCommand> iterator() {
        return this.chunk.commands().iterator();
    }
}

