/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.function.Function;
import java.util.function.LongFunction;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.device.DeviceMapper;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.watcher.DatabaseLayoutWatcher;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ExternalIdReuseConditionProvider;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.pagecache.IOControllerService;
import org.neo4j.kernel.impl.pagecache.VersionStorageFactory;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.internal.DatabaseLogService;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;

public interface DatabaseCreationContext {
    public NamedDatabaseId getNamedDatabaseId();

    public DatabaseLayout getDatabaseLayout();

    public DatabaseConfig getDatabaseConfig();

    public IdGeneratorFactory getIdGeneratorFactory();

    public DatabaseLogService getDatabaseLogService();

    public JobScheduler getScheduler();

    public DependencyResolver getGlobalDependencies();

    public TokenHolders getTokenHolders();

    public Locks getLocks();

    public GlobalTransactionEventListeners getTransactionEventListeners();

    public FileSystemAbstraction getFs();

    public DatabaseTransactionStats getTransactionStats();

    public Factory<DatabaseHealth> getDatabaseHealthFactory();

    public CommitProcessFactory getCommitProcessFactory();

    public PageCache getPageCache();

    public ConstraintSemantics getConstraintSemantics();

    public Monitors getMonitors();

    public Tracers getTracers();

    public GlobalProcedures getGlobalProcedures();

    public IOControllerService getIoControllerService();

    public LongFunction<DatabaseAvailabilityGuard> getDatabaseAvailabilityGuardFactory();

    public SystemNanoClock getClock();

    public StoreCopyCheckPointMutex getStoreCopyCheckPointMutex();

    public IdController getIdController();

    public DbmsInfo getDbmsInfo();

    public TopologyGraphDbmsModel.HostedOnMode getMode();

    public CollectionsFactorySupplier getCollectionsFactorySupplier();

    public Iterable<ExtensionFactory<?>> getExtensionFactories();

    public Function<DatabaseLayout, DatabaseLayoutWatcher> getWatcherServiceFactory();

    public QueryEngineProvider getEngineProvider();

    public DatabaseEventListeners getDatabaseEventListeners();

    public StorageEngineFactory getStorageEngineFactory();

    public FileLockerService getFileLockerService();

    public AccessCapabilityFactory getAccessCapabilityFactory();

    public LeaseService getLeaseService();

    public DatabaseStartupController getStartupController();

    public GlobalMemoryGroupTracker getTransactionsMemoryPool();

    public GlobalMemoryGroupTracker getOtherMemoryPool();

    public ReadOnlyDatabases getDbmsReadOnlyChecker();

    public CursorContextFactory getContextFactory();

    public ExternalIdReuseConditionProvider externalIdReuseConditionProvider();

    public static StorageEngineFactory selectStorageEngine(FileSystemAbstraction fs, Neo4jLayout neo4jLayout, Configuration config, NamedDatabaseId namedDatabaseId) {
        return StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fs, (DatabaseLayout)neo4jLayout.databaseLayout(namedDatabaseId.name()), (Configuration)(namedDatabaseId.isSystemDatabase() ? null : config));
    }

    public VersionStorageFactory getVersionStorageFactory();

    public DeviceMapper getDeviceMapper();
}

