/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.StorageCommand;

public class LogEntryWriter<T extends WritableChecksumChannel> {
    private final Visitor<StorageCommand, IOException> serializer;
    protected final T channel;
    private final byte parserSetVersion;

    public LogEntryWriter(T channel, KernelVersion version) {
        this.channel = channel;
        this.parserSetVersion = version.version();
        this.serializer = new StorageCommandSerializer((WritableChannel)channel, this);
    }

    public void writeLogEntryHeader(byte type, WritableChannel channel) throws IOException {
        channel.put(this.parserSetVersion).put(type);
    }

    private void writeStartEntry(LogEntryStart entry) throws IOException {
        this.writeStartEntry(entry.getTimeWritten(), entry.getLastCommittedTxWhenTransactionStarted(), entry.getPreviousChecksum(), entry.getAdditionalHeader());
    }

    public void writeStartEntry(long timeWritten, long latestCommittedTxWhenStarted, int previousChecksum, byte[] additionalHeaderData) throws IOException {
        this.channel.beginChecksum();
        this.writeLogEntryHeader((byte)1, (WritableChannel)this.channel);
        this.channel.putLong(timeWritten).putLong(latestCommittedTxWhenStarted).putInt(previousChecksum).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
    }

    private void writeCommitEntry(LogEntryCommit entry) throws IOException {
        this.writeCommitEntry(entry.getTxId(), entry.getTimeWritten());
    }

    public int writeCommitEntry(long transactionId, long timeWritten) throws IOException {
        this.writeLogEntryHeader((byte)5, (WritableChannel)this.channel);
        this.channel.putLong(transactionId).putLong(timeWritten);
        return this.channel.putChecksum();
    }

    public void serialize(CommandBatch tx) throws IOException {
        tx.accept(this.serializer);
    }

    public void serialize(CommittedTransactionRepresentation tx) throws IOException {
        this.writeStartEntry(tx.startEntry());
        this.serialize(tx.commandBatch());
        this.writeCommitEntry(tx.commitEntry());
    }

    public void serialize(Collection<StorageCommand> commands) throws IOException {
        for (StorageCommand command : commands) {
            this.serializer.visit((Object)command);
        }
    }

    public void serialize(StorageCommand command) throws IOException {
        this.serializer.visit((Object)command);
    }

    public T getChannel() {
        return this.channel;
    }

    private static class StorageCommandSerializer
    implements Visitor<StorageCommand, IOException> {
        private final WritableChannel channel;
        private final LogEntryWriter entryWriter;

        StorageCommandSerializer(WritableChannel channel, LogEntryWriter entryWriter) {
            this.channel = channel;
            this.entryWriter = entryWriter;
        }

        public boolean visit(StorageCommand command) throws IOException {
            this.entryWriter.writeLogEntryHeader((byte)3, this.channel);
            command.serialize(this.channel);
            return false;
        }
    }
}

