/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.helpers.Format;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Health;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.time.Stopwatch;

public class CheckPointerImpl
extends LifecycleAdapter
implements CheckPointer {
    private static final String CHECKPOINT_TAG = "checkpoint";
    private static final long NO_TRANSACTION_ID = -1L;
    private static final String IO_DETAILS_TEMPLATE = "Checkpoint flushed %d pages (%d%% of total available pages), in %d IOs. Checkpoint performed with IO limit: %s, paused in total %d times( %d millis).";
    private static final String UNLIMITED_IO_CONTROLLER_LIMIT = "unlimited";
    private final CheckpointAppender checkpointAppender;
    private final MetadataProvider metadataProvider;
    private final CheckPointThreshold threshold;
    private final ForceOperation forceOperation;
    private final LogPruning logPruning;
    private final Health databaseHealth;
    private final InternalLog log;
    private final DatabaseTracers tracers;
    private final StoreCopyCheckPointMutex mutex;
    private final CursorContextFactory cursorContextFactory;
    private final Clock clock;
    private final IOController ioController;
    private volatile long lastCheckPointedTx;

    public CheckPointerImpl(MetadataProvider metadataProvider, CheckPointThreshold threshold, ForceOperation forceOperation, LogPruning logPruning, CheckpointAppender checkpointAppender, Health databaseHealth, InternalLogProvider logProvider, DatabaseTracers tracers, StoreCopyCheckPointMutex mutex, CursorContextFactory cursorContextFactory, Clock clock, IOController ioController) {
        this.checkpointAppender = checkpointAppender;
        this.metadataProvider = metadataProvider;
        this.threshold = threshold;
        this.forceOperation = forceOperation;
        this.logPruning = logPruning;
        this.databaseHealth = databaseHealth;
        this.log = logProvider.getLog(CheckPointerImpl.class);
        this.tracers = tracers;
        this.mutex = mutex;
        this.cursorContextFactory = cursorContextFactory;
        this.clock = clock;
        this.ioController = ioController;
    }

    public void start() {
        ClosedTransactionMetadata lastClosedTransaction = this.metadataProvider.getLastClosedTransaction();
        this.threshold.initialize(lastClosedTransaction.transactionId(), lastClosedTransaction.logPosition());
    }

    @Override
    public long forceCheckPoint(TriggerInfo info) throws IOException {
        try (Resource lock = this.mutex.checkPoint();){
            long l = this.doCheckPoint(info);
            return l;
        }
    }

    @Override
    public long tryCheckPoint(TriggerInfo info) throws IOException {
        return this.tryCheckPoint(info, () -> false);
    }

    @Override
    public long tryCheckPointNoWait(TriggerInfo info) throws IOException {
        return this.tryCheckPoint(info, () -> true);
    }

    @Override
    public long tryCheckPoint(TriggerInfo info, BooleanSupplier timeout) throws IOException {
        Resource lockAttempt = this.mutex.tryCheckPoint();
        if (lockAttempt != null) {
            try (Resource resource = lockAttempt;){
                long l = this.doCheckPoint(info);
                return l;
            }
        }
        try (Resource lock = this.mutex.tryCheckPoint(timeout);){
            if (lock != null) {
                this.log.info(info.describe(this.lastCheckPointedTx) + " Check pointing was already running, completed now");
                long l = this.lastCheckPointedTx;
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    @Override
    public long checkPointIfNeeded(TriggerInfo info) throws IOException {
        ClosedTransactionMetadata lastClosedTransaction = this.metadataProvider.getLastClosedTransaction();
        if (this.threshold.isCheckPointingNeeded(lastClosedTransaction.transactionId(), lastClosedTransaction.logPosition(), info)) {
            try (Resource lock = this.mutex.checkPoint();){
                long l = this.doCheckPoint(info);
                return l;
            }
        }
        return -1L;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private long doCheckPoint(TriggerInfo triggerInfo) throws IOException {
        DatabaseTracer databaseTracer = this.tracers.getDatabaseTracer();
        try (CursorContext cursorContext = this.cursorContextFactory.create(CHECKPOINT_TAG);){
            LogCheckPointEvent checkPointEvent = databaseTracer.beginCheckPoint();
            try {
                ClosedTransactionMetadata lastClosedTxData = this.metadataProvider.getLastClosedTransaction();
                TransactionId lastClosedTransaction = new TransactionId(lastClosedTxData.transactionId(), lastClosedTxData.checksum(), lastClosedTxData.commitTimestamp());
                long lastClosedTransactionId = lastClosedTransaction.transactionId();
                cursorContext.getVersionContext().initWrite(lastClosedTransactionId);
                LogPosition logPosition = lastClosedTxData.logPosition();
                String checkpointReason = triggerInfo.describe(lastClosedTransactionId);
                this.databaseHealth.assertHealthy(IOException.class);
                this.log.info(checkpointReason + " checkpoint started...");
                Stopwatch startTime = Stopwatch.start();
                try (DatabaseFlushEvent flushEvent = checkPointEvent.beginDatabaseFlush();){
                    this.forceOperation.flushAndForce(flushEvent, cursorContext);
                    flushEvent.ioControllerLimit(this.ioController.configuredLimit());
                }
                this.databaseHealth.assertHealthy(IOException.class);
                this.checkpointAppender.checkPoint(checkPointEvent, lastClosedTransaction, logPosition, this.clock.instant(), checkpointReason);
                this.threshold.checkPointHappened(lastClosedTransactionId, logPosition);
                long durationMillis = startTime.elapsed(TimeUnit.MILLISECONDS);
                checkPointEvent.checkpointCompleted(durationMillis);
                this.log.info(this.createCheckpointMessageDescription(checkPointEvent, checkpointReason, durationMillis));
                this.logPruning.pruneLogs(logPosition.getLogVersion());
                this.lastCheckPointedTx = lastClosedTransactionId;
                long l = lastClosedTransactionId;
                if (checkPointEvent != null) {
                    checkPointEvent.close();
                }
                return l;
            }
            catch (Throwable throwable) {
                if (checkPointEvent != null) {
                    try {
                        checkPointEvent.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            this.log.error("Checkpoint failed", t);
            throw t;
        }
    }

    private String createCheckpointMessageDescription(LogCheckPointEvent checkpointEvent, String checkpointReason, long durationMillis) {
        double flushRatio = checkpointEvent.flushRatio();
        long ioLimit = checkpointEvent.getConfiguredIOLimit();
        String ioDetails = IO_DETAILS_TEMPLATE.formatted(checkpointEvent.getPagesFlushed(), (int)(flushRatio * 100.0), checkpointEvent.getIOsPerformed(), this.ioLimitDescription(ioLimit), checkpointEvent.getTimesPaused(), checkpointEvent.getMillisPaused());
        return checkpointReason + " checkpoint completed in " + Format.duration((long)durationMillis) + ". " + ioDetails;
    }

    private String ioLimitDescription(long ioLimit) {
        return this.ioController.isEnabled() && ioLimit >= 0L ? String.valueOf(ioLimit) : UNLIMITED_IO_CONTROLLER_LIMIT;
    }

    @Override
    public long lastCheckPointedTransactionId() {
        return this.lastCheckPointedTx;
    }

    @FunctionalInterface
    public static interface ForceOperation {
        public void flushAndForce(DatabaseFlushEvent var1, CursorContext var2) throws IOException;
    }
}

