/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.time.Clock;
import java.util.function.Supplier;
import org.neo4j.collection.RawIterator;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserAggregationUpdater;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AdminAccessMode;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.procedure.BasicContext;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.OverridableSecurityContext;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextValueMapper;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

public abstract class ProcedureCaller {
    final GlobalProcedures globalProcedures;
    private final DependencyResolver databaseDependencies;

    private ProcedureCaller(GlobalProcedures globalProcedures, DependencyResolver databaseDependencies) {
        this.globalProcedures = globalProcedures;
        this.databaseDependencies = databaseDependencies;
    }

    public AnyValue callFunction(int id, AnyValue[] input) throws ProcedureException {
        this.performCheckBeforeOperation();
        AccessMode mode = this.securityContext().mode();
        if (!mode.allowsExecuteFunction(id).allowsAccess()) {
            String message = String.format("Executing a user defined function is not allowed for %s.", this.securityContext().description());
            throw this.securityAuthorizationHandler().logAndGetAuthorizationException(this.securityContext(), message);
        }
        SecurityContext securityContext = mode.shouldBoostFunction(id).allowsAccess() ? this.securityContext().withMode((AccessMode)new OverriddenAccessMode(mode, AccessMode.Static.READ)) : this.securityContext().withMode((AccessMode)new RestrictedAccessMode(mode, AccessMode.Static.READ));
        try (OverridableSecurityContext.Revertable ignore = this.overrideSecurityContext(securityContext);){
            AnyValue anyValue = this.globalProcedures.callFunction(this.prepareContext(securityContext, ProcedureCallContext.EMPTY), id, input);
            return anyValue;
        }
    }

    public AnyValue callBuiltInFunction(int id, AnyValue[] input) throws ProcedureException {
        this.performCheckBeforeOperation();
        return this.globalProcedures.callFunction(this.prepareContext(this.securityContext(), ProcedureCallContext.EMPTY), id, input);
    }

    AccessMode checkAggregationFunctionAccessMode(int functionId) {
        AccessMode mode = this.securityContext().mode();
        if (!mode.allowsExecuteAggregatingFunction(functionId).allowsAccess()) {
            String message = String.format("Executing a user defined aggregating function is not allowed for %s.", this.securityContext().description());
            throw this.securityAuthorizationHandler().logAndGetAuthorizationException(this.securityContext(), message);
        }
        return mode;
    }

    UserAggregationReducer createGenericAggregator(boolean overrideAccessMode, AccessMode mode, int functionId) throws ProcedureException {
        final SecurityContext securityContext = overrideAccessMode ? this.securityContext().withMode((AccessMode)new OverriddenAccessMode(mode, AccessMode.Static.READ)) : this.securityContext().withMode((AccessMode)new RestrictedAccessMode(mode, AccessMode.Static.READ));
        try (OverridableSecurityContext.Revertable ignore = this.overrideSecurityContext(securityContext);){
            final UserAggregationReducer aggregator = this.globalProcedures.createAggregationFunction(this.prepareContext(securityContext, ProcedureCallContext.EMPTY), functionId);
            UserAggregationReducer userAggregationReducer = new UserAggregationReducer(){

                public UserAggregationUpdater newUpdater() throws ProcedureException {
                    try (OverridableSecurityContext.Revertable ignore = ProcedureCaller.this.overrideSecurityContext(securityContext);){
                        final UserAggregationUpdater updater = aggregator.newUpdater();
                        UserAggregationUpdater userAggregationUpdater = new UserAggregationUpdater(){

                            public void update(AnyValue[] input) throws ProcedureException {
                                try (OverridableSecurityContext.Revertable ignore = ProcedureCaller.this.overrideSecurityContext(securityContext);){
                                    updater.update(input);
                                }
                            }

                            public void applyUpdates() throws ProcedureException {
                                try (OverridableSecurityContext.Revertable ignore = ProcedureCaller.this.overrideSecurityContext(securityContext);){
                                    updater.applyUpdates();
                                }
                            }
                        };
                        return userAggregationUpdater;
                    }
                }

                public AnyValue result() throws ProcedureException {
                    try (OverridableSecurityContext.Revertable ignore = ProcedureCaller.this.overrideSecurityContext(securityContext);){
                        AnyValue anyValue = aggregator.result();
                        return anyValue;
                    }
                }
            };
            return userAggregationReducer;
        }
    }

    public UserAggregationReducer createBuiltInAggregationFunction(int id) throws ProcedureException {
        this.performCheckBeforeOperation();
        return this.globalProcedures.createAggregationFunction(this.prepareContext(this.securityContext(), ProcedureCallContext.EMPTY), id);
    }

    Context prepareContext(SecurityContext securityContext, ProcedureCallContext procedureContext) {
        return BasicContext.buildContext(this.databaseDependencies, this.createValueMapper()).withTransaction(this.maybeInternalTransaction()).withSecurityContext(securityContext).withProcedureCallContext(procedureContext).withClock(this.clockContext()).context();
    }

    abstract SecurityContext securityContext();

    abstract OverridableSecurityContext.Revertable overrideSecurityContext(SecurityContext var1);

    abstract InternalTransaction maybeInternalTransaction();

    abstract void performCheckBeforeOperation();

    abstract SecurityAuthorizationHandler securityAuthorizationHandler();

    abstract ClockContext clockContext();

    abstract ValueMapper<Object> createValueMapper();

    public abstract UserAggregationReducer createAggregationFunction(int var1) throws ProcedureException;

    public abstract RawIterator<AnyValue[], ProcedureException> callProcedure(int var1, AnyValue[] var2, AccessMode.Static var3, ProcedureCallContext var4) throws ProcedureException;

    public static class ForThreadExecutionContextScope
    extends ProcedureCaller {
        private final ExecutionContext executionContext;
        private final OverridableSecurityContext overridableSecurityContext;
        private final AssertOpen assertOpen;
        private final SecurityAuthorizationHandler securityAuthorizationHandler;
        private final Supplier<ClockContext> clockContextSupplier;

        ForThreadExecutionContextScope(ExecutionContext executionContext, GlobalProcedures globalProcedures, DependencyResolver databaseDependencies, OverridableSecurityContext overridableSecurityContext, AssertOpen assertOpen, SecurityAuthorizationHandler securityAuthorizationHandler, Supplier<ClockContext> clockContextSupplier) {
            super(globalProcedures, databaseDependencies);
            this.executionContext = executionContext;
            this.overridableSecurityContext = overridableSecurityContext;
            this.assertOpen = assertOpen;
            this.securityAuthorizationHandler = securityAuthorizationHandler;
            this.clockContextSupplier = clockContextSupplier;
        }

        @Override
        public UserAggregationReducer createAggregationFunction(int id) throws ProcedureException {
            boolean overrideAccessMode;
            this.performCheckBeforeOperation();
            AccessMode mode = this.checkAggregationFunctionAccessMode(id);
            boolean bl = overrideAccessMode = mode != AccessMode.Static.FULL && mode.shouldBoostAggregatingFunction(id).allowsAccess();
            if (overrideAccessMode) {
                return this.createGenericAggregator(true, mode, id);
            }
            return this.globalProcedures.createAggregationFunction(this.prepareContext(this.securityContext(), ProcedureCallContext.EMPTY), id);
        }

        @Override
        SecurityContext securityContext() {
            return this.overridableSecurityContext.currentSecurityContext();
        }

        @Override
        OverridableSecurityContext.Revertable overrideSecurityContext(SecurityContext context) {
            return this.overridableSecurityContext.overrideWith(context);
        }

        @Override
        InternalTransaction maybeInternalTransaction() {
            return null;
        }

        @Override
        void performCheckBeforeOperation() {
            this.assertOpen.assertOpen();
        }

        @Override
        SecurityAuthorizationHandler securityAuthorizationHandler() {
            return this.securityAuthorizationHandler;
        }

        @Override
        ClockContext clockContext() {
            return this.clockContextSupplier.get();
        }

        @Override
        ValueMapper<Object> createValueMapper() {
            return new ExecutionContextValueMapper(this.executionContext);
        }

        @Override
        public RawIterator<AnyValue[], ProcedureException> callProcedure(int id, AnyValue[] input, AccessMode.Static procedureMode, ProcedureCallContext procedureCallContext) throws ProcedureException {
            throw new UnsupportedOperationException("Invoking a procedure is not allowed during parallel execution");
        }
    }

    public static class ForTransactionScope
    extends ProcedureCaller {
        private final KernelTransaction ktx;

        public ForTransactionScope(KernelTransaction ktx, GlobalProcedures globalProcedures, DependencyResolver databaseDependencies) {
            super(globalProcedures, databaseDependencies);
            this.ktx = ktx;
        }

        @Override
        void performCheckBeforeOperation() {
            this.ktx.assertOpen();
        }

        @Override
        SecurityAuthorizationHandler securityAuthorizationHandler() {
            return this.ktx.securityAuthorizationHandler();
        }

        @Override
        ClockContext clockContext() {
            return new ClockContext(){

                public Clock systemClock() {
                    return ktx.clocks().systemClock();
                }

                public Clock transactionClock() {
                    return ktx.clocks().transactionClock();
                }

                public Clock statementClock() {
                    return ktx.clocks().statementClock();
                }
            };
        }

        @Override
        ValueMapper<Object> createValueMapper() {
            return new DefaultValueMapper(this.ktx.internalTransaction());
        }

        @Override
        public UserAggregationReducer createAggregationFunction(int id) throws ProcedureException {
            this.performCheckBeforeOperation();
            AccessMode mode = this.checkAggregationFunctionAccessMode(id);
            boolean overrideAccessMode = mode.shouldBoostAggregatingFunction(id).allowsAccess();
            return this.createGenericAggregator(overrideAccessMode, mode, id);
        }

        @Override
        SecurityContext securityContext() {
            return this.ktx.securityContext();
        }

        @Override
        OverridableSecurityContext.Revertable overrideSecurityContext(SecurityContext context) {
            KernelTransaction.Revertable revertable = this.ktx.overrideWith(context);
            return () -> ((KernelTransaction.Revertable)revertable).close();
        }

        @Override
        InternalTransaction maybeInternalTransaction() {
            return this.ktx.internalTransaction();
        }

        @Override
        public RawIterator<AnyValue[], ProcedureException> callProcedure(int id, AnyValue[] input, AccessMode.Static procedureMode, ProcedureCallContext procedureCallContext) throws ProcedureException {
            RawIterator<AnyValue[], ProcedureException> procedureCall;
            this.ktx.assertOpen();
            AccessMode mode = this.ktx.securityContext().mode();
            if (!mode.allowsExecuteProcedure(id).allowsAccess()) {
                String message = String.format("Executing procedure is not allowed for %s.", this.ktx.securityContext().description());
                throw this.ktx.securityAuthorizationHandler().logAndGetAuthorizationException(this.ktx.securityContext(), message);
            }
            SecurityContext procedureSecurityContext = mode.shouldBoostProcedure(id).allowsAccess() ? this.ktx.securityContext().withMode((AccessMode)new OverriddenAccessMode(mode, procedureMode)).withMode(AdminAccessMode.FULL) : this.ktx.securityContext().withMode((AccessMode)new RestrictedAccessMode(mode, procedureMode));
            try (KernelTransaction.Revertable ignore = this.ktx.overrideWith(procedureSecurityContext);
                 Statement statement = this.ktx.acquireStatement();){
                procedureCall = this.globalProcedures.callProcedure(this.prepareContext(procedureSecurityContext, procedureCallContext), id, input, (ResourceMonitor)statement);
            }
            return this.createIterator(procedureSecurityContext, procedureCall);
        }

        private RawIterator<AnyValue[], ProcedureException> createIterator(final SecurityContext procedureSecurityContext, final RawIterator<AnyValue[], ProcedureException> procedureCall) {
            return new RawIterator<AnyValue[], ProcedureException>(){

                public boolean hasNext() throws ProcedureException {
                    try (KernelTransaction.Revertable ignore = ktx.overrideWith(procedureSecurityContext);){
                        boolean bl = procedureCall.hasNext();
                        return bl;
                    }
                }

                public AnyValue[] next() throws ProcedureException {
                    try (KernelTransaction.Revertable ignore = ktx.overrideWith(procedureSecurityContext);){
                        AnyValue[] anyValueArray = (AnyValue[])procedureCall.next();
                        return anyValueArray;
                    }
                }
            };
        }
    }
}

