/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingIntFunction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaNameUtil;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintWithNameAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.EquivalentSchemaRuleAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexWithNameAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchConstraintException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedSchemaComponentException;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.locking.ResourceIds;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.FilteringNodeCursorWrapper;
import org.neo4j.kernel.impl.newapi.FilteringRelationshipScanCursorWrapper;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipValueIndexCursor;
import org.neo4j.kernel.impl.newapi.IndexReaders;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.SchemaMatcher;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Operations
implements Write,
SchemaWrite {
    private final KernelTransactionImplementation ktx;
    private final AllStoreHolder allStoreHolder;
    private final StorageReader storageReader;
    private final CommandCreationContext commandCreationContext;
    private final StorageLocks storageLocks;
    private final KernelToken token;
    private final IndexTxStateUpdater updater;
    private final DefaultPooledCursors cursors;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final ConstraintSemantics constraintSemantics;
    private final IndexingProvidersService indexProviders;
    private final MemoryTracker memoryTracker;
    private final boolean additionLockVerification;
    private final boolean relationshipUniquenessConstraintEnabled;
    private DefaultNodeCursor nodeCursor;
    private DefaultNodeCursor restrictedNodeCursor;
    private DefaultPropertyCursor propertyCursor;
    private DefaultPropertyCursor restrictedPropertyCursor;
    private DefaultRelationshipScanCursor relationshipCursor;

    public Operations(AllStoreHolder allStoreHolder, StorageReader storageReader, IndexTxStateUpdater updater, CommandCreationContext commandCreationContext, StorageLocks storageLocks, KernelTransactionImplementation ktx, KernelToken token, DefaultPooledCursors cursors, ConstraintIndexCreator constraintIndexCreator, ConstraintSemantics constraintSemantics, IndexingProvidersService indexProviders, Config config, MemoryTracker memoryTracker) {
        this.storageReader = storageReader;
        this.commandCreationContext = commandCreationContext;
        this.storageLocks = storageLocks;
        this.token = token;
        this.allStoreHolder = allStoreHolder;
        this.ktx = ktx;
        this.updater = updater;
        this.cursors = cursors;
        this.constraintIndexCreator = constraintIndexCreator;
        this.constraintSemantics = constraintSemantics;
        this.indexProviders = indexProviders;
        this.memoryTracker = memoryTracker;
        this.additionLockVerification = (Boolean)config.get(GraphDatabaseInternalSettings.additional_lock_verification);
        this.relationshipUniquenessConstraintEnabled = (Boolean)config.get(GraphDatabaseInternalSettings.rel_unique_constraints);
    }

    public void initialize(CursorContext cursorContext) {
        this.nodeCursor = this.cursors.allocateFullAccessNodeCursor(cursorContext);
        this.propertyCursor = this.cursors.allocateFullAccessPropertyCursor(cursorContext, this.memoryTracker);
        this.relationshipCursor = this.cursors.allocateRelationshipScanCursor(cursorContext);
        this.restrictedNodeCursor = this.cursors.allocateNodeCursor(cursorContext);
        this.restrictedPropertyCursor = this.cursors.allocatePropertyCursor(cursorContext, this.memoryTracker);
    }

    public long nodeCreate() {
        this.ktx.securityAuthorizationHandler().assertAllowsCreateNode(this.ktx.securityContext(), this.token::labelGetName, null);
        this.ktx.assertOpen();
        TransactionState txState = this.ktx.txState();
        long nodeId = this.commandCreationContext.reserveNode();
        this.storageLocks.acquireExclusiveNodeLock(this.ktx.lockTracer(), new long[]{nodeId});
        txState.nodeDoCreate(nodeId);
        return nodeId;
    }

    public long nodeCreateWithLabels(int[] labels) throws ConstraintValidationException {
        if (labels == null || labels.length == 0) {
            return this.nodeCreate();
        }
        this.ktx.securityAuthorizationHandler().assertAllowsCreateNode(this.ktx.securityContext(), this.token::labelGetName, labels);
        this.ktx.assertOpen();
        int labelCount = labels.length;
        long[] lockingIds = new long[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            lockingIds[i] = labels[i];
        }
        Arrays.sort(lockingIds);
        this.ktx.lockClient().acquireShared(this.ktx.lockTracer(), (ResourceType)ResourceTypes.LABEL, lockingIds);
        this.sharedTokenSchemaLock(ResourceTypes.LABEL);
        TransactionState txState = this.ktx.txState();
        long nodeId = this.commandCreationContext.reserveNode();
        this.storageLocks.acquireExclusiveNodeLock(this.ktx.lockTracer(), new long[]{nodeId});
        txState.nodeDoCreate(nodeId);
        this.nodeCursor.single(nodeId, this.allStoreHolder);
        this.nodeCursor.next();
        int prevLabel = -1;
        for (long lockingId : lockingIds) {
            int label = (int)lockingId;
            if (label == prevLabel) continue;
            this.checkConstraintsAndAddLabelToNode(nodeId, label);
            prevLabel = label;
        }
        return nodeId;
    }

    public boolean nodeDelete(long node) {
        this.ktx.assertOpen();
        return this.nodeDelete(node, true);
    }

    public int nodeDetachDelete(long nodeId) {
        this.ktx.assertOpen();
        this.storageLocks.acquireNodeDeletionLock((ReadableTransactionState)this.ktx.txState(), this.ktx.lockTracer(), nodeId);
        NodeCursor nodeCursor = this.ktx.ambientNodeCursor();
        this.ktx.dataRead().singleNode(nodeId, nodeCursor);
        int deletedRelationships = 0;
        if (nodeCursor.next()) {
            try (RelationshipTraversalCursor rels = RelationshipSelections.allCursor((CursorFactory)this.ktx.cursors(), (NodeCursor)nodeCursor, null, (CursorContext)this.ktx.cursorContext());){
                while (rels.next()) {
                    boolean deleted = this.relationshipDelete(rels.relationshipReference());
                    if (this.additionLockVerification && !deleted) {
                        throw new RuntimeException("Relationship chain modified even when node delete lock was held: " + rels);
                    }
                    ++deletedRelationships;
                }
            }
        }
        this.nodeDelete(nodeId, false);
        return deletedRelationships;
    }

    public long relationshipCreate(long sourceNode, int relationshipType, long targetNode) throws EntityNotFoundException {
        this.ktx.securityAuthorizationHandler().assertAllowsCreateRelationship(this.ktx.securityContext(), this.token::relationshipTypeGetName, relationshipType);
        this.ktx.assertOpen();
        this.sharedSchemaLock((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, relationshipType);
        this.sharedTokenSchemaLock(ResourceTypes.RELATIONSHIP_TYPE);
        TransactionState txState = this.ktx.txState();
        boolean sourceNodeAddedInTx = txState.nodeIsAddedInThisTx(sourceNode);
        boolean targetNodeAddedInTx = sourceNode == targetNode ? sourceNodeAddedInTx : txState.nodeIsAddedInThisTx(targetNode);
        this.storageLocks.acquireRelationshipCreationLock(this.ktx.lockTracer(), sourceNode, targetNode, sourceNodeAddedInTx, targetNodeAddedInTx);
        if (!sourceNodeAddedInTx) {
            this.assertNodeExists(sourceNode);
        }
        if (targetNode != sourceNode && !targetNodeAddedInTx) {
            this.assertNodeExists(targetNode);
        }
        long id = this.commandCreationContext.reserveRelationship(sourceNode, targetNode, relationshipType, sourceNodeAddedInTx, targetNodeAddedInTx);
        this.storageLocks.acquireExclusiveRelationshipLock(this.ktx.lockTracer(), new long[]{id});
        txState.relationshipDoCreate(id, relationshipType, sourceNode, targetNode);
        return id;
    }

    public boolean relationshipDelete(long relationship) {
        this.ktx.assertOpen();
        TransactionState txState = this.ktx.txState();
        boolean relationshipIsAddedInThisTx = txState.relationshipIsAddedInThisTx(relationship);
        if (relationshipIsAddedInThisTx) {
            try {
                this.singleRelationship(relationship);
            }
            catch (EntityNotFoundException e) {
                throw new IllegalStateException("Relationship " + relationship + " was created in this transaction, but was not found when deleting it");
            }
            this.updater.onDeleteUncreated(this.relationshipCursor, (PropertyCursor)this.propertyCursor);
            txState.relationshipDoDeleteAddedInThisTx(relationship);
            return true;
        }
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            return false;
        }
        this.sharedSchemaLock((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, this.relationshipCursor.type());
        this.sharedTokenSchemaLock(ResourceTypes.RELATIONSHIP_TYPE);
        long sourceNode = this.relationshipCursor.sourceNodeReference();
        long targetNode = this.relationshipCursor.targetNodeReference();
        boolean sourceNodeAddedInTx = txState.nodeIsAddedInThisTx(sourceNode);
        boolean targetNodeAddedInTx = txState.nodeIsAddedInThisTx(targetNode);
        this.storageLocks.acquireRelationshipDeletionLock(this.ktx.lockTracer(), sourceNode, targetNode, relationship, relationshipIsAddedInThisTx, sourceNodeAddedInTx, targetNodeAddedInTx);
        if (!this.allStoreHolder.relationshipExists(relationship)) {
            return false;
        }
        this.ktx.securityAuthorizationHandler().assertAllowsDeleteRelationship(this.ktx.securityContext(), this.token::relationshipTypeGetName, this.relationshipCursor.type());
        txState.relationshipDoDelete(relationship, this.relationshipCursor.type(), sourceNode, targetNode);
        return true;
    }

    public boolean nodeAddLabel(long node, int nodeLabel) throws EntityNotFoundException, ConstraintValidationException {
        this.sharedSchemaLock((ResourceType)ResourceTypes.LABEL, nodeLabel);
        this.sharedTokenSchemaLock(ResourceTypes.LABEL);
        this.acquireExclusiveNodeLock(node);
        this.storageLocks.acquireNodeLabelChangeLock(this.ktx.lockTracer(), node, nodeLabel);
        this.singleNode(node);
        if (this.nodeCursor.hasLabel(nodeLabel)) {
            return false;
        }
        LongSet removed = this.ktx.txState().nodeStateLabelDiffSets(node).getRemoved();
        if (!removed.contains((long)nodeLabel)) {
            this.ktx.securityAuthorizationHandler().assertAllowsSetLabel(this.ktx.securityContext(), this.token::labelGetName, (long)nodeLabel);
        }
        this.checkConstraintsAndAddLabelToNode(node, nodeLabel);
        return true;
    }

    private void checkConstraintsAndAddLabelToNode(long node, int nodeLabel) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        Collection<IndexDescriptor> indexes = this.checkConstraintsAndGetIndexes(node, nodeLabel);
        this.ktx.txState().nodeDoAddLabel(nodeLabel, node);
        this.updater.onLabelChange(this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL, indexes);
    }

    private Collection<IndexDescriptor> checkConstraintsAndGetIndexes(long node, int nodeLabel) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        int[] existingPropertyKeyIds;
        if (this.storageReader.hasRelatedSchema(nodeLabel, EntityType.NODE) && (existingPropertyKeyIds = this.loadSortedNodePropertyKeyList()).length > 0) {
            Collection indexes = this.storageReader.valueIndexesGetRelated(new long[]{nodeLabel}, existingPropertyKeyIds, EntityType.NODE);
            for (IndexDescriptor index : indexes) {
                PropertyIndexQuery.ExactPredicate[] propertyValues;
                if (!index.isUnique() || (propertyValues = this.getAllPropertyValues((EntityCursor)this.nodeCursor, index.schema(), -1, Values.NO_VALUE)) == null) continue;
                this.validateNoExistingNodeWithExactValues((IndexBackedConstraintDescriptor)((UniquenessConstraintDescriptor)this.storageReader.constraintGetForName(index.getName())), index, propertyValues, node);
            }
            return indexes;
        }
        return Collections.emptyList();
    }

    private int[] loadSortedNodePropertyKeyList() {
        this.nodeCursor.properties(this.propertyCursor, PropertySelection.ALL_PROPERTY_KEYS);
        return this.doLoadSortedPropertyKeyList();
    }

    private int[] loadSortedRelationshipPropertyKeyList() {
        this.relationshipCursor.properties(this.propertyCursor, PropertySelection.ALL_PROPERTY_KEYS);
        return this.doLoadSortedPropertyKeyList();
    }

    private int[] doLoadSortedPropertyKeyList() {
        if (!this.propertyCursor.next()) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        int[] propertyKeyIds = new int[4];
        int cursor = 0;
        boolean isSorted = true;
        do {
            int key;
            if (cursor == propertyKeyIds.length) {
                propertyKeyIds = Arrays.copyOf(propertyKeyIds, cursor * 2);
            }
            propertyKeyIds[cursor] = key = this.propertyCursor.propertyKey();
            if (cursor > 0 && key < propertyKeyIds[cursor - 1]) {
                isSorted = false;
            }
            ++cursor;
        } while (this.propertyCursor.next());
        if (cursor != propertyKeyIds.length) {
            propertyKeyIds = Arrays.copyOf(propertyKeyIds, cursor);
        }
        if (!isSorted) {
            Arrays.sort(propertyKeyIds);
        }
        return propertyKeyIds;
    }

    private boolean nodeDelete(long node, boolean lock) {
        this.ktx.assertOpen();
        if (this.ktx.hasTxStateWithChanges()) {
            TransactionState state = this.ktx.txState();
            if (state.nodeIsAddedInThisTx(node)) {
                try {
                    this.singleNode(node);
                }
                catch (EntityNotFoundException e) {
                    throw new IllegalStateException("Node " + node + " was created in this transaction, but was not found when it was about to be deleted");
                }
                this.updater.onDeleteUncreated(this.nodeCursor, (PropertyCursor)this.propertyCursor);
                state.nodeDoDelete(node);
                return true;
            }
            if (state.nodeIsDeletedInThisTx(node)) {
                return false;
            }
        }
        if (lock) {
            this.storageLocks.acquireNodeDeletionLock((ReadableTransactionState)this.ktx.txState(), this.ktx.lockTracer(), node);
        }
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (this.nodeCursor.next()) {
            this.acquireSharedNodeLabelLocks();
            this.sharedTokenSchemaLock(ResourceTypes.LABEL);
            this.ktx.securityAuthorizationHandler().assertAllowsDeleteNode(this.ktx.securityContext(), this.token::labelGetName, this.nodeCursor::labels);
            this.ktx.txState().nodeDoDelete(node);
            return true;
        }
        return false;
    }

    private long[] acquireSharedNodeLabelLocks() {
        long[] labels = this.nodeCursor.labels().all();
        this.ktx.lockClient().acquireShared(this.ktx.lockTracer(), (ResourceType)ResourceTypes.LABEL, labels);
        return labels;
    }

    private int acquireSharedRelationshipTypeLock() {
        int relType = this.relationshipCursor.type();
        this.ktx.lockClient().acquireShared(this.ktx.lockTracer(), (ResourceType)ResourceTypes.RELATIONSHIP_TYPE, new long[]{relType});
        return relType;
    }

    private void singleNode(long node) throws EntityNotFoundException {
        this.allStoreHolder.singleNode(node, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, this.ktx.internalTransaction().elementIdMapper().nodeElementId(node));
        }
    }

    private void singleRelationship(long relationship) throws EntityNotFoundException {
        this.allStoreHolder.singleRelationship(relationship, this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, this.ktx.internalTransaction().elementIdMapper().relationshipElementId(relationship));
        }
    }

    private PropertyIndexQuery.ExactPredicate[] getAllPropertyValues(EntityCursor cursor, SchemaDescriptor schema, int changedPropertyKeyId, Value changedValue) {
        int k;
        int[] schemaPropertyIds = schema.getPropertyIds();
        PropertyIndexQuery.ExactPredicate[] values = new PropertyIndexQuery.ExactPredicate[schemaPropertyIds.length];
        int nMatched = 0;
        cursor.properties((PropertyCursor)this.propertyCursor, PropertySelection.selection((int[])schemaPropertyIds));
        while (this.propertyCursor.next()) {
            int entityPropertyId = this.propertyCursor.propertyKey();
            int k2 = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)entityPropertyId);
            if (k2 < 0) continue;
            if (entityPropertyId != -1) {
                values[k2] = PropertyIndexQuery.exact((int)entityPropertyId, (Object)this.propertyCursor.propertyValue());
            }
            ++nMatched;
        }
        if (changedPropertyKeyId != -1 && (k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)changedPropertyKeyId)) >= 0) {
            values[k] = PropertyIndexQuery.exact((int)changedPropertyKeyId, (Object)changedValue);
            ++nMatched;
        }
        if (nMatched < values.length) {
            return null;
        }
        return values;
    }

    private PropertyIndexQuery.ExactPredicate[] getAllPropertyValues(EntityCursor cursor, SchemaDescriptor schema, IntObjectMap<Value> changedProperties) {
        int[] schemaPropertyIds = schema.getPropertyIds();
        PropertyIndexQuery.ExactPredicate[] values = new PropertyIndexQuery.ExactPredicate[schemaPropertyIds.length];
        int nMatched = 0;
        cursor.properties((PropertyCursor)this.propertyCursor, PropertySelection.selection((int[])schemaPropertyIds));
        while (this.propertyCursor.next()) {
            int entityPropertyId = this.propertyCursor.propertyKey();
            int k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)entityPropertyId);
            if (k < 0) continue;
            if (entityPropertyId != -1) {
                values[k] = PropertyIndexQuery.exact((int)entityPropertyId, (Object)this.propertyCursor.propertyValue());
            }
            ++nMatched;
        }
        for (IntObjectPair changedProperty : changedProperties.keyValuesView()) {
            int k;
            int changedPropertyKeyId = changedProperty.getOne();
            if (changedPropertyKeyId == -1 || (k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)changedPropertyKeyId)) < 0) continue;
            values[k] = PropertyIndexQuery.exact((int)changedPropertyKeyId, (Object)changedProperty.getTwo());
            ++nMatched;
        }
        if (nMatched < values.length) {
            return null;
        }
        return values;
    }

    private void validateNoExistingNodeWithExactValues(IndexBackedConstraintDescriptor constraint, IndexDescriptor index, PropertyIndexQuery.ExactPredicate[] propertyValues, long modifiedNode) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        try (FullAccessNodeValueIndexCursor valueCursor = this.cursors.allocateFullAccessNodeValueIndexCursor(this.ktx.cursorContext(), this.memoryTracker);
             IndexReaders indexReaders = new IndexReaders(index, this.allStoreHolder);){
            this.assertOnlineAndLock(constraint, index, propertyValues);
            this.allStoreHolder.nodeIndexSeekWithFreshIndexReader(valueCursor, indexReaders.createReader(), propertyValues);
            while (valueCursor.next()) {
                if (valueCursor.nodeReference() == modifiedNode) continue;
                throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VALIDATION, new IndexEntryConflictException(EntityType.NODE, valueCursor.nodeReference(), -1L, PropertyIndexQuery.asValueTuple((PropertyIndexQuery.ExactPredicate[])propertyValues)), (TokenNameLookup)this.token);
            }
        }
        catch (IndexNotApplicableKernelException | IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintException((ConstraintDescriptor)constraint, (Throwable)e, (TokenNameLookup)this.token);
        }
    }

    private void assertOnlineAndLock(IndexBackedConstraintDescriptor constraint, IndexDescriptor index, PropertyIndexQuery.ExactPredicate[] propertyValues) throws IndexNotFoundKernelException, IndexBrokenKernelException, UnableToValidateConstraintException {
        this.assertIndexOnline(index);
        SchemaDescriptor schema = index.schema();
        long[] entityTokenIds = schema.lockingKeys();
        if (entityTokenIds.length != 1) {
            throw new UnableToValidateConstraintException((ConstraintDescriptor)constraint, (Throwable)((Object)new AssertionError((Object)String.format("Constraint indexes are not expected to be multi-token indexes, but the constraint %s was referencing an index with the following schema: %s.", constraint.userDescription((TokenNameLookup)this.token), schema.userDescription((TokenNameLookup)this.token)))), (TokenNameLookup)this.token);
        }
        this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), (ResourceType)ResourceTypes.INDEX_ENTRY, new long[]{ResourceIds.indexEntryResourceId(entityTokenIds[0], propertyValues)});
    }

    private void validateNoExistingRelWithExactValues(IndexBackedConstraintDescriptor constraint, IndexDescriptor index, PropertyIndexQuery.ExactPredicate[] propertyValues, long modifiedRel) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        try (FullAccessRelationshipValueIndexCursor valueCursor = this.cursors.allocateFullAccessRelationshipValueIndexCursor(this.ktx.cursorContext(), this.memoryTracker);
             IndexReaders indexReaders = new IndexReaders(index, this.allStoreHolder);){
            this.assertOnlineAndLock(constraint, index, propertyValues);
            this.allStoreHolder.relationshipIndexSeekWithFreshIndexReader(valueCursor, indexReaders.createReader(), propertyValues);
            while (valueCursor.next()) {
                if (valueCursor.relationshipReference() == modifiedRel) continue;
                throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VALIDATION, new IndexEntryConflictException(EntityType.RELATIONSHIP, valueCursor.relationshipReference(), -1L, PropertyIndexQuery.asValueTuple((PropertyIndexQuery.ExactPredicate[])propertyValues)), (TokenNameLookup)this.token);
            }
        }
        catch (IndexNotApplicableKernelException | IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintException((ConstraintDescriptor)constraint, (Throwable)e, (TokenNameLookup)this.token);
        }
    }

    private void assertIndexOnline(IndexDescriptor descriptor) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        if (this.allStoreHolder.indexGetState(descriptor) != InternalIndexState.ONLINE) {
            throw new IndexBrokenKernelException(this.allStoreHolder.indexGetFailure(descriptor));
        }
    }

    public boolean nodeRemoveLabel(long node, int labelId) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(node);
        this.storageLocks.acquireNodeLabelChangeLock(this.ktx.lockTracer(), node, labelId);
        this.ktx.assertOpen();
        this.singleNode(node);
        if (!this.nodeCursor.hasLabel(labelId)) {
            return false;
        }
        LongSet added = this.ktx.txState().nodeStateLabelDiffSets(node).getAdded();
        if (!added.contains((long)labelId)) {
            this.ktx.securityAuthorizationHandler().assertAllowsRemoveLabel(this.ktx.securityContext(), this.token::labelGetName, (long)labelId);
        }
        this.sharedSchemaLock((ResourceType)ResourceTypes.LABEL, labelId);
        this.sharedTokenSchemaLock(ResourceTypes.LABEL);
        this.ktx.txState().nodeDoRemoveLabel(labelId, node);
        if (this.storageReader.hasRelatedSchema(labelId, EntityType.NODE)) {
            int[] existingPropertyKeyIds = this.loadSortedNodePropertyKeyList();
            this.updater.onLabelChange(this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL, this.storageReader.valueIndexesGetRelated(new long[]{labelId}, existingPropertyKeyIds, EntityType.NODE));
        }
        return true;
    }

    public Value nodeSetProperty(long node, int propertyKey, Value value) throws EntityNotFoundException, ConstraintValidationException {
        assert (value != Values.NO_VALUE);
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        long[] labels = this.acquireSharedNodeLabelLocks();
        Value existingValue = this.readNodeProperty(propertyKey);
        int[] existingPropertyKeyIds = null;
        boolean hasRelatedSchema = this.storageReader.hasRelatedSchema(labels, propertyKey, EntityType.NODE);
        if (hasRelatedSchema) {
            existingPropertyKeyIds = this.loadSortedNodePropertyKeyList();
        }
        if (existingValue == Values.NO_VALUE) {
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)Labels.from(labels), (long)propertyKey);
            if (hasRelatedSchema) {
                this.checkUniquenessConstraints(node, propertyKey, value, labels, existingPropertyKeyIds);
            }
            this.ktx.txState().nodeDoAddProperty(node, propertyKey, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyAdd(this.nodeCursor, (PropertyCursor)this.propertyCursor, labels, propertyKey, existingPropertyKeyIds, value);
            }
        } else if (Operations.propertyHasChanged(value, existingValue)) {
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)Labels.from(labels), (long)propertyKey);
            if (hasRelatedSchema) {
                this.checkUniquenessConstraints(node, propertyKey, value, labels, existingPropertyKeyIds);
            }
            this.ktx.txState().nodeDoChangeProperty(node, propertyKey, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyChange(this.nodeCursor, (PropertyCursor)this.propertyCursor, labels, propertyKey, existingPropertyKeyIds, existingValue, value);
            }
        }
        return existingValue;
    }

    public void nodeApplyChanges(long node, IntSet addedLabels, IntSet removedLabels, IntObjectMap<Value> properties) throws EntityNotFoundException, ConstraintValidationException {
        Value existingValue;
        assert (PrimitiveArrays.intersect((long[])PrimitiveArrays.intsToLongs((int[])addedLabels.toSortedArray()), (long[])PrimitiveArrays.intsToLongs((int[])removedLabels.toSortedArray())).length == 0);
        this.ktx.assertOpen();
        if (!addedLabels.isEmpty() || !removedLabels.isEmpty()) {
            addedLabels.forEach((IntProcedure & Serializable)addedLabelId -> {
                this.sharedSchemaLock((ResourceType)ResourceTypes.LABEL, addedLabelId);
                this.storageLocks.acquireNodeLabelChangeLock(this.ktx.lockTracer(), node, addedLabelId);
            });
            removedLabels.forEach((IntProcedure & Serializable)removedLabelId -> {
                this.sharedSchemaLock((ResourceType)ResourceTypes.LABEL, removedLabelId);
                this.storageLocks.acquireNodeLabelChangeLock(this.ktx.lockTracer(), node, removedLabelId);
            });
            this.sharedTokenSchemaLock(ResourceTypes.LABEL);
        }
        this.acquireExclusiveNodeLock(node);
        this.singleNode(node);
        long[] existingLabels = this.acquireSharedNodeLabelLocks();
        MutableIntObjectMap existingValuesForChangedProperties = null;
        if (!properties.isEmpty()) {
            existingValuesForChangedProperties = IntObjectMaps.mutable.empty();
            this.nodeCursor.properties(this.propertyCursor, PropertySelection.selection((int[])properties.keySet().toArray()));
            while (this.propertyCursor.next()) {
                existingValuesForChangedProperties.put(this.propertyCursor.propertyKey(), (Object)this.propertyCursor.propertyValue());
            }
        }
        long[] labelsAfter = Operations.combineLabelIds(existingLabels, addedLabels, removedLabels);
        int[] existingPropertyKeyIds = this.loadSortedNodePropertyKeyList();
        MutableIntSet afterPropertyKeyIdsSet = IntSets.mutable.of(existingPropertyKeyIds);
        RichIterable propertiesKeyValueView = properties.keyValuesView();
        MutableIntSet removedPropertyKeyIdsSet = null;
        MutableIntSet changedPropertyKeyIdsSet = null;
        for (IntObjectPair property : propertiesKeyValueView) {
            int key = property.getOne();
            Value value = (Value)property.getTwo();
            if (value == Values.NO_VALUE) {
                if (removedPropertyKeyIdsSet == null) {
                    removedPropertyKeyIdsSet = IntSets.mutable.empty();
                }
                removedPropertyKeyIdsSet.add(key);
                afterPropertyKeyIdsSet.remove(key);
                continue;
            }
            afterPropertyKeyIdsSet.add(key);
            Value existingValue2 = (Value)existingValuesForChangedProperties.get(key);
            if (existingValue2 != null && !Operations.propertyHasChanged(value, existingValue2)) continue;
            if (changedPropertyKeyIdsSet == null) {
                changedPropertyKeyIdsSet = IntSets.mutable.empty();
            }
            changedPropertyKeyIdsSet.add(key);
        }
        int[] afterPropertyKeyIds = afterPropertyKeyIdsSet.toSortedArray();
        int[] changedPropertyKeyIds = changedPropertyKeyIdsSet != null ? changedPropertyKeyIdsSet.toSortedArray() : ArrayUtils.EMPTY_INT_ARRAY;
        int[] uniquenessPropertiesCheck = addedLabels.isEmpty() ? changedPropertyKeyIds : afterPropertyKeyIds;
        Collection uniquenessConstraints = this.storageReader.uniquenessConstraintsGetRelated(Operations.combineLabelIds(ArrayUtils.EMPTY_LONG_ARRAY, addedLabels, (IntSet)IntSets.immutable.empty()), labelsAfter, uniquenessPropertiesCheck, false, EntityType.NODE);
        SchemaMatcher.onMatchingSchema(uniquenessConstraints.iterator(), -1, afterPropertyKeyIds, constraint -> this.validateNoExistingNodeWithExactValues((IndexBackedConstraintDescriptor)constraint, this.storageReader.indexGetForName(constraint.getName()), this.getAllPropertyValues((EntityCursor)this.nodeCursor, constraint.schema(), properties), node));
        if (!removedLabels.isEmpty()) {
            LongSet added = this.ktx.txState().nodeStateLabelDiffSets(node).getAdded();
            IntIterator removedLabelsIterator = removedLabels.intIterator();
            while (removedLabelsIterator.hasNext()) {
                int removedLabelId2 = removedLabelsIterator.next();
                if (!added.contains((long)removedLabelId2)) {
                    this.ktx.securityAuthorizationHandler().assertAllowsRemoveLabel(this.ktx.securityContext(), this.token::labelGetName, (long)removedLabelId2);
                }
                if (!ArrayUtils.contains((long[])existingLabels, (long)removedLabelId2)) continue;
                this.ktx.txState().nodeDoRemoveLabel(removedLabelId2, node);
                if (!this.storageReader.hasRelatedSchema(removedLabelId2, EntityType.NODE)) continue;
                this.updater.onLabelChange(this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL, this.storageReader.valueIndexesGetRelated(new long[]{removedLabelId2}, existingPropertyKeyIds, EntityType.NODE));
            }
        }
        if (removedPropertyKeyIdsSet != null) {
            long[] existingLabelsMinusRemovedArray = removedLabels.isEmpty() ? existingLabels : Operations.combineLabelIds(existingLabels, (IntSet)IntSets.immutable.empty(), removedLabels);
            Labels existingLabelsMinusRemoved = Labels.from(existingLabelsMinusRemovedArray);
            for (int key : removedPropertyKeyIdsSet.toArray()) {
                int existingPropertyKeyIdIndex = ArrayUtils.indexOf((int[])existingPropertyKeyIds, (int)key);
                if (existingPropertyKeyIdIndex < 0) continue;
                existingValue = (Value)existingValuesForChangedProperties.getIfAbsent(key, (Function0 & Serializable)() -> Values.NO_VALUE);
                this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)existingLabelsMinusRemoved, (long)key);
                this.ktx.txState().nodeDoRemoveProperty(node, key);
                existingPropertyKeyIds = ArrayUtils.remove((int[])existingPropertyKeyIds, (int)existingPropertyKeyIdIndex);
                if (!this.storageReader.hasRelatedSchema(existingLabelsMinusRemovedArray, key, EntityType.NODE)) continue;
                this.updater.onPropertyRemove(this.nodeCursor, (PropertyCursor)this.propertyCursor, existingLabelsMinusRemovedArray, key, existingPropertyKeyIds, existingValue);
            }
        }
        if (!addedLabels.isEmpty()) {
            IntIterator addedLabelsIterator = addedLabels.intIterator();
            while (addedLabelsIterator.hasNext()) {
                int addedLabelId2 = addedLabelsIterator.next();
                if (ArrayUtils.contains((long[])existingLabels, (long)addedLabelId2)) continue;
                LongSet removed = this.ktx.txState().nodeStateLabelDiffSets(node).getRemoved();
                if (!removed.contains((long)addedLabelId2)) {
                    this.ktx.securityAuthorizationHandler().assertAllowsSetLabel(this.ktx.securityContext(), this.token::labelGetName, (long)addedLabelId2);
                }
                this.ktx.txState().nodeDoAddLabel(addedLabelId2, node);
                if (!this.storageReader.hasRelatedSchema(addedLabelId2, EntityType.NODE)) continue;
                this.updater.onLabelChange(this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL, this.storageReader.valueIndexesGetRelated(new long[]{addedLabelId2}, existingPropertyKeyIds, EntityType.NODE));
            }
        }
        if (changedPropertyKeyIdsSet != null) {
            Labels labelsAfterSet = Labels.from(labelsAfter);
            MutableIntSet existingPropertyKeyIdsBeforeChange = IntSets.mutable.of(existingPropertyKeyIds);
            for (int key : changedPropertyKeyIds) {
                Value value = (Value)properties.get(key);
                existingValue = (Value)existingValuesForChangedProperties.getIfAbsent(key, (Function0 & Serializable)() -> Values.NO_VALUE);
                if (existingValue == Values.NO_VALUE) {
                    this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)labelsAfterSet, (long)key);
                    this.ktx.txState().nodeDoAddProperty(node, key, value);
                    hasRelatedSchema = this.storageReader.hasRelatedSchema(labelsAfter, key, EntityType.NODE);
                    if (hasRelatedSchema) {
                        this.updater.onPropertyAdd(this.nodeCursor, (PropertyCursor)this.propertyCursor, labelsAfter, key, existingPropertyKeyIdsBeforeChange.toSortedArray(), value);
                    }
                } else {
                    this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)labelsAfterSet, (long)key);
                    this.ktx.txState().nodeDoChangeProperty(node, key, value);
                    hasRelatedSchema = this.storageReader.hasRelatedSchema(labelsAfter, key, EntityType.NODE);
                    if (hasRelatedSchema) {
                        this.updater.onPropertyChange(this.nodeCursor, (PropertyCursor)this.propertyCursor, labelsAfter, key, existingPropertyKeyIdsBeforeChange.toSortedArray(), existingValue, value);
                    }
                }
                existingPropertyKeyIdsBeforeChange.add(key);
            }
        }
    }

    public void relationshipApplyChanges(long relationship, IntObjectMap<Value> properties) throws EntityNotFoundException, ConstraintValidationException {
        Object afterPropertyKeyIds;
        int[] changedPropertyKeyIds;
        this.ktx.assertOpen();
        this.acquireExclusiveRelationshipLock(relationship);
        if (properties.isEmpty()) {
            return;
        }
        this.singleRelationship(relationship);
        int type = this.acquireSharedRelationshipTypeLock();
        MutableIntObjectMap existingValuesForChangedProperties = IntObjectMaps.mutable.empty();
        this.relationshipCursor.properties(this.propertyCursor, PropertySelection.selection((int[])properties.keySet().toArray()));
        while (this.propertyCursor.next()) {
            existingValuesForChangedProperties.put(this.propertyCursor.propertyKey(), (Object)this.propertyCursor.propertyValue());
        }
        int[] existingPropertyKeyIds = this.loadSortedRelationshipPropertyKeyList();
        MutableIntSet afterPropertyKeyIdsSet = IntSets.mutable.of(existingPropertyKeyIds);
        boolean hasPropertyRemovals = false;
        MutableIntSet changedPropertyKeyIdsSet = null;
        RichIterable propertiesKeyValueView = properties.keyValuesView();
        for (IntObjectPair property : propertiesKeyValueView) {
            int key = property.getOne();
            Value value = (Value)property.getTwo();
            if (value == Values.NO_VALUE) {
                hasPropertyRemovals = true;
                afterPropertyKeyIdsSet.remove(key);
                continue;
            }
            afterPropertyKeyIdsSet.add(key);
            Value existingValue = (Value)existingValuesForChangedProperties.get(key);
            if (existingValue != null && !Operations.propertyHasChanged(value, existingValue)) continue;
            if (changedPropertyKeyIdsSet == null) {
                changedPropertyKeyIdsSet = IntSets.mutable.empty();
            }
            changedPropertyKeyIdsSet.add(key);
        }
        int[] nArray = changedPropertyKeyIds = changedPropertyKeyIdsSet != null ? changedPropertyKeyIdsSet.toSortedArray() : ArrayUtils.EMPTY_INT_ARRAY;
        if (changedPropertyKeyIdsSet != null) {
            afterPropertyKeyIds = afterPropertyKeyIdsSet.toSortedArray();
            Collection uniquenessConstraints = this.storageReader.uniquenessConstraintsGetRelated(new long[]{type}, changedPropertyKeyIds, EntityType.RELATIONSHIP);
            SchemaMatcher.onMatchingSchema(uniquenessConstraints.iterator(), -1, (int[])afterPropertyKeyIds, constraint -> this.validateNoExistingRelWithExactValues((IndexBackedConstraintDescriptor)constraint, this.storageReader.indexGetForName(constraint.getName()), this.getAllPropertyValues((EntityCursor)this.relationshipCursor, constraint.schema(), properties), relationship));
        }
        if (hasPropertyRemovals) {
            afterPropertyKeyIds = propertiesKeyValueView.iterator();
            while (afterPropertyKeyIds.hasNext()) {
                int existingPropertyKeyIdIndex;
                IntObjectPair property = (IntObjectPair)afterPropertyKeyIds.next();
                int key = property.getOne();
                Value value = (Value)property.getTwo();
                if (value != Values.NO_VALUE || (existingPropertyKeyIdIndex = ArrayUtils.indexOf((int[])existingPropertyKeyIds, (int)key)) < 0) continue;
                Value existingValue = (Value)existingValuesForChangedProperties.getIfAbsent(key, (Function0 & Serializable)() -> Values.NO_VALUE);
                this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, (long)key);
                this.ktx.txState().relationshipDoRemoveProperty(relationship, type, this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), key);
                existingPropertyKeyIds = ArrayUtils.remove((int[])existingPropertyKeyIds, (int)existingPropertyKeyIdIndex);
                if (!this.storageReader.hasRelatedSchema(new long[]{type}, key, EntityType.RELATIONSHIP)) continue;
                this.updater.onPropertyRemove(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, key, existingPropertyKeyIds, existingValue);
            }
        }
        if (changedPropertyKeyIdsSet != null) {
            MutableIntSet existingPropertyKeyIdsBeforeChange = IntSets.mutable.of(existingPropertyKeyIds);
            for (int key : changedPropertyKeyIds) {
                Value value = (Value)properties.get(key);
                Value existingValue = (Value)existingValuesForChangedProperties.getIfAbsent(key, (Function0 & Serializable)() -> Values.NO_VALUE);
                if (existingValue == Values.NO_VALUE) {
                    this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, (long)key);
                    this.ktx.txState().relationshipDoReplaceProperty(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), key, Values.NO_VALUE, value);
                    hasRelatedSchema = this.storageReader.hasRelatedSchema(new long[]{type}, key, EntityType.RELATIONSHIP);
                    if (hasRelatedSchema) {
                        this.updater.onPropertyAdd(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, key, existingPropertyKeyIdsBeforeChange.toSortedArray(), value);
                    }
                } else {
                    this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, (long)key);
                    this.ktx.txState().relationshipDoReplaceProperty(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), key, existingValue, value);
                    hasRelatedSchema = this.storageReader.hasRelatedSchema(new long[]{type}, key, EntityType.RELATIONSHIP);
                    if (hasRelatedSchema) {
                        this.updater.onPropertyChange(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, key, existingPropertyKeyIdsBeforeChange.toSortedArray(), existingValue, value);
                    }
                }
                existingPropertyKeyIdsBeforeChange.add(key);
            }
        }
    }

    private static long[] combineLabelIds(long[] existingLabels, IntSet addedLabels, IntSet removedLabels) {
        if (addedLabels.isEmpty() && removedLabels.isEmpty()) {
            return existingLabels;
        }
        MutableLongSet result = LongSets.mutable.of(existingLabels);
        addedLabels.forEach(arg_0 -> ((MutableLongSet)result).add(arg_0));
        removedLabels.forEach(arg_0 -> ((MutableLongSet)result).remove(arg_0));
        return result.toSortedArray();
    }

    private String resolvePropertyKey(long propertyKey) {
        String propKeyName;
        try {
            propKeyName = this.token.propertyKeyName((int)propertyKey);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            propKeyName = "<unknown>";
        }
        return propKeyName;
    }

    private void checkUniquenessConstraints(long node, int propertyKey, Value value, long[] labels, int[] existingPropertyKeyIds) throws ConstraintValidationException {
        Collection uniquenessConstraints = this.storageReader.uniquenessConstraintsGetRelated(labels, propertyKey, EntityType.NODE);
        SchemaMatcher.onMatchingSchema(uniquenessConstraints.iterator(), propertyKey, existingPropertyKeyIds, constraint -> this.validateNoExistingNodeWithExactValues((IndexBackedConstraintDescriptor)constraint, this.storageReader.indexGetForName(constraint.getName()), this.getAllPropertyValues((EntityCursor)this.nodeCursor, constraint.schema(), propertyKey, value), node));
    }

    private void checkRelationshipUniquenessConstraints(long rel, int propertyKey, Value value, int type, int[] existingPropertyKeyIds) throws ConstraintValidationException {
        Collection uniquenessConstraints = this.storageReader.uniquenessConstraintsGetRelated(new long[]{type}, propertyKey, EntityType.RELATIONSHIP);
        SchemaMatcher.onMatchingSchema(uniquenessConstraints.iterator(), propertyKey, existingPropertyKeyIds, constraint -> this.validateNoExistingRelWithExactValues((IndexBackedConstraintDescriptor)constraint, this.storageReader.indexGetForName(constraint.getName()), this.getAllPropertyValues((EntityCursor)this.relationshipCursor, constraint.schema(), propertyKey, value), rel));
    }

    public Value nodeRemoveProperty(long node, int propertyKey) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        Value existingValue = this.readNodeProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            long[] labels = this.acquireSharedNodeLabelLocks();
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)Labels.from(labels), (long)propertyKey);
            this.ktx.txState().nodeDoRemoveProperty(node, propertyKey);
            if (this.storageReader.hasRelatedSchema(labels, propertyKey, EntityType.NODE)) {
                this.updater.onPropertyRemove(this.nodeCursor, (PropertyCursor)this.propertyCursor, labels, propertyKey, this.loadSortedNodePropertyKeyList(), existingValue);
            }
        }
        return existingValue;
    }

    public Value relationshipSetProperty(long relationship, int propertyKey, Value value) throws EntityNotFoundException, ConstraintValidationException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        int type = this.acquireSharedRelationshipTypeLock();
        Value existingValue = this.readRelationshipProperty(propertyKey);
        int[] existingPropertyKeyIds = null;
        boolean hasRelatedSchema = this.storageReader.hasRelatedSchema(new long[]{type}, propertyKey, EntityType.RELATIONSHIP);
        if (hasRelatedSchema) {
            existingPropertyKeyIds = this.loadSortedRelationshipPropertyKeyList();
        }
        if (existingValue == Values.NO_VALUE) {
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, (long)propertyKey);
            if (hasRelatedSchema) {
                this.checkRelationshipUniquenessConstraints(relationship, propertyKey, value, type, existingPropertyKeyIds);
            }
            this.ktx.txState().relationshipDoReplaceProperty(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), propertyKey, Values.NO_VALUE, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyAdd(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, propertyKey, existingPropertyKeyIds, value);
            }
            return Values.NO_VALUE;
        }
        if (Operations.propertyHasChanged(existingValue, value)) {
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, (long)propertyKey);
            if (hasRelatedSchema) {
                this.checkRelationshipUniquenessConstraints(relationship, propertyKey, value, type, existingPropertyKeyIds);
            }
            this.ktx.txState().relationshipDoReplaceProperty(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), propertyKey, existingValue, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyChange(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, propertyKey, existingPropertyKeyIds, existingValue, value);
            }
        }
        return existingValue;
    }

    public Value relationshipRemoveProperty(long relationship, int propertyKey) throws EntityNotFoundException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        Value existingValue = this.readRelationshipProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            int type = this.acquireSharedRelationshipTypeLock();
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, (long)propertyKey);
            this.ktx.txState().relationshipDoRemoveProperty(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), propertyKey);
            if (this.storageReader.hasRelatedSchema(new long[]{type}, propertyKey, EntityType.RELATIONSHIP)) {
                this.updater.onPropertyRemove(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, propertyKey, this.loadSortedRelationshipPropertyKeyList(), existingValue);
            }
        }
        return existingValue;
    }

    private Value readNodeProperty(int propertyKey) {
        this.nodeCursor.properties(this.propertyCursor, PropertySelection.selection((int)propertyKey));
        return this.propertyCursor.next() ? this.propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    private Value readRelationshipProperty(int propertyKey) {
        this.relationshipCursor.properties(this.propertyCursor, PropertySelection.selection((int)propertyKey));
        return this.propertyCursor.next() ? this.propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    public CursorFactory cursors() {
        return this.cursors;
    }

    public Procedures procedures() {
        return this.allStoreHolder;
    }

    public QueryContext queryContext() {
        return this.allStoreHolder;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.close();
            this.nodeCursor = null;
        }
        if (this.restrictedNodeCursor != null) {
            this.restrictedNodeCursor.close();
            this.restrictedNodeCursor = null;
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
        if (this.relationshipCursor != null) {
            this.relationshipCursor.close();
            this.relationshipCursor = null;
        }
        if (this.restrictedPropertyCursor != null) {
            this.restrictedPropertyCursor.close();
            this.restrictedPropertyCursor = null;
        }
        this.cursors.assertClosed();
        this.cursors.release();
    }

    public Token token() {
        return this.token;
    }

    public SchemaRead schemaRead() {
        return this.allStoreHolder;
    }

    public Read dataRead() {
        return this.allStoreHolder;
    }

    public DefaultNodeCursor nodeCursor() {
        return this.restrictedNodeCursor;
    }

    public DefaultRelationshipScanCursor relationshipCursor() {
        return this.relationshipCursor;
    }

    public DefaultPropertyCursor propertyCursor() {
        return this.restrictedPropertyCursor;
    }

    public IndexProviderDescriptor indexProviderByName(String providerName) {
        this.ktx.assertOpen();
        return this.indexProviders.indexProviderByName(providerName);
    }

    public IndexType indexTypeByProviderName(String providerName) {
        this.ktx.assertOpen();
        return this.indexProviders.indexTypeByProviderName(providerName);
    }

    public List<IndexProviderDescriptor> indexProvidersByType(IndexType indexType) {
        this.ktx.assertOpen();
        return this.indexProviders.indexProvidersByType(indexType);
    }

    public IndexDescriptor indexCreate(IndexPrototype prototype) throws KernelException {
        IndexType indexType = prototype.getIndexType();
        if ((indexType == IndexType.TEXT || indexType == IndexType.POINT) && prototype.schema().getPropertyIds().length > 1) {
            throw new UnsupportedOperationException("Composite indexes are not supported for " + indexType.name() + " index type.");
        }
        this.exclusiveSchemaLock(prototype.schema());
        this.ktx.assertOpen();
        this.assertValidDescriptor(prototype.schema(), SchemaKernelException.OperationContext.INDEX_CREATION);
        prototype = this.ensureIndexPrototypeHasName(prototype);
        prototype = this.ensureIndexPrototypeHasIndexProvider(prototype);
        Optional nameOptional = prototype.getName();
        assert (nameOptional.isPresent());
        String name = (String)nameOptional.get();
        this.exclusiveSchemaNameLock(name);
        this.assertNoBlockingSchemaRulesExists(prototype);
        return this.indexDoCreate(prototype);
    }

    public IndexDescriptor indexUniqueCreate(IndexPrototype prototype) {
        return this.indexDoCreate(prototype);
    }

    private IndexDescriptor indexDoCreate(IndexPrototype prototype) {
        this.indexProviders.validateIndexPrototype(prototype);
        TransactionState transactionState = this.ktx.txState();
        long schemaRecordId = this.commandCreationContext.reserveSchema();
        IndexDescriptor index = prototype.materialise(schemaRecordId);
        index = this.indexProviders.completeConfiguration(index);
        transactionState.indexDoAdd(index);
        return index;
    }

    private IndexPrototype ensureIndexPrototypeHasName(IndexPrototype prototype) throws KernelException {
        return prototype.getName().isEmpty() ? prototype.withName(this.generateNameFrom((SchemaDescriptorSupplier)prototype)) : prototype;
    }

    private static <E extends Exception> String[] resolveTokenNames(ThrowingIntFunction<String, E> resolver, int[] tokenIds) throws E {
        String[] names = new String[tokenIds.length];
        for (int i = 0; i < tokenIds.length; ++i) {
            names[i] = (String)resolver.apply(tokenIds[i]);
        }
        return names;
    }

    private IndexPrototype ensureIndexPrototypeHasIndexProvider(IndexPrototype prototype) {
        IndexPrototype indexPrototype;
        if (prototype.getIndexProvider() == IndexProviderDescriptor.UNDECIDED) {
            indexPrototype = prototype.withIndexProvider(switch (prototype.getIndexType()) {
                default -> throw new IncompatibleClassChangeError();
                case IndexType.LOOKUP -> this.indexProviders.getTokenIndexProvider();
                case IndexType.FULLTEXT -> this.indexProviders.getFulltextProvider();
                case IndexType.TEXT -> this.indexProviders.getTextIndexProvider();
                case IndexType.RANGE -> this.indexProviders.getDefaultProvider();
                case IndexType.POINT -> this.indexProviders.getPointIndexProvider();
            });
        } else {
            indexPrototype = prototype;
        }
        return indexPrototype;
    }

    public void indexDrop(IndexDescriptor index) throws SchemaKernelException {
        if (index == IndexDescriptor.NO_INDEX) {
            throw new DropIndexFailureException("No index was specified.");
        }
        this.exclusiveSchemaLock(index.schema());
        this.exclusiveSchemaNameLock(index.getName());
        this.assertIndexExistsForDrop(index);
        if (index.isUnique() && this.allStoreHolder.indexGetOwningUniquenessConstraintId(index) != null) {
            IndexBelongsToConstraintException cause = new IndexBelongsToConstraintException(index.schema());
            throw new DropIndexFailureException("Unable to drop index: " + cause.getUserMessage((TokenNameLookup)this.token), (Throwable)((Object)cause));
        }
        this.ktx.txState().indexDoDrop(index);
    }

    private void assertIndexExistsForDrop(IndexDescriptor index) throws DropIndexFailureException {
        try {
            this.allStoreHolder.assertIndexExists(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new DropIndexFailureException("Unable to drop index: " + e.getUserMessage((TokenNameLookup)this.token), e);
        }
    }

    public void indexDrop(String indexName) throws SchemaKernelException {
        this.exclusiveSchemaNameLock(indexName);
        IndexDescriptor index = this.allStoreHolder.indexGetForName(indexName);
        if (index == IndexDescriptor.NO_INDEX) {
            throw new DropIndexFailureException("Unable to drop index called `" + indexName + "`. There is no such index.");
        }
        this.exclusiveSchemaLock(index.schema());
        this.assertIndexExistsForDrop(index);
        if (index.isUnique() && this.allStoreHolder.indexGetOwningUniquenessConstraintId(index) != null) {
            IndexBelongsToConstraintException cause = new IndexBelongsToConstraintException(indexName, index.schema());
            throw new DropIndexFailureException("Unable to drop index: " + cause.getUserMessage((TokenNameLookup)this.token), (Throwable)((Object)cause));
        }
        this.ktx.txState().indexDoDrop(index);
    }

    public ConstraintDescriptor uniquePropertyConstraintCreate(IndexPrototype prototype) throws KernelException {
        SchemaDescriptor schema = prototype.schema();
        if (schema.entityType() == EntityType.RELATIONSHIP && !this.relationshipUniquenessConstraintEnabled) {
            throw new UnsupportedOperationException("Relationship uniqueness constraints are not supported yet");
        }
        this.exclusiveSchemaLock(schema);
        this.ktx.assertOpen();
        prototype = this.ensureIndexPrototypeHasIndexProvider(prototype);
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema, (IndexType)prototype.getIndexType());
        try {
            this.assertValidDescriptor(schema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            if (prototype.getName().isEmpty()) {
                constraint = this.ensureConstraintHasName(constraint);
                prototype = prototype.withName(constraint.getName());
            } else {
                constraint = constraint.withName((String)prototype.getName().get());
            }
            this.exclusiveSchemaNameLock(constraint.getName());
            this.assertNoBlockingSchemaRulesExists((ConstraintDescriptor)constraint);
        }
        catch (KernelException e) {
            this.exclusiveSchemaUnlock(schema);
            throw e;
        }
        constraint = this.indexBackedConstraintCreate(constraint, prototype, ignored -> {});
        return constraint;
    }

    private void assertNoBlockingSchemaRulesExists(IndexPrototype prototype) throws EquivalentSchemaRuleAlreadyExistsException, IndexWithNameAlreadyExistsException, ConstraintWithNameAlreadyExistsException, AlreadyIndexedException, AlreadyConstrainedException {
        Optional prototypeName = prototype.getName();
        if (prototypeName.isEmpty()) {
            throw new IllegalStateException("Expected index to always have a name by this point");
        }
        String name = (String)prototypeName.get();
        IndexDescriptor indexWithSameSchemaAndType = this.allStoreHolder.index(prototype.schema(), prototype.getIndexType());
        if (indexWithSameSchemaAndType.getName().equals(name) && indexWithSameSchemaAndType.isUnique() == prototype.isUnique()) {
            throw new EquivalentSchemaRuleAlreadyExistsException((SchemaRule)indexWithSameSchemaAndType, SchemaKernelException.OperationContext.INDEX_CREATION, (TokenNameLookup)this.token);
        }
        this.assertSchemaRuleWithNameDoesNotExist(name);
        Iterator<ConstraintDescriptor> constraintWithSameSchema = this.allStoreHolder.constraintsGetForSchema(prototype.schema());
        while (constraintWithSameSchema.hasNext()) {
            ConstraintDescriptor constraint = constraintWithSameSchema.next();
            if (!constraint.isIndexBackedConstraint() || constraint.asIndexBackedConstraint().indexType() != prototype.getIndexType()) continue;
            throw new AlreadyConstrainedException(constraint, SchemaKernelException.OperationContext.INDEX_CREATION, (TokenNameLookup)this.token);
        }
        if (indexWithSameSchemaAndType != IndexDescriptor.NO_INDEX) {
            throw new AlreadyIndexedException(prototype.schema(), SchemaKernelException.OperationContext.INDEX_CREATION, (TokenNameLookup)this.token);
        }
    }

    private void assertNoBlockingSchemaRulesExists(ConstraintDescriptor constraint) throws EquivalentSchemaRuleAlreadyExistsException, IndexWithNameAlreadyExistsException, ConstraintWithNameAlreadyExistsException, AlreadyConstrainedException, AlreadyIndexedException {
        IndexDescriptor existingIndex;
        String name = constraint.getName();
        if (name == null) {
            throw new IllegalStateException("Expected constraint to always have a name by this point");
        }
        List constraintsWithSameSchema = Iterators.asList(this.allStoreHolder.constraintsGetForSchema(constraint.schema()));
        for (ConstraintDescriptor constraintWithSameSchema : constraintsWithSameSchema) {
            if (!constraint.equals(constraintWithSameSchema) || !constraint.getName().equals(constraintWithSameSchema.getName())) continue;
            throw new EquivalentSchemaRuleAlreadyExistsException((SchemaRule)constraintWithSameSchema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
        }
        this.assertSchemaRuleWithNameDoesNotExist(name);
        for (ConstraintDescriptor constraintWithSameSchema : constraintsWithSameSchema) {
            boolean existingIsExistenceConstraint;
            boolean creatingExistenceConstraint = constraint.type() == ConstraintType.EXISTS;
            if (creatingExistenceConstraint != (existingIsExistenceConstraint = constraintWithSameSchema.type() == ConstraintType.EXISTS) || !creatingExistenceConstraint && constraintWithSameSchema.asIndexBackedConstraint().indexType() != constraint.asIndexBackedConstraint().indexType()) continue;
            throw new AlreadyConstrainedException(constraintWithSameSchema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
        }
        if (constraint.isIndexBackedConstraint() && (existingIndex = this.allStoreHolder.index(constraint.schema(), constraint.asIndexBackedConstraint().indexType())) != IndexDescriptor.NO_INDEX) {
            throw new AlreadyIndexedException(existingIndex.schema(), SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
        }
        if (constraint.isIndexBackedConstraint() && this.ktx.hasTxStateWithChanges()) {
            for (ConstraintDescriptor droppedConstraint : this.ktx.txState().constraintsChanges().getRemoved()) {
                if (!droppedConstraint.isIndexBackedConstraint() || !constraint.schema().equals(droppedConstraint.schema()) || droppedConstraint.asIndexBackedConstraint().indexType() != constraint.asIndexBackedConstraint().indexType()) continue;
                throw new UnsupportedOperationException(String.format("Trying to create constraint '%s' in same transaction as dropping '%s'. This is not supported because they are both backed by similar indexes. Please drop constraint in a separate transaction before creating the new one.", constraint.getName(), droppedConstraint.getName()));
            }
        }
    }

    private void assertSchemaRuleWithNameDoesNotExist(String name) throws IndexWithNameAlreadyExistsException, ConstraintWithNameAlreadyExistsException {
        ConstraintDescriptor constraintWithSameName = this.allStoreHolder.constraintGetForName(name);
        if (constraintWithSameName != null) {
            throw new ConstraintWithNameAlreadyExistsException(name);
        }
        IndexDescriptor indexWithSameName = this.allStoreHolder.indexGetForName(name);
        if (indexWithSameName != IndexDescriptor.NO_INDEX) {
            throw new IndexWithNameAlreadyExistsException(name);
        }
    }

    public ConstraintDescriptor keyConstraintCreate(IndexPrototype prototype) throws KernelException {
        SchemaDescriptor schema = prototype.schema();
        if (schema.entityType() == EntityType.RELATIONSHIP && !this.relationshipUniquenessConstraintEnabled) {
            throw new UnsupportedOperationException("Relationship key constraints are not supported yet");
        }
        this.exclusiveSchemaLock(schema);
        this.ktx.assertOpen();
        prototype = this.ensureIndexPrototypeHasIndexProvider(prototype);
        KeyConstraintDescriptor constraint = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema, (IndexType)prototype.getIndexType());
        try {
            this.assertValidDescriptor(schema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            if (prototype.getName().isEmpty()) {
                constraint = this.ensureConstraintHasName(constraint);
                prototype = prototype.withName(constraint.getName());
            } else {
                constraint = constraint.withName((String)prototype.getName().get());
            }
            this.exclusiveSchemaNameLock(constraint.getName());
            this.assertNoBlockingSchemaRulesExists((ConstraintDescriptor)constraint);
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock(schema);
            throw e;
        }
        this.constraintSemantics.assertKeyConstraintAllowed(constraint.schema());
        this.indexBackedConstraintCreate(constraint, prototype, this::enforceKeyConstraint);
        return constraint;
    }

    private void enforceKeyConstraint(SchemaDescriptor schema) throws KernelException {
        if (schema.entityType() == EntityType.NODE) {
            this.enforceNodeKeyConstraint(schema);
        } else {
            this.enforceRelKeyConstraint(schema);
        }
    }

    private void enforceNodeKeyConstraint(SchemaDescriptor schema) throws KernelException {
        IndexDescriptor index = this.allStoreHolder.findUsableTokenIndex(EntityType.NODE);
        if (index != IndexDescriptor.NO_INDEX) {
            try (DefaultNodeLabelIndexCursor cursor = this.cursors.allocateFullAccessNodeLabelIndexCursor(this.ktx.cursorContext());){
                TokenReadSession session = this.allStoreHolder.tokenReadSession(index);
                this.allStoreHolder.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(schema.getLabelId()), this.ktx.cursorContext());
                this.constraintSemantics.validateNodeKeyConstraint(cursor, this.nodeCursor, this.propertyCursor, schema.asLabelSchemaDescriptor(), (TokenNameLookup)this.token);
            }
        }
        try (FullAccessNodeCursor cursor = this.cursors.allocateFullAccessNodeCursor(this.ktx.cursorContext());){
            this.allStoreHolder.allNodesScan(cursor);
            this.constraintSemantics.validateNodeKeyConstraint(new FilteringNodeCursorWrapper(cursor, CursorPredicates.hasLabel(schema.getLabelId())), this.propertyCursor, schema.asLabelSchemaDescriptor(), (TokenNameLookup)this.token);
        }
    }

    private void enforceRelKeyConstraint(SchemaDescriptor schema) throws KernelException {
        IndexDescriptor index = this.allStoreHolder.findUsableTokenIndex(EntityType.RELATIONSHIP);
        if (index != IndexDescriptor.NO_INDEX) {
            try (RelationshipTypeIndexCursor cursor = this.cursors.allocateFullAccessRelationshipTypeIndexCursor(this.ktx.cursorContext());){
                TokenReadSession session = this.allStoreHolder.tokenReadSession(index);
                this.allStoreHolder.relationshipTypeScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(schema.getRelTypeId()), this.ktx.cursorContext());
                this.constraintSemantics.validateRelKeyConstraint(cursor, this.relationshipCursor, this.propertyCursor, schema.asRelationshipTypeSchemaDescriptor(), (TokenNameLookup)this.token);
            }
        }
        try (RelationshipScanCursor cursor = this.cursors.allocateFullAccessRelationshipScanCursor(this.ktx.cursorContext());){
            this.allStoreHolder.allRelationshipsScan(cursor);
            this.constraintSemantics.validateRelKeyConstraint(new FilteringRelationshipScanCursorWrapper(cursor, CursorPredicates.hasType(schema.getRelTypeId())), this.propertyCursor, schema.asRelationshipTypeSchemaDescriptor(), (TokenNameLookup)this.token);
        }
    }

    public ConstraintDescriptor nodePropertyExistenceConstraintCreate(LabelSchemaDescriptor schema, String name) throws KernelException {
        ConstraintDescriptor constraint = this.lockAndValidatePropertyExistenceConstraint((SchemaDescriptor)schema, name);
        this.enforceNodePropertyExistenceConstraint(schema);
        this.ktx.txState().constraintDoAdd(constraint);
        return constraint;
    }

    private void enforceNodePropertyExistenceConstraint(LabelSchemaDescriptor schema) throws KernelException {
        IndexDescriptor index = this.allStoreHolder.findUsableTokenIndex(EntityType.NODE);
        if (index != IndexDescriptor.NO_INDEX) {
            try (DefaultNodeLabelIndexCursor cursor = this.cursors.allocateFullAccessNodeLabelIndexCursor(this.ktx.cursorContext());){
                TokenReadSession session = this.allStoreHolder.tokenReadSession(index);
                this.allStoreHolder.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(schema.getLabelId()), this.ktx.cursorContext());
                this.constraintSemantics.validateNodePropertyExistenceConstraint(cursor, this.nodeCursor, this.propertyCursor, schema, (TokenNameLookup)this.token);
            }
        }
        try (FullAccessNodeCursor cursor = this.cursors.allocateFullAccessNodeCursor(this.ktx.cursorContext());){
            this.allStoreHolder.allNodesScan(cursor);
            this.constraintSemantics.validateNodePropertyExistenceConstraint(new FilteringNodeCursorWrapper(cursor, CursorPredicates.hasLabel(schema.getLabelId())), this.propertyCursor, schema, (TokenNameLookup)this.token);
        }
    }

    public ConstraintDescriptor relationshipPropertyExistenceConstraintCreate(RelationTypeSchemaDescriptor schema, String name) throws KernelException {
        ConstraintDescriptor constraint = this.lockAndValidatePropertyExistenceConstraint((SchemaDescriptor)schema, name);
        this.enforceRelationshipPropertyExistenceConstraint(schema);
        this.ktx.txState().constraintDoAdd(constraint);
        return constraint;
    }

    private void enforceRelationshipPropertyExistenceConstraint(RelationTypeSchemaDescriptor schema) throws KernelException {
        IndexDescriptor index = this.allStoreHolder.findUsableTokenIndex(EntityType.RELATIONSHIP);
        if (index != IndexDescriptor.NO_INDEX) {
            try (RelationshipTypeIndexCursor fullAccessIndexCursor = this.cursors.allocateFullAccessRelationshipTypeIndexCursor(this.ktx.cursorContext());){
                TokenReadSession session = this.allStoreHolder.tokenReadSession(index);
                this.allStoreHolder.relationshipTypeScan(session, fullAccessIndexCursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(schema.getRelTypeId()), this.ktx.cursorContext());
                this.constraintSemantics.validateRelationshipPropertyExistenceConstraint(fullAccessIndexCursor, this.propertyCursor, schema, (TokenNameLookup)this.token);
            }
        }
        try (RelationshipScanCursor fullAccessCursor = this.cursors.allocateFullAccessRelationshipScanCursor(this.ktx.cursorContext());){
            this.allStoreHolder.allRelationshipsScan(fullAccessCursor);
            this.constraintSemantics.validateRelationshipPropertyExistenceConstraint(new FilteringRelationshipScanCursorWrapper(fullAccessCursor, CursorPredicates.hasType(schema.getRelTypeId())), this.propertyCursor, schema, (TokenNameLookup)this.token);
        }
    }

    private ConstraintDescriptor lockAndValidatePropertyExistenceConstraint(SchemaDescriptor descriptor, String name) throws KernelException {
        this.exclusiveSchemaLock(descriptor);
        this.ktx.assertOpen();
        try {
            this.assertValidDescriptor(descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            ConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)descriptor).withName(name);
            constraint = this.ensureConstraintHasName(constraint);
            this.exclusiveSchemaNameLock(constraint.getName());
            this.assertNoBlockingSchemaRulesExists(constraint);
            return constraint;
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock(descriptor);
            throw e;
        }
    }

    public void constraintDrop(String name) throws SchemaKernelException {
        this.exclusiveSchemaNameLock(name);
        ConstraintDescriptor constraint = this.allStoreHolder.constraintGetForName(name);
        if (constraint == null) {
            throw new DropConstraintFailureException(name, (Throwable)((Object)new NoSuchConstraintException(name)));
        }
        this.constraintDrop(constraint);
    }

    public void constraintDrop(ConstraintDescriptor constraint) throws SchemaKernelException {
        IndexDescriptor index;
        SchemaDescriptor schema = constraint.schema();
        this.exclusiveLock(schema.keyType(), schema.lockingKeys());
        this.exclusiveSchemaNameLock(constraint.getName());
        this.ktx.assertOpen();
        try {
            this.assertConstraintExists(constraint);
        }
        catch (NoSuchConstraintException e) {
            throw new DropConstraintFailureException((SchemaDescriptorSupplier)constraint, (Throwable)((Object)e));
        }
        TransactionState txState = this.ktx.txState();
        txState.constraintDoDrop(constraint);
        if (constraint.enforcesUniqueness() && (index = this.allStoreHolder.indexGetForName(constraint.getName())) != IndexDescriptor.NO_INDEX) {
            txState.indexDoDrop(index);
        }
    }

    private void exclusiveLock(ResourceType resource, long[] resourceIds) {
        this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), resource, resourceIds);
    }

    private void acquireExclusiveNodeLock(long node) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().nodeIsAddedInThisTx(node)) {
            this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), (ResourceType)ResourceTypes.NODE, new long[]{node});
        }
    }

    private void acquireExclusiveRelationshipLock(long relationshipId) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().relationshipIsAddedInThisTx(relationshipId)) {
            this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{relationshipId});
        }
    }

    private void sharedSchemaLock(ResourceType type, long tokenId) {
        this.ktx.lockClient().acquireShared(this.ktx.lockTracer(), type, new long[]{tokenId});
    }

    private void sharedTokenSchemaLock(ResourceTypes rt) {
        this.sharedSchemaLock((ResourceType)rt, Long.MAX_VALUE);
    }

    private void exclusiveSchemaLock(SchemaDescriptor schema) {
        long[] lockingIds = schema.lockingKeys();
        this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), schema.keyType(), lockingIds);
    }

    private void exclusiveSchemaUnlock(SchemaDescriptor schema) {
        long[] lockingIds = schema.lockingKeys();
        this.ktx.lockClient().releaseExclusive(schema.keyType(), lockingIds);
    }

    private void exclusiveSchemaNameLock(String schemaName) {
        long lockingId = ResourceIds.schemaNameResourceId(schemaName);
        this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), (ResourceType)ResourceTypes.SCHEMA_NAME, new long[]{lockingId});
    }

    private static boolean propertyHasChanged(Value lhs, Value rhs) {
        return !lhs.isSameValueTypeAs(rhs) || !lhs.equals(rhs);
    }

    private void assertNodeExists(long sourceNode) throws EntityNotFoundException {
        if (!this.allStoreHolder.nodeExists(sourceNode)) {
            throw new EntityNotFoundException(EntityType.NODE, this.ktx.internalTransaction().elementIdMapper().nodeElementId(sourceNode));
        }
    }

    public Locks locks() {
        return this.allStoreHolder;
    }

    private void assertConstraintExists(ConstraintDescriptor constraint) throws NoSuchConstraintException {
        if (!this.allStoreHolder.constraintExists(constraint)) {
            throw new NoSuchConstraintException((SchemaDescriptorSupplier)constraint, (TokenNameLookup)this.token);
        }
    }

    private void assertValidDescriptor(SchemaDescriptor descriptor, SchemaKernelException.OperationContext context) throws RepeatedSchemaComponentException {
        long numUniqueProp = Arrays.stream(descriptor.getPropertyIds()).distinct().count();
        long numUniqueEntityTokens = Arrays.stream(descriptor.getEntityTokenIds()).distinct().count();
        if (numUniqueProp != (long)descriptor.getPropertyIds().length) {
            throw new RepeatedPropertyInSchemaException(descriptor, context, (TokenNameLookup)this.token);
        }
        if (numUniqueEntityTokens != (long)descriptor.getEntityTokenIds().length) {
            if (descriptor.entityType() == EntityType.NODE) {
                throw new RepeatedLabelInSchemaException(descriptor, context, (TokenNameLookup)this.token);
            }
            throw new RepeatedRelationshipTypeInSchemaException(descriptor, context, (TokenNameLookup)this.token);
        }
    }

    private <T extends IndexBackedConstraintDescriptor> T indexBackedConstraintCreate(T constraint, IndexPrototype prototype, ConstraintIndexCreator.PropertyExistenceEnforcer propertyExistenceEnforcer) throws KernelException {
        try {
            if (this.allStoreHolder.constraintExists((ConstraintDescriptor)constraint)) {
                throw new AlreadyConstrainedException((ConstraintDescriptor)constraint, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
            }
            IndexType indexType = prototype.getIndexType();
            if (indexType != IndexType.RANGE) {
                throw new CreateConstraintFailureException(constraint, "Cannot create backing constraint index with index type " + indexType + ".");
            }
            if (prototype.schema().isFulltextSchemaDescriptor()) {
                throw new CreateConstraintFailureException(constraint, "Cannot create backing constraint index using a full-text schema: " + prototype.schema().userDescription((TokenNameLookup)this.token));
            }
            if (prototype.schema().isAnyTokenSchemaDescriptor()) {
                throw new CreateConstraintFailureException(constraint, "Cannot create backing constraint index using an any token schema: " + prototype.schema().userDescription((TokenNameLookup)this.token));
            }
            if (!prototype.isUnique()) {
                throw new CreateConstraintFailureException(constraint, "Cannot create index backed constraint using an index prototype that is not unique: " + prototype.userDescription((TokenNameLookup)this.token));
            }
            IndexDescriptor index = this.constraintIndexCreator.createUniquenessConstraintIndex(this.ktx, (IndexBackedConstraintDescriptor)constraint, prototype, propertyExistenceEnforcer);
            if (!this.allStoreHolder.constraintExists((ConstraintDescriptor)constraint)) {
                constraint = constraint.withOwnedIndexId(index.getId());
                this.ktx.txState().constraintDoAdd((IndexBackedConstraintDescriptor)constraint, index);
            } else {
                Iterator<ConstraintDescriptor> constraintsWithSchema = this.allStoreHolder.constraintsGetForSchema(constraint.schema());
                while (constraintsWithSchema.hasNext()) {
                    ConstraintDescriptor next = constraintsWithSchema.next();
                    if (!next.isIndexBackedConstraint() || next.asIndexBackedConstraint().indexType() != constraint.indexType()) continue;
                    constraint = (IndexBackedConstraintDescriptor)constraintsWithSchema;
                    break;
                }
            }
            return constraint;
        }
        catch (TransactionFailureException | AlreadyConstrainedException | UniquePropertyValueValidationException e) {
            throw new CreateConstraintFailureException(constraint, (Throwable)e);
        }
    }

    private <T extends ConstraintDescriptor> T ensureConstraintHasName(T constraint) throws KernelException {
        return (T)(constraint.getName() == null ? constraint.withName(this.generateNameFrom((SchemaDescriptorSupplier)constraint)) : constraint);
    }

    private String generateNameFrom(SchemaDescriptorSupplier schemaDescriptorSupplier) throws LabelNotFoundKernelException, RelationshipTypeIdNotFoundKernelException, PropertyKeyIdNotFoundKernelException {
        SchemaDescriptor schema = schemaDescriptorSupplier.schema();
        int[] entityTokenIds = schema.getEntityTokenIds();
        String[] entityTokenNames = switch (schema.entityType()) {
            default -> throw new IncompatibleClassChangeError();
            case EntityType.NODE -> Operations.resolveTokenNames(this.token::nodeLabelName, entityTokenIds);
            case EntityType.RELATIONSHIP -> Operations.resolveTokenNames(this.token::relationshipTypeName, entityTokenIds);
        };
        int[] propertyIds = schema.getPropertyIds();
        String[] propertyNames = Operations.resolveTokenNames(this.token::propertyKeyName, propertyIds);
        return SchemaNameUtil.generateName((SchemaDescriptorSupplier)schemaDescriptorSupplier, (String[])entityTokenNames, (String[])propertyNames);
    }
}

