/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.RawIterator;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.IndexReaderCache;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.OverridableSecurityContext;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.parallel.ParallelAccessCheck;
import org.neo4j.kernel.impl.api.parallel.ThreadExecutionContext;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.kernel.impl.newapi.DefaultIndexReadSession;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTypeIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultTokenReadSession;
import org.neo4j.kernel.impl.newapi.FilteringRelationshipScanCursorWrapper;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.ProcedureCaller;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.SchemaReadCoreSnapshot;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CountsDelta;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.DiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;

public abstract class AllStoreHolder
extends Read {
    private final SchemaState schemaState;
    private final IndexingService indexingService;
    private final IndexStatisticsStore indexStatisticsStore;
    private final GlobalProcedures globalProcedures;
    private final MemoryTracker memoryTracker;
    private final IndexReaderCache<ValueIndexReader> valueIndexReaderCache;
    private final IndexReaderCache<TokenIndexReader> tokenIndexReaderCache;

    private AllStoreHolder(StorageReader storageReader, TokenRead tokenRead, SchemaState schemaState, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, GlobalProcedures globalProcedures, MemoryTracker memoryTracker, DefaultPooledCursors cursors, StoreCursors storageCursors, StorageLocks storageLocks, LockTracer lockTracer) {
        super(storageReader, tokenRead, cursors, storageCursors, storageLocks, lockTracer);
        this.schemaState = schemaState;
        this.valueIndexReaderCache = new IndexReaderCache(index -> indexingService.getIndexProxy((IndexDescriptor)index).newValueReader());
        this.tokenIndexReaderCache = new IndexReaderCache(index -> indexingService.getIndexProxy((IndexDescriptor)index).newTokenReader());
        this.indexingService = indexingService;
        this.indexStatisticsStore = indexStatisticsStore;
        this.memoryTracker = memoryTracker;
        this.globalProcedures = globalProcedures;
    }

    public boolean nodeExists(long reference) {
        this.performCheckBeforeOperation();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.nodeIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.nodeIsAddedInThisTx(reference)) {
                return true;
            }
        }
        boolean existsInNodeStore = this.storageReader.nodeExists(reference, this.storageCursors);
        if (this.getAccessMode().allowsTraverseAllLabels()) {
            return existsInNodeStore;
        }
        if (!existsInNodeStore) {
            return false;
        }
        try (DefaultNodeCursor node = this.cursors.allocateNodeCursor(this.cursorContext());){
            this.singleNode(reference, node);
            boolean bl = node.next();
            return bl;
        }
    }

    public boolean nodeDeletedInTransaction(long node) {
        this.performCheckBeforeOperation();
        return this.hasTxStateWithChanges() && this.txState().nodeIsDeletedInThisTx(node);
    }

    public boolean relationshipDeletedInTransaction(long relationship) {
        this.performCheckBeforeOperation();
        return this.hasTxStateWithChanges() && this.txState().relationshipIsDeletedInThisTx(relationship);
    }

    public Value nodePropertyChangeInTransactionOrNull(long node, int propertyKeyId) {
        this.performCheckBeforeOperation();
        return this.hasTxStateWithChanges() ? this.txState().getNodeState(node).propertyValue(propertyKeyId) : null;
    }

    public Value relationshipPropertyChangeInTransactionOrNull(long relationship, int propertyKeyId) {
        this.performCheckBeforeOperation();
        return this.hasTxStateWithChanges() ? this.txState().getRelationshipState(relationship).propertyValue(propertyKeyId) : null;
    }

    public long countsForNode(int labelId) {
        return this.countsForNodeWithoutTxState(labelId) + this.countsForNodeInTxState(labelId);
    }

    public long countsForNodeWithoutTxState(int labelId) {
        if (this.getAccessMode().allowsTraverseAllNodesWithLabel((long)labelId)) {
            return this.storageReader.countsForNode(labelId, this.cursorContext());
        }
        if (this.getAccessMode().disallowsTraverseLabel((long)labelId)) {
            return 0L;
        }
        long count = 0L;
        try (DefaultNodeCursor nodes = this.cursors.allocateNodeCursor(this.cursorContext());){
            this.allNodesScan(nodes);
            while (nodes.next()) {
                if (labelId != -1 && !nodes.hasLabel(labelId)) continue;
                ++count;
            }
        }
        return count - this.countsForNodeInTxState(labelId);
    }

    private long countsForNodeInTxState(int labelId) {
        long count = 0L;
        if (this.hasTxStateWithChanges()) {
            CountsDelta counts = new CountsDelta();
            try {
                TransactionState txState = this.txState();
                try (TransactionCountingStateVisitor countingVisitor = new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storageReader, (ReadableTransactionState)txState, counts, this.cursorContext(), this.storageCursors);){
                    txState.accept((TxStateVisitor)countingVisitor);
                }
                if (counts.hasChanges()) {
                    count += counts.nodeCount(labelId, this.cursorContext());
                }
            }
            catch (KernelException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        return this.countsForRelationshipWithoutTxState(startLabelId, typeId, endLabelId) + this.countsForRelationshipInTxState(startLabelId, typeId, endLabelId);
    }

    public long countsForRelationshipWithoutTxState(int startLabelId, int typeId, int endLabelId) {
        long count;
        block41: {
            if (this.getAccessMode().allowsTraverseRelType(typeId) && this.getAccessMode().allowsTraverseNode(new long[]{startLabelId}) && this.getAccessMode().allowsTraverseNode(new long[]{endLabelId})) {
                return this.storageReader.countsForRelationship(startLabelId, typeId, endLabelId, this.cursorContext());
            }
            if (this.getAccessMode().disallowsTraverseRelType(typeId) || this.getAccessMode().disallowsTraverseLabel((long)startLabelId) || this.getAccessMode().disallowsTraverseLabel((long)endLabelId)) {
                return 0L;
            }
            if (typeId != -1) {
                try {
                    DefaultNodeCursor targetNode;
                    DefaultNodeCursor sourceNode;
                    IndexDescriptor index = this.findUsableTokenIndex(EntityType.RELATIONSHIP);
                    if (index == IndexDescriptor.NO_INDEX) break block41;
                    long count2 = 0L;
                    try (DefaultRelationshipTypeIndexCursor relationshipsWithType = this.cursors.allocateRelationshipTypeIndexCursor(this.cursorContext());){
                        sourceNode = this.cursors.allocateNodeCursor(this.cursorContext());
                        try {
                            targetNode = this.cursors.allocateNodeCursor(this.cursorContext());
                            try {
                                TokenReadSession session = this.tokenReadSession(index);
                                this.relationshipTypeScan(session, relationshipsWithType, IndexQueryConstraints.unconstrained(), new TokenPredicate(typeId), this.cursorContext());
                            }
                            finally {
                                if (targetNode != null) {
                                    targetNode.close();
                                }
                            }
                        }
                        finally {
                            if (sourceNode != null) {
                                sourceNode.close();
                            }
                        }
                    }
                    return (count2 += AllStoreHolder.countRelationshipsWithEndLabels((RelationshipIndexCursor)relationshipsWithType, sourceNode, targetNode, startLabelId, endLabelId)) - this.countsForRelationshipInTxState(startLabelId, typeId, endLabelId);
                }
                catch (KernelException index) {
                    // empty catch block
                }
            }
        }
        try (DefaultRelationshipScanCursor rels = this.cursors.allocateRelationshipScanCursor(this.cursorContext());
             FullAccessNodeCursor sourceNode = this.cursors.allocateFullAccessNodeCursor(this.cursorContext());
             FullAccessNodeCursor targetNode = this.cursors.allocateFullAccessNodeCursor(this.cursorContext());){
            this.allRelationshipsScan(rels);
            Predicate<RelationshipScanCursor> predicate = typeId == -1 ? Predicates.alwaysTrue() : CursorPredicates.hasType(typeId);
            FilteringRelationshipScanCursorWrapper filteredCursor = new FilteringRelationshipScanCursorWrapper(rels, predicate);
            count = AllStoreHolder.countRelationshipsWithEndLabels(filteredCursor, (DefaultNodeCursor)sourceNode, (DefaultNodeCursor)targetNode, startLabelId, endLabelId);
        }
        return count - this.countsForRelationshipInTxState(startLabelId, typeId, endLabelId);
    }

    private static long countRelationshipsWithEndLabels(RelationshipIndexCursor relationship, DefaultNodeCursor sourceNode, DefaultNodeCursor targetNode, int startLabelId, int endLabelId) {
        long internalCount = 0L;
        while (relationship.next()) {
            if (!relationship.readFromStore() || !AllStoreHolder.matchesLabels((RelationshipDataAccessor)relationship, sourceNode, targetNode, startLabelId, endLabelId)) continue;
            ++internalCount;
        }
        return internalCount;
    }

    private static long countRelationshipsWithEndLabels(RelationshipScanCursor relationship, DefaultNodeCursor sourceNode, DefaultNodeCursor targetNode, int startLabelId, int endLabelId) {
        long internalCount = 0L;
        while (relationship.next()) {
            if (!AllStoreHolder.matchesLabels((RelationshipDataAccessor)relationship, sourceNode, targetNode, startLabelId, endLabelId)) continue;
            ++internalCount;
        }
        return internalCount;
    }

    private static boolean matchesLabels(RelationshipDataAccessor relationship, DefaultNodeCursor sourceNode, DefaultNodeCursor targetNode, int startLabelId, int endLabelId) {
        relationship.source((NodeCursor)sourceNode);
        relationship.target((NodeCursor)targetNode);
        return !(!sourceNode.next() || startLabelId != -1 && !sourceNode.hasLabel(startLabelId) || !targetNode.next() || endLabelId != -1 && !targetNode.hasLabel(endLabelId));
    }

    private long countsForRelationshipInTxState(int startLabelId, int typeId, int endLabelId) {
        long count = 0L;
        if (this.hasTxStateWithChanges()) {
            CountsDelta counts = new CountsDelta();
            try {
                TransactionState txState = this.txState();
                try (TransactionCountingStateVisitor countingVisitor = new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, this.storageReader, (ReadableTransactionState)txState, counts, this.cursorContext(), this.storageCursors);){
                    txState.accept((TxStateVisitor)countingVisitor);
                }
                if (counts.hasChanges()) {
                    count += counts.relationshipCount(startLabelId, typeId, endLabelId, this.cursorContext());
                }
            }
            catch (KernelException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    IndexDescriptor findUsableTokenIndex(EntityType entityType) throws IndexNotFoundKernelException {
        AnyTokenSchemaDescriptor descriptor = SchemaDescriptors.forAnyEntityTokens((EntityType)entityType);
        IndexDescriptor index = this.index((SchemaDescriptor)descriptor, IndexType.LOOKUP);
        if (index != IndexDescriptor.NO_INDEX && this.indexGetState(index) == InternalIndexState.ONLINE) {
            return index;
        }
        return IndexDescriptor.NO_INDEX;
    }

    public boolean relationshipExists(long reference) {
        this.performCheckBeforeOperation();
        if (this.hasTxStateWithChanges()) {
            TransactionState txState = this.txState();
            if (txState.relationshipIsDeletedInThisTx(reference)) {
                return false;
            }
            if (txState.relationshipIsAddedInThisTx(reference)) {
                return true;
            }
        }
        boolean existsInRelStore = this.storageReader.relationshipExists(reference, this.storageCursors);
        if (this.getAccessMode().allowsTraverseAllRelTypes()) {
            return existsInRelStore;
        }
        if (!existsInRelStore) {
            return false;
        }
        try (DefaultRelationshipScanCursor rels = this.cursors.allocateRelationshipScanCursor(this.cursorContext());){
            this.singleRelationship(reference, rels);
            boolean bl = rels.next();
            return bl;
        }
    }

    @Override
    public ValueIndexReader newValueIndexReader(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return this.indexingService.getIndexProxy(index).newValueReader();
    }

    public TokenIndexReader newTokenIndexReader(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return this.indexingService.getIndexProxy(index).newTokenReader();
    }

    public IndexReadSession indexReadSession(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return new DefaultIndexReadSession(this.valueIndexReaderCache.getOrCreate(index), index);
    }

    public TokenReadSession tokenReadSession(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return new DefaultTokenReadSession(this.tokenIndexReaderCache.getOrCreate(index), index);
    }

    public Iterator<IndexDescriptor> indexForSchemaNonTransactional(SchemaDescriptor schema) {
        return this.storageReader.indexGetForSchema(schema);
    }

    public IndexDescriptor indexForSchemaAndIndexTypeNonTransactional(SchemaDescriptor schema, IndexType indexType) {
        IndexDescriptor index = this.storageReader.indexGetForSchemaAndType(schema, indexType);
        return index == null ? IndexDescriptor.NO_INDEX : index;
    }

    public Iterator<IndexDescriptor> indexForSchemaNonLocking(SchemaDescriptor schema) {
        return this.indexGetForSchema((StorageSchemaReader)this.storageReader, schema);
    }

    public Iterator<IndexDescriptor> getLabelIndexesNonLocking(int labelId) {
        return this.indexesGetForLabel((StorageSchemaReader)this.storageReader, labelId);
    }

    public Iterator<IndexDescriptor> getRelTypeIndexesNonLocking(int relTypeId) {
        return this.indexesGetForRelationshipType((StorageSchemaReader)this.storageReader, relTypeId);
    }

    public Iterator<IndexDescriptor> indexesGetAllNonLocking() {
        return this.indexesGetAll((StorageSchemaReader)this.storageReader);
    }

    private IndexDescriptor lockIndex(IndexDescriptor index) {
        if (index == null) {
            return IndexDescriptor.NO_INDEX;
        }
        if (!this.indexExists(index = this.acquireSharedSchemaLock(index))) {
            this.releaseSharedSchemaLock(index);
            index = IndexDescriptor.NO_INDEX;
        }
        return index;
    }

    private Iterator<IndexDescriptor> lockIndexes(Iterator<IndexDescriptor> indexes) {
        Predicate<IndexDescriptor> exists = index -> index != IndexDescriptor.NO_INDEX;
        return Iterators.filter(exists, (Iterator)Iterators.map(this::lockIndex, indexes));
    }

    private boolean indexExists(IndexDescriptor index) {
        if (this.hasTxStateWithChanges()) {
            DiffSets changes = this.txState().indexChanges();
            return changes.isAdded((Object)index) || this.storageReader.indexExists(index) && !changes.isRemoved((Object)index);
        }
        return this.storageReader.indexExists(index);
    }

    public void assertIndexExists(IndexDescriptor index) throws IndexNotFoundKernelException {
        if (!this.indexExists(index)) {
            throw new IndexNotFoundKernelException("Index does not exist: ", index);
        }
    }

    private ConstraintDescriptor lockConstraint(ConstraintDescriptor constraint) {
        if (constraint == null) {
            return null;
        }
        if (!this.constraintExists(constraint = this.acquireSharedSchemaLock(constraint))) {
            this.releaseSharedSchemaLock(constraint);
            constraint = null;
        }
        return constraint;
    }

    private Iterator<ConstraintDescriptor> lockConstraints(Iterator<ConstraintDescriptor> constraints) {
        return Iterators.filter(Objects::nonNull, (Iterator)Iterators.map(this::lockConstraint, constraints));
    }

    public boolean constraintExists(ConstraintDescriptor constraint) {
        this.acquireSharedSchemaLock(constraint);
        this.performCheckBeforeOperation();
        if (this.hasTxStateWithChanges()) {
            DiffSets changes = this.txState().constraintsChanges();
            return changes.isAdded((Object)constraint) || this.storageReader.constraintExists(constraint) && !changes.isRemoved((Object)constraint);
        }
        return this.storageReader.constraintExists(constraint);
    }

    public Iterator<IndexDescriptor> index(SchemaDescriptor schema) {
        this.performCheckBeforeOperation();
        return this.lockIndexes(this.indexGetForSchema((StorageSchemaReader)this.storageReader, schema));
    }

    Iterator<IndexDescriptor> indexGetForSchema(StorageSchemaReader reader, SchemaDescriptor schema) {
        Iterator indexes = reader.indexGetForSchema(schema);
        if (this.hasTxStateWithChanges()) {
            DiffSets diffSets = this.txState().indexDiffSetsBySchema(schema);
            indexes = diffSets.apply(indexes);
        }
        return indexes;
    }

    public IndexDescriptor index(SchemaDescriptor schema, IndexType type) {
        this.performCheckBeforeOperation();
        return this.lockIndex(this.indexGetForSchemaAndType((StorageSchemaReader)this.storageReader, schema, type));
    }

    IndexDescriptor indexGetForSchemaAndType(StorageSchemaReader reader, SchemaDescriptor schema, IndexType type) {
        IndexDescriptor index = reader.indexGetForSchemaAndType(schema, type);
        if (this.hasTxStateWithChanges()) {
            DiffSets indexChanges = this.txState().indexChanges();
            if (index == null) {
                Set added = indexChanges.filterAdded(id -> id.getIndexType() == type && id.schema().equals(schema)).getAdded();
                index = (IndexDescriptor)Iterators.singleOrNull(added.iterator());
            }
            if (indexChanges.isRemoved((Object)index)) {
                return null;
            }
        }
        return index;
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        this.acquireSharedLock((ResourceType)ResourceTypes.LABEL, labelId);
        this.performCheckBeforeOperation();
        return this.lockIndexes(this.indexesGetForLabel((StorageSchemaReader)this.storageReader, labelId));
    }

    Iterator<IndexDescriptor> indexesGetForLabel(StorageSchemaReader reader, int labelId) {
        if (this.getAccessMode().allowsTraverseNode(new long[]{labelId})) {
            Iterator iterator = reader.indexesGetForLabel(labelId);
            if (this.hasTxStateWithChanges()) {
                iterator = this.txState().indexDiffSetsByLabel(labelId).apply(iterator);
            }
            return iterator;
        }
        return Collections.emptyIterator();
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        this.acquireSharedLock((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, relationshipType);
        this.performCheckBeforeOperation();
        return this.lockIndexes(this.indexesGetForRelationshipType((StorageSchemaReader)this.storageReader, relationshipType));
    }

    Iterator<IndexDescriptor> indexesGetForRelationshipType(StorageSchemaReader reader, int relationshipType) {
        Iterator iterator = reader.indexesGetForRelationshipType(relationshipType);
        if (this.hasTxStateWithChanges()) {
            iterator = this.txState().indexDiffSetsByRelationshipType(relationshipType).apply(iterator);
        }
        return iterator;
    }

    public IndexDescriptor indexGetForName(String name) {
        return this.indexGetForName((StorageSchemaReader)this.storageReader, name);
    }

    IndexDescriptor indexGetForName(StorageSchemaReader reader, String name) {
        this.performCheckBeforeOperation();
        IndexDescriptor index = reader.indexGetForName(name);
        if (this.hasTxStateWithChanges()) {
            Predicate<IndexDescriptor> namePredicate = indexDescriptor -> indexDescriptor.getName().equals(name);
            Iterator indexes = this.txState().indexChanges().filterAdded(namePredicate).apply(Iterators.iterator((Object)index));
            index = (IndexDescriptor)Iterators.singleOrNull((Iterator)indexes);
        }
        return this.lockIndex(index);
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        return this.constraintGetForName((StorageSchemaReader)this.storageReader, name);
    }

    ConstraintDescriptor constraintGetForName(StorageSchemaReader reader, String name) {
        this.performCheckBeforeOperation();
        ConstraintDescriptor constraint = reader.constraintGetForName(name);
        if (this.hasTxStateWithChanges()) {
            Predicate<ConstraintDescriptor> namePredicate = constraintDescriptor -> constraintDescriptor.getName().equals(name);
            Iterator constraints = this.txState().constraintsChanges().filterAdded(namePredicate).apply(Iterators.iterator((Object)constraint));
            constraint = (ConstraintDescriptor)Iterators.singleOrNull((Iterator)constraints);
        }
        return this.lockConstraint(constraint);
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        this.performCheckBeforeOperation();
        Iterator<IndexDescriptor> iterator = this.indexesGetAll((StorageSchemaReader)this.storageReader);
        return this.lockIndexes(iterator);
    }

    Iterator<IndexDescriptor> indexesGetAll(StorageSchemaReader reader) {
        Iterator iterator = reader.indexesGetAll();
        if (this.hasTxStateWithChanges()) {
            iterator = this.txState().indexChanges().apply(iterator);
        }
        return iterator;
    }

    public InternalIndexState indexGetState(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        this.performCheckBeforeOperation();
        return this.indexGetStateLocked(index);
    }

    public InternalIndexState indexGetStateNonLocking(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.performCheckBeforeOperation();
        return this.indexGetStateLocked(index);
    }

    InternalIndexState indexGetStateLocked(IndexDescriptor index) throws IndexNotFoundKernelException {
        SchemaDescriptor schema = index.schema();
        if (this.hasTxStateWithChanges() && AllStoreHolder.checkIndexState(index, (DiffSets<IndexDescriptor>)this.txState().indexDiffSetsBySchema(schema))) {
            return InternalIndexState.POPULATING;
        }
        return this.indexingService.getIndexProxy(index).getState();
    }

    public PopulationProgress indexGetPopulationProgress(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        this.performCheckBeforeOperation();
        return this.indexGetPopulationProgressLocked(index);
    }

    PopulationProgress indexGetPopulationProgressLocked(IndexDescriptor index) throws IndexNotFoundKernelException {
        if (this.hasTxStateWithChanges() && AllStoreHolder.checkIndexState(index, (DiffSets<IndexDescriptor>)this.txState().indexDiffSetsBySchema(index.schema()))) {
            return PopulationProgress.NONE;
        }
        return this.indexingService.getIndexProxy(index).getIndexPopulationProgress();
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        this.acquireSharedSchemaLock(index);
        this.performCheckBeforeOperation();
        return this.storageReader.indexGetOwningUniquenessConstraintId(this.storageReader.indexGetForName(index.getName()));
    }

    public String indexGetFailure(IndexDescriptor index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return this.indexingService.getIndexProxy(index).getPopulationFailure().asString();
    }

    public double indexUniqueValuesSelectivity(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.performCheckBeforeOperation();
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        this.assertIndexExists(index);
        IndexSample indexSample = this.indexStatisticsStore.indexSample(index.getId());
        long unique = indexSample.uniqueValues();
        long size = indexSample.sampleSize();
        return size == 0L ? 1.0 : (double)unique / (double)size;
    }

    public long indexSize(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.performCheckBeforeOperation();
        AllStoreHolder.assertValidIndex(index);
        this.acquireSharedSchemaLock(index);
        return this.indexStatisticsStore.indexSample(index.getId()).indexSize();
    }

    public long nodesGetCount() {
        return this.countsForNode(-1);
    }

    public long relationshipsGetCount() {
        return this.countsForRelationship(-1, -1, -1);
    }

    public IndexSample indexSample(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.performCheckBeforeOperation();
        AllStoreHolder.assertValidIndex(index);
        return this.indexStatisticsStore.indexSample(index.getId());
    }

    private static boolean checkIndexState(IndexDescriptor index, DiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded((Object)index)) {
            return true;
        }
        if (diffSet.isRemoved((Object)index)) {
            throw new IndexNotFoundKernelException("Index has been dropped in this transaction: ", index);
        }
        return false;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor schema) {
        this.acquireSharedSchemaLock(() -> schema);
        return this.getConstraintsForSchema(schema);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchemaNonLocking(SchemaDescriptor schema) {
        return this.getConstraintsForSchema(schema);
    }

    private Iterator<ConstraintDescriptor> getConstraintsForSchema(SchemaDescriptor schema) {
        this.performCheckBeforeOperation();
        Iterator constraints = this.storageReader.constraintsGetForSchema(schema);
        if (this.hasTxStateWithChanges()) {
            return this.txState().constraintsChangesForSchema(schema).apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        this.performCheckBeforeOperation();
        this.acquireSharedLock((ResourceType)ResourceTypes.LABEL, labelId);
        return this.constraintsGetForLabel((StorageSchemaReader)this.storageReader, labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabelNonLocking(int labelId) {
        this.performCheckBeforeOperation();
        return this.constraintsGetForLabel((StorageSchemaReader)this.storageReader, labelId);
    }

    Iterator<ConstraintDescriptor> constraintsGetForLabel(StorageSchemaReader reader, int labelId) {
        Iterator constraints = reader.constraintsGetForLabel(labelId);
        if (this.hasTxStateWithChanges()) {
            return this.txState().constraintsChangesForLabel(labelId).apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        this.performCheckBeforeOperation();
        Iterator<ConstraintDescriptor> constraints = this.constraintsGetAll((StorageSchemaReader)this.storageReader);
        return this.lockConstraints(constraints);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAllNonLocking() {
        this.performCheckBeforeOperation();
        return this.constraintsGetAll((StorageSchemaReader)this.storageReader);
    }

    Iterator<ConstraintDescriptor> constraintsGetAll(StorageSchemaReader reader) {
        Iterator constraints = reader.constraintsGetAll();
        if (this.hasTxStateWithChanges()) {
            constraints = this.txState().constraintsChanges().apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        this.performCheckBeforeOperation();
        this.acquireSharedLock((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, typeId);
        return this.constraintsGetForRelationshipType((StorageSchemaReader)this.storageReader, typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipTypeNonLocking(int typeId) {
        this.performCheckBeforeOperation();
        return this.constraintsGetForRelationshipType((StorageSchemaReader)this.storageReader, typeId);
    }

    Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(StorageSchemaReader reader, int typeId) {
        Iterator constraints = reader.constraintsGetForRelationshipType(typeId);
        if (this.hasTxStateWithChanges()) {
            return this.txState().constraintsChangesForRelationshipType(typeId).apply(constraints);
        }
        return constraints;
    }

    public SchemaReadCore snapshot() {
        this.performCheckBeforeOperation();
        StorageSchemaReader snapshot = this.storageReader.schemaSnapshot();
        return new SchemaReadCoreSnapshot(snapshot, this);
    }

    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return (V)this.schemaState.getOrCreate(key, creator);
    }

    public void schemaStateFlush() {
        this.schemaState.clear();
    }

    public boolean transactionStateHasChanges() {
        return this.hasTxStateWithChanges();
    }

    static void assertValidIndex(IndexDescriptor index) throws IndexNotFoundKernelException {
        if (index == IndexDescriptor.NO_INDEX) {
            throw new IndexNotFoundKernelException("No index was found");
        }
    }

    public void release() {
        this.valueIndexReaderCache.close();
        this.tokenIndexReaderCache.close();
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }

    public IndexMonitor monitor() {
        return this.indexingService.getMonitor();
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallRead(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.procedureCaller().callProcedure(id, arguments, AccessMode.Static.READ, context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallWrite(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.procedureCaller().callProcedure(id, arguments, AccessMode.Static.TOKEN_WRITE, context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallSchema(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.procedureCaller().callProcedure(id, arguments, AccessMode.Static.SCHEMA, context);
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallDbms(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.procedureCaller().callProcedure(id, arguments, AccessMode.Static.ACCESS, context);
    }

    public AnyValue functionCall(int id, AnyValue[] arguments) throws ProcedureException {
        return this.procedureCaller().callFunction(id, arguments);
    }

    public AnyValue builtInFunctionCall(int id, AnyValue[] arguments) throws ProcedureException {
        return this.procedureCaller().callBuiltInFunction(id, arguments);
    }

    public UserAggregationReducer aggregationFunction(int id) throws ProcedureException {
        return this.procedureCaller().createAggregationFunction(id);
    }

    public UserAggregationReducer builtInAggregationFunction(int id) throws ProcedureException {
        return this.procedureCaller().createBuiltInAggregationFunction(id);
    }

    public UserFunctionHandle functionGet(QualifiedName name) {
        this.performCheckBeforeOperation();
        return this.globalProcedures.function(name);
    }

    public Stream<UserFunctionSignature> functionGetAll() {
        this.performCheckBeforeOperation();
        return this.globalProcedures.getAllNonAggregatingFunctions();
    }

    public ProcedureHandle procedureGet(QualifiedName name) throws ProcedureException {
        this.performCheckBeforeOperation();
        return this.globalProcedures.procedure(name);
    }

    public Set<ProcedureSignature> proceduresGetAll() {
        this.performCheckBeforeOperation();
        return this.globalProcedures.getAllProcedures();
    }

    public UserFunctionHandle aggregationFunctionGet(QualifiedName name) {
        this.performCheckBeforeOperation();
        return this.globalProcedures.aggregationFunction(name);
    }

    public Stream<UserFunctionSignature> aggregationFunctionGetAll() {
        this.performCheckBeforeOperation();
        return this.globalProcedures.getAllAggregatingFunctions();
    }

    abstract ProcedureCaller procedureCaller();

    public static class ForThreadExecutionContextScope
    extends AllStoreHolder {
        private final OverridableSecurityContext overridableSecurityContext;
        private final CursorContext cursorContext;
        private final Locks.Client lockClient;
        private final AssertOpen assertOpen;
        private final ProcedureCaller procedureCaller;

        public ForThreadExecutionContextScope(ThreadExecutionContext executionContext, StorageReader storageReader, SchemaState schemaState, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, GlobalProcedures globalProcedures, Dependencies databaseDependencies, DefaultPooledCursors cursors, StoreCursors storageCursors, CursorContext cursorContext, StorageLocks storageLocks, Locks.Client lockClient, LockTracer lockTracer, OverridableSecurityContext overridableSecurityContext, AssertOpen assertOpen, SecurityAuthorizationHandler securityAuthorizationHandler, Supplier<ClockContext> clockContextSupplier) {
            super(storageReader, executionContext.tokenRead(), schemaState, indexingService, indexStatisticsStore, globalProcedures, executionContext.memoryTracker(), cursors, storageCursors, storageLocks, lockTracer);
            this.overridableSecurityContext = overridableSecurityContext;
            this.cursorContext = cursorContext;
            this.lockClient = lockClient;
            this.assertOpen = assertOpen;
            this.procedureCaller = new ProcedureCaller.ForThreadExecutionContextScope(executionContext, globalProcedures, (DependencyResolver)databaseDependencies, overridableSecurityContext, assertOpen, securityAuthorizationHandler, clockContextSupplier);
        }

        @Override
        public long lockingNodeUniqueIndexSeek(IndexDescriptor index, NodeValueIndexCursor cursor, PropertyIndexQuery.ExactPredicate ... predicates) {
            throw new UnsupportedOperationException("Locking unique index seek not allowed during parallel execution");
        }

        @Override
        public TransactionState txState() {
            throw new UnsupportedOperationException("Accessing transaction state is not allowed during parallel execution");
        }

        @Override
        public boolean hasTxStateWithChanges() {
            return false;
        }

        @Override
        void performCheckBeforeOperation() {
            this.assertOpen.assertOpen();
        }

        @Override
        AccessMode getAccessMode() {
            return this.overridableSecurityContext.currentSecurityContext().mode();
        }

        @Override
        Locks.Client getLockClient() {
            return this.lockClient;
        }

        public CursorContext cursorContext() {
            return this.cursorContext;
        }

        @Override
        ProcedureCaller procedureCaller() {
            return this.procedureCaller;
        }
    }

    public static class ForTransactionScope
    extends AllStoreHolder {
        private final KernelTransactionImplementation ktx;
        private final ProcedureCaller procedureCaller;

        public ForTransactionScope(StorageReader storageReader, TokenRead tokenRead, KernelTransactionImplementation ktx, StorageLocks storageLocks, DefaultPooledCursors cursors, GlobalProcedures globalProcedures, SchemaState schemaState, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, Dependencies databaseDependencies, MemoryTracker memoryTracker) {
            super(storageReader, tokenRead, schemaState, indexingService, indexStatisticsStore, globalProcedures, memoryTracker, cursors, ktx.storeCursors(), storageLocks, ktx.lockTracer());
            this.ktx = ktx;
            this.procedureCaller = new ProcedureCaller.ForTransactionScope(ktx, globalProcedures, (DependencyResolver)databaseDependencies);
        }

        @Override
        public TransactionState txState() {
            return this.ktx.txState();
        }

        @Override
        public boolean hasTxStateWithChanges() {
            return this.ktx.hasTxStateWithChanges();
        }

        @Override
        void performCheckBeforeOperation() {
            if (ParallelAccessCheck.shouldPerformCheck()) {
                ParallelAccessCheck.checkNotCypherWorkerThread();
            }
            this.ktx.assertOpen();
        }

        @Override
        AccessMode getAccessMode() {
            return this.ktx.securityContext().mode();
        }

        @Override
        Locks.Client getLockClient() {
            return this.ktx.lockClient();
        }

        public CursorContext cursorContext() {
            return this.ktx.cursorContext();
        }

        @Override
        ProcedureCaller procedureCaller() {
            return this.procedureCaller;
        }
    }
}

