/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.helpers.Nodes;
import org.neo4j.kernel.impl.core.AbstractEntity;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipSelection;

public abstract class AbstractNodeEntity
extends AbstractEntity
implements Node {
    public ResourceIterable<Relationship> getRelationships() {
        return this.getRelationships(Direction.BOTH);
    }

    public ResourceIterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.getRelationships(Direction.BOTH, types);
    }

    public boolean hasRelationship() {
        return this.hasRelationship(Direction.BOTH);
    }

    public boolean hasRelationship(RelationshipType ... types) {
        return this.hasRelationship(Direction.BOTH, types);
    }

    protected Relationship getSingleRelationship(ResourceIterator<Relationship> relationships, RelationshipType type, Direction dir) {
        if (!relationships.hasNext()) {
            return null;
        }
        Relationship rel = (Relationship)relationships.next();
        if (relationships.hasNext()) {
            throw new NotFoundException("More than one relationship[" + type + ", " + dir + "] found for " + this);
        }
        return rel;
    }

    protected Iterable<RelationshipType> getRelationshipTypes(NodeCursor nodes) {
        try {
            this.singleNode(nodes);
            Degrees degrees = nodes.degrees(RelationshipSelection.ALL_RELATIONSHIPS);
            ArrayList<RelationshipType> types = new ArrayList<RelationshipType>();
            for (int type : degrees.types()) {
                if (degrees.totalDegree(type) <= 0) continue;
                types.add(RelationshipType.withName((String)this.tokenRead().relationshipTypeName(type)));
            }
            return types;
        }
        catch (KernelException e) {
            throw new NotFoundException("Relationship name not found.", (Throwable)e);
        }
    }

    protected static int[] relTypeIds(TokenRead token, RelationshipType ... types) {
        int[] ids = new int[types.length];
        int outIndex = 0;
        for (RelationshipType type : types) {
            int id = token.relationshipType(type.name());
            if (id == -1) continue;
            ids[outIndex++] = id;
        }
        if (outIndex != ids.length) {
            ids = Arrays.copyOf(ids, outIndex);
        }
        return ids;
    }

    protected int getDegree(NodeCursor nodes) {
        this.singleNode(nodes);
        return Nodes.countAll((NodeCursor)nodes);
    }

    protected int getDegree(RelationshipType type, NodeCursor nodes) {
        int typeId = this.tokenRead().relationshipType(type.name());
        if (typeId == -1) {
            return 0;
        }
        this.singleNode(nodes);
        return Nodes.countAll((NodeCursor)nodes, (int)typeId);
    }

    protected int getDegree(Direction direction, NodeCursor nodes) {
        this.singleNode(nodes);
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.OUTGOING -> Nodes.countOutgoing((NodeCursor)nodes);
            case Direction.INCOMING -> Nodes.countIncoming((NodeCursor)nodes);
            case Direction.BOTH -> Nodes.countAll((NodeCursor)nodes);
        };
    }

    protected int getDegree(RelationshipType type, Direction direction, NodeCursor nodes) {
        int typeId = this.tokenRead().relationshipType(type.name());
        if (typeId == -1) {
            return 0;
        }
        this.singleNode(nodes);
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.OUTGOING -> Nodes.countOutgoing((NodeCursor)nodes, (int)typeId);
            case Direction.INCOMING -> Nodes.countIncoming((NodeCursor)nodes, (int)typeId);
            case Direction.BOTH -> Nodes.countAll((NodeCursor)nodes, (int)typeId);
        };
    }

    protected boolean hasLabel(Label label, NodeCursor nodes) {
        int labelId = this.tokenRead().nodeLabel(label.name());
        if (labelId == -1) {
            return false;
        }
        this.singleNode(nodes);
        return nodes.hasLabel(labelId);
    }

    public Iterable<Label> getLabels(NodeCursor nodes) {
        try {
            this.singleNode(nodes);
            TokenSet tokenSet = nodes.labels();
            TokenRead tokenRead = this.tokenRead();
            ArrayList<Label> list = new ArrayList<Label>(tokenSet.numberOfTokens());
            for (int i = 0; i < tokenSet.numberOfTokens(); ++i) {
                list.add(Label.label((String)tokenRead.nodeLabelName(tokenSet.token(i))));
            }
            return list;
        }
        catch (LabelNotFoundKernelException e) {
            throw new IllegalStateException("Label retrieved through kernel API should exist.", e);
        }
    }

    @Override
    protected abstract TokenRead tokenRead();

    protected abstract void singleNode(NodeCursor var1);
}

