/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public final class EntryCountThreshold
implements Threshold {
    private final long maxLogEntries;
    private final InternalLog log;

    EntryCountThreshold(InternalLogProvider logProvider, long maxLogEntries) {
        this.log = logProvider.getLog(this.getClass());
        this.maxLogEntries = maxLogEntries;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean reached(Path ignored, long version, LogFileInformation source) {
        try {
            long lastAppendIndex = source.getFirstEntryAppendIndex(version);
            if (lastAppendIndex == -1L) {
                this.log.warn("Failed to get append index of the first entry in the transaction log file. Requested version: " + version);
                return false;
            }
            long highestAppendIndex = source.getLastEntryAppendIndex();
            return highestAppendIndex - lastAppendIndex >= this.maxLogEntries;
        }
        catch (IOException e) {
            this.log.warn("Error on attempt to get entry append indexes from transaction log files. Checked version: " + version, (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return this.maxLogEntries + " entries";
    }
}

