/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.index.schema.TokenScanValueIndexProgressor;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.InternalTokenIndexCursor;
import org.neo4j.kernel.impl.newapi.PrimitiveSortedMergeJoin;

abstract class DefaultEntityTokenIndexCursor<SELF extends DefaultEntityTokenIndexCursor<SELF>>
extends IndexCursor<IndexProgressor, SELF>
implements InternalTokenIndexCursor {
    protected Read read;
    protected TxStateHolder txStateHolder;
    protected AccessModeProvider accessModeProvider;
    protected long entity = -1L;
    protected long entityFromIndex;
    protected int tokenId;
    protected IndexOrder order = IndexOrder.ASCENDING;
    private PeekableLongIterator added;
    private LongSet removed;
    private boolean useMergeSort;
    private final PrimitiveSortedMergeJoin sortedMergeJoin = new PrimitiveSortedMergeJoin();
    private boolean shortcutSecurity;
    private final boolean applyAccessModeToTxState;

    DefaultEntityTokenIndexCursor(CursorPool<SELF> pool, boolean applyAccessModeToTxState) {
        super(pool);
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    @Override
    public abstract void release();

    protected abstract boolean innerNext();

    protected abstract LongIterator createAddedInTxState(TransactionState var1, int var2, IndexOrder var3);

    protected abstract LongSet createDeletedInTxState(TransactionState var1, int var2);

    protected abstract void traceScan(KernelReadTracer var1, int var2);

    protected abstract void traceNext(KernelReadTracer var1, long var2);

    protected abstract boolean allowedToSeeAllEntitiesWithToken(int var1);

    protected abstract boolean allowedToSeeEntity(long var1);

    private PeekableLongIterator peekable(LongIterator actual) {
        return actual != null ? new PeekableLongIterator(actual) : null;
    }

    public void initializeQuery(IndexProgressor progressor, int token, IndexOrder order) {
        this.initialize(progressor);
        if (this.txStateHolder.hasTxStateWithChanges()) {
            this.added = this.peekable(this.createAddedInTxState(this.txStateHolder.txState(), token, order));
            this.removed = this.createDeletedInTxState(this.txStateHolder.txState(), token);
            boolean bl = this.useMergeSort = order != IndexOrder.NONE;
            if (this.useMergeSort) {
                this.sortedMergeJoin.initialize(order);
            }
        } else {
            this.useMergeSort = false;
        }
        this.tokenId = token;
        this.initSecurity(token);
        if (this.tracer != null) {
            this.traceScan(this.tracer, token);
        }
        this.order = order;
    }

    public void initializeQuery(IndexProgressor progressor, int token, LongIterator added, LongSet removed) {
        this.initialize(progressor);
        this.useMergeSort = false;
        this.added = this.peekable(added);
        this.removed = removed;
        this.tokenId = token;
        this.initSecurity(token);
        if (this.tracer != null) {
            this.traceScan(this.tracer, token);
        }
    }

    public boolean acceptEntity(long reference, int tokenId) {
        if (this.isRemoved(reference) || !this.allowed(reference)) {
            return false;
        }
        this.entityFromIndex = reference;
        this.tokenId = tokenId;
        return true;
    }

    public boolean next() {
        boolean hasNext;
        this.entity = -1L;
        this.entityFromIndex = -1L;
        boolean bl = hasNext = this.useMergeSort ? this.nextWithOrdering() : this.nextWithoutOrder();
        if (hasNext && this.tracer != null) {
            this.traceNext(this.tracer, this.entity);
        }
        return hasNext;
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.closeProgressor();
            this.entity = -1L;
            this.entityFromIndex = -1L;
            this.tokenId = -1;
            this.read = null;
            this.txStateHolder = null;
            this.accessModeProvider = null;
            this.added = null;
            this.removed = null;
        }
        super.closeInternal();
    }

    public boolean isClosed() {
        return this.isProgressorClosed();
    }

    @Override
    public void initState(Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.read = read;
        this.txStateHolder = txStateHolder;
        this.accessModeProvider = accessModeProvider;
    }

    public long entityReference() {
        return this.entity;
    }

    protected boolean allowed(long reference) {
        return this.shortcutSecurity || this.allowedToSeeEntity(reference);
    }

    protected long nextEntity() {
        return this.entityFromIndex;
    }

    private void initSecurity(int token) {
        this.shortcutSecurity = this.allowedToSeeAllEntitiesWithToken(token);
    }

    private boolean nextWithoutOrder() {
        long next;
        if (this.added != null && this.added.hasNext()) {
            while (this.added.hasNext()) {
                next = this.added.next();
                if (this.applyAccessModeToTxState && !this.allowed(next)) continue;
                this.entity = next;
                break;
            }
        }
        if (this.entity == -1L) {
            while (this.innerNext()) {
                next = this.nextEntity();
                if (this.applyAccessModeToTxState && !this.allowed(next)) continue;
                this.entity = next;
                break;
            }
        }
        return this.entity != -1L;
    }

    private boolean nextWithOrdering() {
        long nextId;
        if (this.sortedMergeJoin.needsA() && this.added.hasNext()) {
            while (this.added.hasNext()) {
                long next = this.added.next();
                if (this.applyAccessModeToTxState && !this.allowed(next)) continue;
                this.sortedMergeJoin.setA(next);
                break;
            }
        }
        if (this.sortedMergeJoin.needsB()) {
            while (this.innerNext()) {
                if (this.applyAccessModeToTxState && !this.allowed(this.entityFromIndex)) continue;
                this.sortedMergeJoin.setB(this.entityFromIndex);
                break;
            }
        }
        if ((nextId = this.sortedMergeJoin.next()) == -1L) {
            return false;
        }
        this.entity = nextId;
        return true;
    }

    private boolean isRemoved(long reference) {
        return this.removed != null && this.removed.contains(reference);
    }

    protected static LongIterator sortTxState(LongSet frozenAdded, IndexOrder order) {
        return switch (order) {
            default -> throw new IncompatibleClassChangeError();
            case IndexOrder.NONE -> frozenAdded.longIterator();
            case IndexOrder.ASCENDING, IndexOrder.DESCENDING -> DefaultEntityTokenIndexCursor.sorted(frozenAdded.toSortedArray(), order);
        };
    }

    private static LongIterator sorted(long[] items, IndexOrder order) {
        return IndexOrder.DESCENDING == order ? PrimitiveLongCollections.reverseIterator((long[])items) : PrimitiveLongCollections.iterator((long[])items);
    }

    public void skipUntil(long id) {
        TokenScanValueIndexProgressor indexProgressor = (TokenScanValueIndexProgressor)this.progressor;
        if (this.order == IndexOrder.NONE) {
            throw new IllegalStateException("IndexOrder " + String.valueOf(this.order) + " not supported for skipUntil");
        }
        if (this.added != null) {
            if (this.order != IndexOrder.DESCENDING) {
                while (this.added.hasNext() && this.added.peek() < id) {
                    this.added.next();
                }
            } else {
                while (this.added.hasNext() && this.added.peek() > id) {
                    this.added.next();
                }
            }
        }
        indexProgressor.skipUntil(id);
    }

    private static class PeekableLongIterator
    extends PrimitiveLongCollections.AbstractPrimitiveLongBaseIterator {
        private final LongIterator iterator;

        PeekableLongIterator(LongIterator iterator) {
            this.iterator = iterator;
        }

        protected boolean fetchNext() {
            return this.iterator.hasNext() && this.next(this.iterator.next());
        }

        public long peek() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.next;
        }
    }
}

